/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.Objects;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;

public abstract class LicensedFeature {
    final String name;
    final License.OperationMode minimumOperationMode;
    final boolean needsActive;

    public LicensedFeature(String name, License.OperationMode minimumOperationMode, boolean needsActive) {
        this.name = name;
        this.minimumOperationMode = minimumOperationMode;
        this.needsActive = needsActive;
    }

    public static Momentary momentary(String name, License.OperationMode licenseLevel) {
        return new Momentary(name, licenseLevel, true);
    }

    public static Persistent persistent(String name, License.OperationMode licenseLevel) {
        return new Persistent(name, licenseLevel, true);
    }

    @Deprecated
    public static Momentary momentaryLenient(String name, License.OperationMode licenseLevel) {
        return new Momentary(name, licenseLevel, false);
    }

    @Deprecated
    public static Persistent persistentLenient(String name, License.OperationMode licenseLevel) {
        return new Persistent(name, licenseLevel, false);
    }

    public final boolean checkWithoutTracking(XPackLicenseState state) {
        return state.isAllowed(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicensedFeature that = (LicensedFeature)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Momentary
    extends LicensedFeature {
        private Momentary(String name, License.OperationMode minimumOperationMode, boolean needsActive) {
            super(name, minimumOperationMode, needsActive);
        }

        public boolean check(XPackLicenseState state) {
            if (state.isAllowed(this)) {
                state.featureUsed(this);
                return true;
            }
            return false;
        }
    }

    public static class Persistent
    extends LicensedFeature {
        private Persistent(String name, License.OperationMode minimumOperationMode, boolean needsActive) {
            super(name, minimumOperationMode, needsActive);
        }

        public boolean checkAndStartTracking(XPackLicenseState state, String contextName) {
            if (state.isAllowed(this)) {
                state.enableUsageTracking(this, contextName);
                return true;
            }
            return false;
        }

        public void stopTracking(XPackLicenseState state, String contextName) {
            state.disableUsageTracking(this, contextName);
        }
    }
}

