/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.frozen;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;

public class FreezeRequest
extends AcknowledgedRequest<FreezeRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private boolean freeze = true;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public FreezeRequest(String ... indices) {
        this.indices = indices;
    }

    public FreezeRequest(StreamInput in) throws IOException {
        super(in);
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        this.indices = in.readStringArray();
        this.freeze = in.readBoolean();
        this.waitForActiveShards = ActiveShardCount.readFrom((StreamInput)in);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (CollectionUtils.isEmpty((Object[])this.indices)) {
            validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
        }
        return validationException;
    }

    public FreezeRequest setFreeze(boolean freeze) {
        this.freeze = freeze;
        return this;
    }

    public boolean freeze() {
        return this.freeze;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeStringArray(this.indices);
        out.writeBoolean(this.freeze);
        this.waitForActiveShards.writeTo(out);
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public FreezeRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public IndicesRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public FreezeRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }
}

