/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;

public class PutAutoFollowPatternAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "cluster:admin/xpack/ccr/auto_follow_pattern/put";
    public static final PutAutoFollowPatternAction INSTANCE = new PutAutoFollowPatternAction();
    private static final int MAX_NAME_BYTES = 255;

    private PutAutoFollowPatternAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private static final ObjectParser<PutAutoFollowPatternParameters, Void> PARSER = new ObjectParser("put_auto_follow_pattern_request", () -> new PutAutoFollowPatternParameters());
        private String name;
        private String remoteCluster;
        private List<String> leaderIndexPatterns;
        private String followIndexNamePattern;
        private Settings settings = Settings.EMPTY;
        private FollowParameters parameters = new FollowParameters();
        private List<String> leaderIndexExclusionPatterns = Collections.emptyList();

        public static Request fromXContent(XContentParser parser, String name) throws IOException {
            PutAutoFollowPatternParameters parameters = (PutAutoFollowPatternParameters)PARSER.parse(parser, null);
            Request request = new Request();
            request.setName(name);
            request.setRemoteCluster(parameters.remoteCluster);
            request.setLeaderIndexPatterns(parameters.leaderIndexPatterns);
            request.setFollowIndexNamePattern(parameters.followIndexNamePattern);
            if (parameters.leaderIndexExclusionPatterns != null) {
                request.setLeaderIndexExclusionPatterns(parameters.leaderIndexExclusionPatterns);
            }
            request.setSettings(parameters.settings);
            request.setParameters(parameters);
            return request;
        }

        public Request() {
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = this.parameters.validate();
            if (this.name == null) {
                validationException = ValidateActions.addValidationError((String)"[name] is missing", (ActionRequestValidationException)validationException);
            }
            if (this.name != null) {
                int byteCount;
                if (this.name.contains(",")) {
                    validationException = ValidateActions.addValidationError((String)"[name] name must not contain a ','", (ActionRequestValidationException)validationException);
                }
                if (this.name.startsWith("_")) {
                    validationException = ValidateActions.addValidationError((String)"[name] name must not start with '_'", (ActionRequestValidationException)validationException);
                }
                if ((byteCount = this.name.getBytes(StandardCharsets.UTF_8).length) > 255) {
                    validationException = ValidateActions.addValidationError((String)("[name] name is too long (" + byteCount + " > " + 255 + ")"), (ActionRequestValidationException)validationException);
                }
            }
            if (this.remoteCluster == null) {
                validationException = ValidateActions.addValidationError((String)("[" + AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD.getPreferredName() + "] is missing"), (ActionRequestValidationException)validationException);
            }
            if (this.leaderIndexPatterns == null || this.leaderIndexPatterns.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)("[" + AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD.getPreferredName() + "] is missing"), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public void setRemoteCluster(String remoteCluster) {
            this.remoteCluster = remoteCluster;
        }

        public List<String> getLeaderIndexPatterns() {
            return this.leaderIndexPatterns;
        }

        public void setLeaderIndexPatterns(List<String> leaderIndexPatterns) {
            this.leaderIndexPatterns = leaderIndexPatterns;
        }

        public List<String> getLeaderIndexExclusionPatterns() {
            return this.leaderIndexExclusionPatterns;
        }

        public void setLeaderIndexExclusionPatterns(List<String> leaderIndexExclusionPatterns) {
            this.leaderIndexExclusionPatterns = leaderIndexExclusionPatterns;
        }

        public String getFollowIndexNamePattern() {
            return this.followIndexNamePattern;
        }

        public void setFollowIndexNamePattern(String followIndexNamePattern) {
            this.followIndexNamePattern = followIndexNamePattern;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public void setSettings(Settings settings) {
            this.settings = Objects.requireNonNull(settings);
        }

        public FollowParameters getParameters() {
            return this.parameters;
        }

        public void setParameters(FollowParameters parameters) {
            this.parameters = parameters;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.remoteCluster = in.readString();
            this.leaderIndexPatterns = in.readStringList();
            this.followIndexNamePattern = in.readOptionalString();
            if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
                if (in.getVersion().onOrAfter(Version.V_7_9_0)) {
                    this.settings = Settings.readSettingsFromStream((StreamInput)in);
                }
                this.parameters = new FollowParameters(in);
            } else {
                this.settings = Settings.EMPTY;
                this.parameters = new FollowParameters();
                this.parameters.maxReadRequestOperationCount = in.readOptionalVInt();
                this.parameters.maxReadRequestSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
                this.parameters.maxOutstandingReadRequests = in.readOptionalVInt();
                this.parameters.maxWriteRequestOperationCount = in.readOptionalVInt();
                this.parameters.maxWriteRequestSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
                this.parameters.maxOutstandingWriteRequests = in.readOptionalVInt();
                this.parameters.maxWriteBufferCount = in.readOptionalVInt();
                this.parameters.maxWriteBufferSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
                this.parameters.maxRetryDelay = in.readOptionalTimeValue();
                this.parameters.readPollTimeout = in.readOptionalTimeValue();
            }
            this.parameters = new FollowParameters(in);
            if (in.getVersion().onOrAfter(Version.V_7_14_0)) {
                this.leaderIndexExclusionPatterns = in.readStringList();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeString(this.remoteCluster);
            out.writeStringCollection(this.leaderIndexPatterns);
            out.writeOptionalString(this.followIndexNamePattern);
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
                    Settings.writeSettingsToStream((Settings)this.settings, (StreamOutput)out);
                }
                this.parameters.writeTo(out);
            } else {
                out.writeOptionalVInt(this.parameters.maxReadRequestOperationCount);
                out.writeOptionalWriteable((Writeable)this.parameters.maxReadRequestSize);
                out.writeOptionalVInt(this.parameters.maxOutstandingReadRequests);
                out.writeOptionalVInt(this.parameters.maxWriteRequestOperationCount);
                out.writeOptionalWriteable((Writeable)this.parameters.maxWriteRequestSize);
                out.writeOptionalVInt(this.parameters.maxOutstandingWriteRequests);
                out.writeOptionalVInt(this.parameters.maxWriteBufferCount);
                out.writeOptionalWriteable((Writeable)this.parameters.maxWriteBufferSize);
                out.writeOptionalTimeValue(this.parameters.maxRetryDelay);
                out.writeOptionalTimeValue(this.parameters.readPollTimeout);
            }
            this.parameters.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_7_14_0)) {
                out.writeStringCollection(this.leaderIndexExclusionPatterns);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.field(AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD.getPreferredName(), this.leaderIndexPatterns);
            builder.field(AutoFollowMetadata.AutoFollowPattern.LEADER_EXCLUSION_PATTERNS_FIELD.getPreferredName(), this.leaderIndexExclusionPatterns);
            if (this.followIndexNamePattern != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.FOLLOW_PATTERN_FIELD.getPreferredName(), this.followIndexNamePattern);
            }
            if (!this.settings.isEmpty()) {
                builder.startObject(AutoFollowMetadata.AutoFollowPattern.SETTINGS_FIELD.getPreferredName());
                this.settings.toXContent(builder, params);
                builder.endObject();
            }
            this.parameters.toXContentFragment(builder);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.name, request.name) && Objects.equals(this.remoteCluster, request.remoteCluster) && Objects.equals(this.leaderIndexPatterns, request.leaderIndexPatterns) && Objects.equals(this.leaderIndexExclusionPatterns, request.leaderIndexExclusionPatterns) && Objects.equals(this.followIndexNamePattern, request.followIndexNamePattern) && Objects.equals(this.parameters, request.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.remoteCluster, this.leaderIndexPatterns, this.leaderIndexExclusionPatterns, this.followIndexNamePattern, this.parameters);
        }

        static {
            PARSER.declareString((params, value) -> ((PutAutoFollowPatternParameters)params).remoteCluster = value, AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD);
            PARSER.declareStringArray((params, value) -> ((PutAutoFollowPatternParameters)params).leaderIndexPatterns = value, AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD);
            PARSER.declareString((params, value) -> ((PutAutoFollowPatternParameters)params).followIndexNamePattern = value, AutoFollowMetadata.AutoFollowPattern.FOLLOW_PATTERN_FIELD);
            PARSER.declareObject((params, value) -> ((PutAutoFollowPatternParameters)params).settings = value, (p, c) -> Settings.fromXContent((XContentParser)p), AutoFollowMetadata.AutoFollowPattern.SETTINGS_FIELD);
            PARSER.declareStringArray((params, value) -> ((PutAutoFollowPatternParameters)params).leaderIndexExclusionPatterns = value, AutoFollowMetadata.AutoFollowPattern.LEADER_EXCLUSION_PATTERNS_FIELD);
            FollowParameters.initParser(PARSER);
        }

        private static class PutAutoFollowPatternParameters
        extends FollowParameters {
            private String remoteCluster;
            private List<String> leaderIndexPatterns;
            private String followIndexNamePattern;
            private Settings settings = Settings.EMPTY;
            private List<String> leaderIndexExclusionPatterns;

            private PutAutoFollowPatternParameters() {
            }
        }
    }
}

