/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ilm.Step;

public class LifecycleExecutionState {
    public static final String ILM_CUSTOM_METADATA_KEY = "ilm";
    private static final String PHASE = "phase";
    private static final String ACTION = "action";
    private static final String STEP = "step";
    private static final String INDEX_CREATION_DATE = "creation_date";
    private static final String PHASE_TIME = "phase_time";
    private static final String ACTION_TIME = "action_time";
    private static final String STEP_TIME = "step_time";
    private static final String FAILED_STEP = "failed_step";
    private static final String IS_AUTO_RETRYABLE_ERROR = "is_auto_retryable_error";
    private static final String FAILED_STEP_RETRY_COUNT = "failed_step_retry_count";
    private static final String STEP_INFO = "step_info";
    private static final String PHASE_DEFINITION = "phase_definition";
    private static final String SNAPSHOT_NAME = "snapshot_name";
    private static final String SNAPSHOT_REPOSITORY = "snapshot_repository";
    private static final String SNAPSHOT_INDEX_NAME = "snapshot_index_name";
    private static final String SHRINK_INDEX_NAME = "shrink_index_name";
    private static final String ROLLUP_INDEX_NAME = "rollup_index_name";
    private final String phase;
    private final String action;
    private final String step;
    private final String failedStep;
    private final Boolean isAutoRetryableError;
    private final Integer failedStepRetryCount;
    private final String stepInfo;
    private final String phaseDefinition;
    private final Long lifecycleDate;
    private final Long phaseTime;
    private final Long actionTime;
    private final Long stepTime;
    private final String snapshotName;
    private final String snapshotRepository;
    private final String shrinkIndexName;
    private final String snapshotIndexName;
    private final String rollupIndexName;

    private LifecycleExecutionState(String phase, String action, String step, String failedStep, Boolean isAutoRetryableError, Integer failedStepRetryCount, String stepInfo, String phaseDefinition, Long lifecycleDate, Long phaseTime, Long actionTime, Long stepTime, String snapshotRepository, String snapshotName, String shrinkIndexName, String snapshotIndexName, String rollupIndexName) {
        this.phase = phase;
        this.action = action;
        this.step = step;
        this.failedStep = failedStep;
        this.isAutoRetryableError = isAutoRetryableError;
        this.failedStepRetryCount = failedStepRetryCount;
        this.stepInfo = stepInfo;
        this.phaseDefinition = phaseDefinition;
        this.lifecycleDate = lifecycleDate;
        this.phaseTime = phaseTime;
        this.actionTime = actionTime;
        this.stepTime = stepTime;
        this.snapshotRepository = snapshotRepository;
        this.snapshotName = snapshotName;
        this.shrinkIndexName = shrinkIndexName;
        this.snapshotIndexName = snapshotIndexName;
        this.rollupIndexName = rollupIndexName;
    }

    public static LifecycleExecutionState fromIndexMetadata(IndexMetadata indexMetadata) {
        Map customData = indexMetadata.getCustomData(ILM_CUSTOM_METADATA_KEY);
        customData = customData == null ? new HashMap() : customData;
        return LifecycleExecutionState.fromCustomMetadata(customData);
    }

    public static boolean isFrozenPhase(IndexMetadata indexMetadata) {
        Map customData = indexMetadata.getCustomData(ILM_CUSTOM_METADATA_KEY);
        return customData != null && "frozen".equals(customData.get(PHASE));
    }

    @Nullable
    public static Step.StepKey getCurrentStepKey(LifecycleExecutionState lifecycleState) {
        Objects.requireNonNull(lifecycleState, "cannot determine current step key as lifecycle state is null");
        String currentPhase = lifecycleState.getPhase();
        String currentAction = lifecycleState.getAction();
        String currentStep = lifecycleState.getStep();
        if (Strings.isNullOrEmpty((String)currentStep)) {
            assert (Strings.isNullOrEmpty((String)currentPhase)) : "Current phase is not empty: " + currentPhase;
            assert (Strings.isNullOrEmpty((String)currentAction)) : "Current action is not empty: " + currentAction;
            return null;
        }
        assert (!Strings.isNullOrEmpty((String)currentPhase));
        assert (!Strings.isNullOrEmpty((String)currentAction));
        return new Step.StepKey(currentPhase, currentAction, currentStep);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LifecycleExecutionState state) {
        return new Builder().setPhase(state.phase).setAction(state.action).setStep(state.step).setFailedStep(state.failedStep).setIsAutoRetryableError(state.isAutoRetryableError).setFailedStepRetryCount(state.failedStepRetryCount).setStepInfo(state.stepInfo).setPhaseDefinition(state.phaseDefinition).setIndexCreationDate(state.lifecycleDate).setPhaseTime(state.phaseTime).setActionTime(state.actionTime).setSnapshotRepository(state.snapshotRepository).setSnapshotName(state.snapshotName).setShrinkIndexName(state.shrinkIndexName).setSnapshotIndexName(state.snapshotIndexName).setRollupIndexName(state.rollupIndexName).setStepTime(state.stepTime);
    }

    static LifecycleExecutionState fromCustomMetadata(Map<String, String> customData) {
        Builder builder = LifecycleExecutionState.builder();
        if (customData.containsKey(PHASE)) {
            builder.setPhase(customData.get(PHASE));
        }
        if (customData.containsKey(ACTION)) {
            builder.setAction(customData.get(ACTION));
        }
        if (customData.containsKey(STEP)) {
            builder.setStep(customData.get(STEP));
        }
        if (customData.containsKey(FAILED_STEP)) {
            builder.setFailedStep(customData.get(FAILED_STEP));
        }
        if (customData.containsKey(IS_AUTO_RETRYABLE_ERROR)) {
            builder.setIsAutoRetryableError(Boolean.parseBoolean(customData.get(IS_AUTO_RETRYABLE_ERROR)));
        }
        if (customData.containsKey(FAILED_STEP_RETRY_COUNT)) {
            builder.setFailedStepRetryCount(Integer.parseInt(customData.get(FAILED_STEP_RETRY_COUNT)));
        }
        if (customData.containsKey(STEP_INFO)) {
            builder.setStepInfo(customData.get(STEP_INFO));
        }
        if (customData.containsKey(PHASE_DEFINITION)) {
            builder.setPhaseDefinition(customData.get(PHASE_DEFINITION));
        }
        if (customData.containsKey(SNAPSHOT_REPOSITORY)) {
            builder.setSnapshotRepository(customData.get(SNAPSHOT_REPOSITORY));
        }
        if (customData.containsKey(SNAPSHOT_NAME)) {
            builder.setSnapshotName(customData.get(SNAPSHOT_NAME));
        }
        if (customData.containsKey(SHRINK_INDEX_NAME)) {
            builder.setShrinkIndexName(customData.get(SHRINK_INDEX_NAME));
        }
        if (customData.containsKey(INDEX_CREATION_DATE)) {
            try {
                builder.setIndexCreationDate(Long.parseLong(customData.get(INDEX_CREATION_DATE)));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, new Object[]{INDEX_CREATION_DATE, customData.get(INDEX_CREATION_DATE)});
            }
        }
        if (customData.containsKey(PHASE_TIME)) {
            try {
                builder.setPhaseTime(Long.parseLong(customData.get(PHASE_TIME)));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, new Object[]{PHASE_TIME, customData.get(PHASE_TIME)});
            }
        }
        if (customData.containsKey(ACTION_TIME)) {
            try {
                builder.setActionTime(Long.parseLong(customData.get(ACTION_TIME)));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, new Object[]{ACTION_TIME, customData.get(ACTION_TIME)});
            }
        }
        if (customData.containsKey(STEP_TIME)) {
            try {
                builder.setStepTime(Long.parseLong(customData.get(STEP_TIME)));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, new Object[]{STEP_TIME, customData.get(STEP_TIME)});
            }
        }
        if (customData.containsKey(SNAPSHOT_INDEX_NAME)) {
            builder.setSnapshotIndexName(customData.get(SNAPSHOT_INDEX_NAME));
        }
        if (customData.containsKey(ROLLUP_INDEX_NAME)) {
            builder.setRollupIndexName(customData.get(ROLLUP_INDEX_NAME));
        }
        return builder.build();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.phase != null) {
            result.put(PHASE, this.phase);
        }
        if (this.action != null) {
            result.put(ACTION, this.action);
        }
        if (this.step != null) {
            result.put(STEP, this.step);
        }
        if (this.failedStep != null) {
            result.put(FAILED_STEP, this.failedStep);
        }
        if (this.isAutoRetryableError != null) {
            result.put(IS_AUTO_RETRYABLE_ERROR, String.valueOf(this.isAutoRetryableError));
        }
        if (this.failedStepRetryCount != null) {
            result.put(FAILED_STEP_RETRY_COUNT, String.valueOf(this.failedStepRetryCount));
        }
        if (this.stepInfo != null) {
            result.put(STEP_INFO, this.stepInfo);
        }
        if (this.lifecycleDate != null) {
            result.put(INDEX_CREATION_DATE, String.valueOf(this.lifecycleDate));
        }
        if (this.phaseTime != null) {
            result.put(PHASE_TIME, String.valueOf(this.phaseTime));
        }
        if (this.actionTime != null) {
            result.put(ACTION_TIME, String.valueOf(this.actionTime));
        }
        if (this.stepTime != null) {
            result.put(STEP_TIME, String.valueOf(this.stepTime));
        }
        if (this.phaseDefinition != null) {
            result.put(PHASE_DEFINITION, this.phaseDefinition);
        }
        if (this.snapshotRepository != null) {
            result.put(SNAPSHOT_REPOSITORY, this.snapshotRepository);
        }
        if (this.snapshotName != null) {
            result.put(SNAPSHOT_NAME, this.snapshotName);
        }
        if (this.shrinkIndexName != null) {
            result.put(SHRINK_INDEX_NAME, this.shrinkIndexName);
        }
        if (this.snapshotIndexName != null) {
            result.put(SNAPSHOT_INDEX_NAME, this.snapshotIndexName);
        }
        if (this.rollupIndexName != null) {
            result.put(ROLLUP_INDEX_NAME, this.rollupIndexName);
        }
        return Collections.unmodifiableMap(result);
    }

    public String getPhase() {
        return this.phase;
    }

    public String getAction() {
        return this.action;
    }

    public String getStep() {
        return this.step;
    }

    public String getFailedStep() {
        return this.failedStep;
    }

    public Boolean isAutoRetryableError() {
        return this.isAutoRetryableError;
    }

    public Integer getFailedStepRetryCount() {
        return this.failedStepRetryCount;
    }

    public String getStepInfo() {
        return this.stepInfo;
    }

    public String getPhaseDefinition() {
        return this.phaseDefinition;
    }

    public Long getLifecycleDate() {
        return this.lifecycleDate;
    }

    public Long getPhaseTime() {
        return this.phaseTime;
    }

    public Long getActionTime() {
        return this.actionTime;
    }

    public Long getStepTime() {
        return this.stepTime;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getSnapshotRepository() {
        return this.snapshotRepository;
    }

    public String getShrinkIndexName() {
        return this.shrinkIndexName;
    }

    public String getSnapshotIndexName() {
        return this.snapshotIndexName;
    }

    public String getRollupIndexName() {
        return this.rollupIndexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LifecycleExecutionState that = (LifecycleExecutionState)o;
        return Objects.equals(this.getLifecycleDate(), that.getLifecycleDate()) && Objects.equals(this.getPhaseTime(), that.getPhaseTime()) && Objects.equals(this.getActionTime(), that.getActionTime()) && Objects.equals(this.getStepTime(), that.getStepTime()) && Objects.equals(this.getPhase(), that.getPhase()) && Objects.equals(this.getAction(), that.getAction()) && Objects.equals(this.getStep(), that.getStep()) && Objects.equals(this.getFailedStep(), that.getFailedStep()) && Objects.equals(this.isAutoRetryableError(), that.isAutoRetryableError()) && Objects.equals(this.getFailedStepRetryCount(), that.getFailedStepRetryCount()) && Objects.equals(this.getStepInfo(), that.getStepInfo()) && Objects.equals(this.getSnapshotRepository(), that.getSnapshotRepository()) && Objects.equals(this.getSnapshotName(), that.getSnapshotName()) && Objects.equals(this.getSnapshotIndexName(), that.getSnapshotIndexName()) && Objects.equals(this.getShrinkIndexName(), that.getShrinkIndexName()) && Objects.equals(this.getRollupIndexName(), that.getRollupIndexName()) && Objects.equals(this.getPhaseDefinition(), that.getPhaseDefinition());
    }

    public int hashCode() {
        return Objects.hash(this.getPhase(), this.getAction(), this.getStep(), this.getFailedStep(), this.isAutoRetryableError(), this.getFailedStepRetryCount(), this.getStepInfo(), this.getPhaseDefinition(), this.getLifecycleDate(), this.getPhaseTime(), this.getActionTime(), this.getStepTime(), this.getSnapshotRepository(), this.getSnapshotName(), this.getSnapshotIndexName(), this.getShrinkIndexName(), this.getRollupIndexName());
    }

    public String toString() {
        return this.asMap().toString();
    }

    public static class Builder {
        private String phase;
        private String action;
        private String step;
        private String failedStep;
        private String stepInfo;
        private String phaseDefinition;
        private Long indexCreationDate;
        private Long phaseTime;
        private Long actionTime;
        private Long stepTime;
        private Boolean isAutoRetryableError;
        private Integer failedStepRetryCount;
        private String snapshotName;
        private String snapshotRepository;
        private String shrinkIndexName;
        private String snapshotIndexName;
        private String rollupIndexName;

        public Builder setPhase(String phase) {
            this.phase = phase;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setStep(String step) {
            this.step = step;
            return this;
        }

        public Builder setFailedStep(String failedStep) {
            this.failedStep = failedStep;
            return this;
        }

        public Builder setStepInfo(String stepInfo) {
            this.stepInfo = stepInfo;
            return this;
        }

        public Builder setPhaseDefinition(String phaseDefinition) {
            this.phaseDefinition = phaseDefinition;
            return this;
        }

        public Builder setIndexCreationDate(Long indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
            return this;
        }

        public Builder setPhaseTime(Long phaseTime) {
            this.phaseTime = phaseTime;
            return this;
        }

        public Builder setActionTime(Long actionTime) {
            this.actionTime = actionTime;
            return this;
        }

        public Builder setStepTime(Long stepTime) {
            this.stepTime = stepTime;
            return this;
        }

        public Builder setIsAutoRetryableError(Boolean isAutoRetryableError) {
            this.isAutoRetryableError = isAutoRetryableError;
            return this;
        }

        public Builder setFailedStepRetryCount(Integer failedStepRetryCount) {
            this.failedStepRetryCount = failedStepRetryCount;
            return this;
        }

        public Builder setSnapshotRepository(String snapshotRepository) {
            this.snapshotRepository = snapshotRepository;
            return this;
        }

        public Builder setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public Builder setShrinkIndexName(String shrinkIndexName) {
            this.shrinkIndexName = shrinkIndexName;
            return this;
        }

        public Builder setSnapshotIndexName(String snapshotIndexName) {
            this.snapshotIndexName = snapshotIndexName;
            return this;
        }

        public Builder setRollupIndexName(String rollupIndexName) {
            this.rollupIndexName = rollupIndexName;
            return this;
        }

        public LifecycleExecutionState build() {
            return new LifecycleExecutionState(this.phase, this.action, this.step, this.failedStep, this.isAutoRetryableError, this.failedStepRetryCount, this.stepInfo, this.phaseDefinition, this.indexCreationDate, this.phaseTime, this.actionTime, this.stepTime, this.snapshotRepository, this.snapshotName, this.shrinkIndexName, this.snapshotIndexName, this.rollupIndexName);
        }
    }
}

