/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;

final class WaitForIndexingCompleteStep
extends ClusterStateWaitStep {
    private static final Logger logger = LogManager.getLogger(WaitForIndexingCompleteStep.class);
    static final String NAME = "wait-for-indexing-complete";

    WaitForIndexingCompleteStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        IndexMetadata followerIndex = clusterState.metadata().index(index);
        if (followerIndex == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        Map customIndexMetadata = followerIndex.getCustomData("ccr");
        if (customIndexMetadata == null) {
            return new ClusterStateWaitStep.Result(true, null);
        }
        boolean indexingComplete = (Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(followerIndex.getSettings());
        if (indexingComplete) {
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new IndexingNotCompleteInfo());
    }

    static final class IndexingNotCompleteInfo
    implements ToXContentObject {
        static final ParseField MESSAGE_FIELD = new ParseField("message", new String[0]);
        static final ParseField INDEXING_COMPLETE = new ParseField("index.lifecycle.indexing_complete", new String[0]);
        private final String message;

        IndexingNotCompleteInfo() {
            this.message = "waiting for the [index.lifecycle.indexing_complete] setting to be set to true on the leader index, it is currently [false]";
        }

        String getMessage() {
            return this.message;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE_FIELD.getPreferredName(), this.message);
            builder.field(INDEXING_COMPLETE.getPreferredName(), false);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexingNotCompleteInfo info = (IndexingNotCompleteInfo)o;
            return Objects.equals(this.getMessage(), info.getMessage());
        }

        public int hashCode() {
            return Objects.hash(this.getMessage());
        }
    }
}

