/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.groups.GroupOrJobLookup;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NameResolver;

public class MlMetadata
implements XPackPlugin.XPackMetadataCustom {
    public static final String TYPE = "ml";
    private static final ParseField JOBS_FIELD = new ParseField("jobs", new String[0]);
    private static final ParseField DATAFEEDS_FIELD = new ParseField("datafeeds", new String[0]);
    public static final ParseField UPGRADE_MODE = new ParseField("upgrade_mode", new String[0]);
    public static final ParseField RESET_MODE = new ParseField("reset_mode", new String[0]);
    public static final MlMetadata EMPTY_METADATA = new MlMetadata(Collections.emptySortedMap(), Collections.emptySortedMap(), false, false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = new ObjectParser("ml_metadata", true, Builder::new);
    private final SortedMap<String, Job> jobs;
    private final SortedMap<String, DatafeedConfig> datafeeds;
    private final boolean upgradeMode;
    private final boolean resetMode;
    private final GroupOrJobLookup groupOrJobLookup;

    private MlMetadata(SortedMap<String, Job> jobs, SortedMap<String, DatafeedConfig> datafeeds, boolean upgradeMode, boolean resetMode) {
        this.jobs = Collections.unmodifiableSortedMap(jobs);
        this.datafeeds = Collections.unmodifiableSortedMap(datafeeds);
        this.groupOrJobLookup = new GroupOrJobLookup(jobs.values());
        this.upgradeMode = upgradeMode;
        this.resetMode = resetMode;
    }

    public Map<String, Job> getJobs() {
        return this.jobs;
    }

    public Set<String> expandJobIds(String expression, boolean allowNoMatch) {
        return this.groupOrJobLookup.expandJobIds(expression, allowNoMatch);
    }

    public SortedMap<String, DatafeedConfig> getDatafeeds() {
        return this.datafeeds;
    }

    public DatafeedConfig getDatafeed(String datafeedId) {
        return (DatafeedConfig)((Object)this.datafeeds.get(datafeedId));
    }

    public Optional<DatafeedConfig> getDatafeedByJobId(String jobId) {
        return this.datafeeds.values().stream().filter(s -> s.getJobId().equals(jobId)).findFirst();
    }

    public Map<String, DatafeedConfig> getDatafeedsByJobIds(Set<String> jobIds) {
        return this.datafeeds.values().stream().filter(df -> jobIds.contains(df.getJobId())).collect(Collectors.toMap(DatafeedConfig::getJobId, Function.identity()));
    }

    public Set<String> expandDatafeedIds(String expression, boolean allowNoMatch) {
        return NameResolver.newUnaliased(this.datafeeds.keySet(), ExceptionsHelper::missingDatafeedException).expand(expression, allowNoMatch);
    }

    public boolean isUpgradeMode() {
        return this.upgradeMode;
    }

    public boolean isResetMode() {
        return this.resetMode;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_0_0_alpha1;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new MlMetadataDiff((MlMetadata)previousState, this);
    }

    public MlMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        TreeMap<String, Job> jobs = new TreeMap<String, Job>();
        for (int i = 0; i < size; ++i) {
            jobs.put(in.readString(), new Job(in));
        }
        this.jobs = jobs;
        size = in.readVInt();
        TreeMap<String, DatafeedConfig> datafeeds = new TreeMap<String, DatafeedConfig>();
        for (int i = 0; i < size; ++i) {
            datafeeds.put(in.readString(), new DatafeedConfig(in));
        }
        this.datafeeds = datafeeds;
        this.groupOrJobLookup = new GroupOrJobLookup(jobs.values());
        this.upgradeMode = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readBoolean() : false;
        this.resetMode = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readBoolean() : false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        MlMetadata.writeMap(this.jobs, out);
        MlMetadata.writeMap(this.datafeeds, out);
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeBoolean(this.upgradeMode);
        }
        if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
            out.writeBoolean(this.resetMode);
        }
    }

    private static <T extends Writeable> void writeMap(Map<String, T> map, StreamOutput out) throws IOException {
        out.writeVInt(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            out.writeString(entry.getKey());
            ((Writeable)entry.getValue()).writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ToXContent.DelegatingMapParams extendedParams = new ToXContent.DelegatingMapParams(Collections.singletonMap("for_internal_storage", "true"), params);
        MlMetadata.mapValuesToXContent(JOBS_FIELD, this.jobs, builder, (ToXContent.Params)extendedParams);
        MlMetadata.mapValuesToXContent(DATAFEEDS_FIELD, this.datafeeds, builder, (ToXContent.Params)extendedParams);
        builder.field(UPGRADE_MODE.getPreferredName(), this.upgradeMode);
        builder.field(RESET_MODE.getPreferredName(), this.resetMode);
        return builder;
    }

    private static <T extends ToXContent> void mapValuesToXContent(ParseField field, Map<String, T> map, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (map.isEmpty()) {
            return;
        }
        builder.startArray(field.getPreferredName());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            ((ToXContent)entry.getValue()).toXContent(builder, params);
        }
        builder.endArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlMetadata that = (MlMetadata)o;
        return Objects.equals(this.jobs, that.jobs) && Objects.equals(this.datafeeds, that.datafeeds) && this.upgradeMode == that.upgradeMode && this.resetMode == that.resetMode;
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.jobs, this.datafeeds, this.upgradeMode, this.resetMode);
    }

    public static MlMetadata getMlMetadata(ClusterState state) {
        MlMetadata mlMetadata;
        MlMetadata mlMetadata2 = mlMetadata = state == null ? null : (MlMetadata)state.getMetadata().custom(TYPE);
        if (mlMetadata == null) {
            return EMPTY_METADATA;
        }
        return mlMetadata;
    }

    static {
        LENIENT_PARSER.declareObjectArray(Builder::putJobs, (p, c) -> ((Job.Builder)Job.LENIENT_PARSER.apply(p, c)).build(), JOBS_FIELD);
        LENIENT_PARSER.declareObjectArray(Builder::putDatafeeds, (p, c) -> ((DatafeedConfig.Builder)DatafeedConfig.LENIENT_PARSER.apply(p, c)).build(), DATAFEEDS_FIELD);
        LENIENT_PARSER.declareBoolean(Builder::isUpgradeMode, UPGRADE_MODE);
        LENIENT_PARSER.declareBoolean(Builder::isResetMode, RESET_MODE);
    }

    public static class MlMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, Job>> jobs;
        final Diff<Map<String, DatafeedConfig>> datafeeds;
        final boolean upgradeMode;
        final boolean resetMode;

        MlMetadataDiff(MlMetadata before, MlMetadata after) {
            this.jobs = DiffableUtils.diff((Map)before.jobs, (Map)after.jobs, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
            this.datafeeds = DiffableUtils.diff((Map)before.datafeeds, (Map)after.datafeeds, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
            this.upgradeMode = after.upgradeMode;
            this.resetMode = after.resetMode;
        }

        public MlMetadataDiff(StreamInput in) throws IOException {
            this.jobs = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), Job::new, MlMetadataDiff::readJobDiffFrom);
            this.datafeeds = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), DatafeedConfig::new, MlMetadataDiff::readDatafeedDiffFrom);
            this.upgradeMode = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readBoolean() : false;
            this.resetMode = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readBoolean() : false;
        }

        public Metadata.Custom apply(Metadata.Custom part) {
            TreeMap newJobs = new TreeMap((Map)this.jobs.apply((Object)((MlMetadata)part).jobs));
            TreeMap newDatafeeds = new TreeMap((Map)this.datafeeds.apply((Object)((MlMetadata)part).datafeeds));
            return new MlMetadata(newJobs, newDatafeeds, this.upgradeMode, this.resetMode);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.jobs.writeTo(out);
            this.datafeeds.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                out.writeBoolean(this.upgradeMode);
            }
            if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
                out.writeBoolean(this.resetMode);
            }
        }

        public String getWriteableName() {
            return MlMetadata.TYPE;
        }

        static Diff<Job> readJobDiffFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(Job::new, (StreamInput)in);
        }

        static Diff<DatafeedConfig> readDatafeedDiffFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(DatafeedConfig::new, (StreamInput)in);
        }
    }

    public static class Builder {
        private TreeMap<String, Job> jobs;
        private TreeMap<String, DatafeedConfig> datafeeds;
        private boolean upgradeMode;
        private boolean resetMode;

        public static Builder from(@Nullable MlMetadata previous) {
            return new Builder(previous);
        }

        public Builder() {
            this.jobs = new TreeMap();
            this.datafeeds = new TreeMap();
        }

        public Builder(@Nullable MlMetadata previous) {
            if (previous == null) {
                this.jobs = new TreeMap();
                this.datafeeds = new TreeMap();
            } else {
                this.jobs = new TreeMap(previous.jobs);
                this.datafeeds = new TreeMap(previous.datafeeds);
                this.upgradeMode = previous.upgradeMode;
                this.resetMode = previous.resetMode;
            }
        }

        public Builder putJob(Job job, boolean overwrite) {
            if (this.jobs.containsKey(job.getId()) && !overwrite) {
                throw ExceptionsHelper.jobAlreadyExists(job.getId());
            }
            this.jobs.put(job.getId(), job);
            return this;
        }

        public Builder putJobs(Collection<Job> jobs) {
            for (Job job : jobs) {
                this.putJob(job, true);
            }
            return this;
        }

        public Builder putDatafeed(DatafeedConfig datafeedConfig, Map<String, String> headers, NamedXContentRegistry xContentRegistry) {
            if (this.datafeeds.containsKey(datafeedConfig.getId())) {
                throw ExceptionsHelper.datafeedAlreadyExists(datafeedConfig.getId());
            }
            String jobId = datafeedConfig.getJobId();
            this.checkJobIsAvailableForDatafeed(jobId);
            Job job = this.jobs.get(jobId);
            DatafeedJobValidator.validate(datafeedConfig, job, xContentRegistry);
            if (!headers.isEmpty()) {
                datafeedConfig = new DatafeedConfig.Builder(datafeedConfig).setHeaders(ClientHelper.filterSecurityHeaders(headers)).build();
            }
            this.datafeeds.put(datafeedConfig.getId(), datafeedConfig);
            return this;
        }

        private void checkJobIsAvailableForDatafeed(String jobId) {
            Job job = this.jobs.get(jobId);
            if (job == null || job.isDeleting()) {
                throw ExceptionsHelper.missingJobException(jobId);
            }
            Optional<DatafeedConfig> existingDatafeed = this.getDatafeedByJobId(jobId);
            if (existingDatafeed.isPresent()) {
                throw ExceptionsHelper.conflictStatusException("A datafeed [" + existingDatafeed.get().getId() + "] already exists for job [" + jobId + "]", new Object[0]);
            }
        }

        private Optional<DatafeedConfig> getDatafeedByJobId(String jobId) {
            return this.datafeeds.values().stream().filter(s -> s.getJobId().equals(jobId)).findFirst();
        }

        public Builder putDatafeeds(Collection<DatafeedConfig> datafeeds) {
            for (DatafeedConfig datafeed : datafeeds) {
                this.datafeeds.put(datafeed.getId(), datafeed);
            }
            return this;
        }

        public Builder isUpgradeMode(boolean upgradeMode) {
            this.upgradeMode = upgradeMode;
            return this;
        }

        public Builder isResetMode(boolean resetMode) {
            this.resetMode = resetMode;
            return this;
        }

        public MlMetadata build() {
            return new MlMetadata(this.jobs, this.datafeeds, this.upgradeMode, this.resetMode);
        }
    }
}

