/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.AucRoc;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.ConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.Precision;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.Recall;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OutlierDetection
implements Evaluation {
    public static final ParseField NAME = new ParseField("outlier_detection", new String[]{"binary_soft_classification"});
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    public static final ConstructingObjectParser<OutlierDetection, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new OutlierDetection((String)a[0], (String)a[1], (List)a[2]));
    private final EvaluationFields fields;
    private final List<EvaluationMetric> metrics;

    public static OutlierDetection fromXContent(XContentParser parser) {
        return (OutlierDetection)PARSER.apply(parser, null);
    }

    public static QueryBuilder actualIsTrueQuery(String actualField) {
        return QueryBuilders.queryStringQuery((String)(actualField + ": (1 OR true)"));
    }

    public OutlierDetection(String actualField, String predictedProbabilityField, @Nullable List<EvaluationMetric> metrics) {
        this.fields = new EvaluationFields(ExceptionsHelper.requireNonNull(actualField, EvaluationFields.ACTUAL_FIELD), null, null, null, ExceptionsHelper.requireNonNull(predictedProbabilityField, EvaluationFields.PREDICTED_PROBABILITY_FIELD), false);
        this.metrics = this.initMetrics(metrics, OutlierDetection::defaultMetrics);
    }

    private static List<EvaluationMetric> defaultMetrics() {
        return Arrays.asList(new AucRoc(false), new Precision(Arrays.asList(0.25, 0.5, 0.75)), new Recall(Arrays.asList(0.25, 0.5, 0.75)), new ConfusionMatrix(Arrays.asList(0.25, 0.5, 0.75)));
    }

    public OutlierDetection(StreamInput in) throws IOException {
        this.fields = new EvaluationFields(in.readString(), null, null, null, in.readString(), false);
        this.metrics = in.readNamedWriteableList(EvaluationMetric.class);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public EvaluationFields getFields() {
        return this.fields;
    }

    public List<EvaluationMetric> getMetrics() {
        return this.metrics;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fields.getActualField());
        out.writeString(this.fields.getPredictedProbabilityField());
        out.writeNamedWriteableList(this.metrics);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(EvaluationFields.ACTUAL_FIELD.getPreferredName(), this.fields.getActualField());
        builder.field(EvaluationFields.PREDICTED_PROBABILITY_FIELD.getPreferredName(), this.fields.getPredictedProbabilityField());
        builder.startObject(METRICS.getPreferredName());
        for (EvaluationMetric metric : this.metrics) {
            builder.field(metric.getName(), (ToXContent)metric);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlierDetection that = (OutlierDetection)o;
        return Objects.equals(this.fields, that.fields) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), EvaluationFields.ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), EvaluationFields.PREDICTED_PROBABILITY_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (EvaluationMetric)p.namedObject(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(NAME.getPreferredName(), n), c), METRICS);
    }
}

