/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.outlierdetection;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.TimeValue;

public class TimingStats
implements Writeable,
ToXContentObject {
    public static final ParseField ELAPSED_TIME = new ParseField("elapsed_time", new String[0]);
    private final TimeValue elapsedTime;

    public static TimingStats fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return (TimingStats)TimingStats.createParser(ignoreUnknownFields).apply(parser, null);
    }

    private static ConstructingObjectParser<TimingStats, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("outlier_detection_timing_stats", ignoreUnknownFields, a -> new TimingStats(TimeValue.timeValueMillis((long)((Long)a[0]))));
        parser.declareLong(ConstructingObjectParser.constructorArg(), ELAPSED_TIME);
        return parser;
    }

    public TimingStats(TimeValue elapsedTime) {
        this.elapsedTime = Objects.requireNonNull(elapsedTime);
    }

    public TimingStats(StreamInput in) throws IOException {
        this.elapsedTime = in.readTimeValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.elapsedTime);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.humanReadableField(ELAPSED_TIME.getPreferredName(), ELAPSED_TIME.getPreferredName() + "_string", (Object)this.elapsedTime);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingStats that = (TimingStats)o;
        return Objects.equals(this.elapsedTime, that.elapsedTime);
    }

    public int hashCode() {
        return Objects.hash(this.elapsedTime);
    }
}

