/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.saml;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public final class SamlAuthenticateResponse
extends ActionResponse {
    private String principal;
    private String tokenString;
    private String refreshToken;
    private String realm;
    private TimeValue expiresIn;
    private Authentication authentication;

    public SamlAuthenticateResponse(StreamInput in) throws IOException {
        super(in);
        this.principal = in.readString();
        if (in.getVersion().onOrAfter(Version.V_7_7_0)) {
            this.realm = in.readString();
        }
        this.tokenString = in.readString();
        this.refreshToken = in.readString();
        this.expiresIn = in.readTimeValue();
        if (in.getVersion().onOrAfter(Version.V_7_11_0)) {
            this.authentication = new Authentication(in);
        }
    }

    public SamlAuthenticateResponse(Authentication authentication, String tokenString, String refreshToken, TimeValue expiresIn) {
        this.principal = authentication.getUser().principal();
        this.realm = authentication.getAuthenticatedBy().getName();
        this.tokenString = tokenString;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        this.authentication = authentication;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeString(this.realm);
        }
        out.writeString(this.tokenString);
        out.writeString(this.refreshToken);
        out.writeTimeValue(this.expiresIn);
        if (out.getVersion().onOrAfter(Version.V_7_11_0)) {
            this.authentication.writeTo(out);
        }
    }
}

