/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;

public final class ProfileConfigurations {
    private ProfileConfigurations() {
    }

    public static Map<String, SSLConfiguration> get(Settings settings, SSLService sslService, SSLConfiguration defaultConfiguration) {
        Set profileNames = settings.getGroups("transport.profiles.", true).keySet();
        HashMap<String, SSLConfiguration> profileConfiguration = new HashMap<String, SSLConfiguration>(profileNames.size() + 1);
        for (String profileName : profileNames) {
            if (profileName.equals("default")) {
                if (settings.getByPrefix("transport.profiles.default.xpack.security.ssl.").isEmpty()) continue;
                throw new IllegalArgumentException("SSL settings should not be configured for the default profile. Use the [xpack.security.transport.ssl] settings instead.");
            }
            SSLConfiguration configuration = sslService.getSSLConfiguration("transport.profiles." + profileName + "." + SecurityField.setting("ssl"));
            profileConfiguration.put(profileName, configuration);
        }
        assert (!profileConfiguration.containsKey("default"));
        profileConfiguration.put("default", defaultConfiguration);
        return profileConfiguration;
    }
}

