/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.RetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public class TransformConfigUpdate
implements Writeable {
    public static final String NAME = "data_frame_transform_config_update";
    private static final ConstructingObjectParser<TransformConfigUpdate, String> PARSER = new ConstructingObjectParser("data_frame_transform_config_update", false, args -> {
        SourceConfig source = (SourceConfig)args[0];
        DestConfig dest = (DestConfig)args[1];
        TimeValue frequency = args[2] == null ? null : TimeValue.parseTimeValue((String)((String)args[2]), (String)TransformField.FREQUENCY.getPreferredName());
        SyncConfig syncConfig = (SyncConfig)args[3];
        String description = (String)args[4];
        SettingsConfig settings = (SettingsConfig)args[5];
        RetentionPolicyConfig retentionPolicyConfig = (RetentionPolicyConfig)args[6];
        return new TransformConfigUpdate(source, dest, frequency, syncConfig, description, settings, retentionPolicyConfig);
    });
    private final SourceConfig source;
    private final DestConfig dest;
    private final TimeValue frequency;
    private final SyncConfig syncConfig;
    private final String description;
    private final SettingsConfig settings;
    private final RetentionPolicyConfig retentionPolicyConfig;
    private Map<String, String> headers;

    public TransformConfigUpdate(SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, String description, SettingsConfig settings, RetentionPolicyConfig retentionPolicyConfig) {
        this.source = source;
        this.dest = dest;
        this.frequency = frequency;
        this.syncConfig = syncConfig;
        this.description = description;
        if (this.description != null && this.description.length() > 1000) {
            throw new IllegalArgumentException("[description] must be less than 1000 characters in length.");
        }
        this.settings = settings;
        this.retentionPolicyConfig = retentionPolicyConfig;
    }

    public TransformConfigUpdate(StreamInput in) throws IOException {
        this.source = (SourceConfig)in.readOptionalWriteable(SourceConfig::new);
        this.dest = (DestConfig)in.readOptionalWriteable(DestConfig::new);
        this.frequency = in.readOptionalTimeValue();
        this.description = in.readOptionalString();
        this.syncConfig = (SyncConfig)in.readOptionalNamedWriteable(SyncConfig.class);
        if (in.readBoolean()) {
            this.setHeaders(in.readMap(StreamInput::readString, StreamInput::readString));
        }
        this.settings = in.getVersion().onOrAfter(Version.V_7_8_0) ? (SettingsConfig)in.readOptionalWriteable(SettingsConfig::new) : null;
        this.retentionPolicyConfig = in.getVersion().onOrAfter(Version.V_7_12_0) ? (RetentionPolicyConfig)in.readOptionalNamedWriteable(RetentionPolicyConfig.class) : null;
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SettingsConfig getSettings() {
        return this.settings;
    }

    @Nullable
    public RetentionPolicyConfig getRetentionPolicyConfig() {
        return this.retentionPolicyConfig;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.source);
        out.writeOptionalWriteable((Writeable)this.dest);
        out.writeOptionalTimeValue(this.frequency);
        out.writeOptionalString(this.description);
        out.writeOptionalNamedWriteable((NamedWriteable)this.syncConfig);
        if (this.headers != null) {
            out.writeBoolean(true);
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeOptionalWriteable((Writeable)this.settings);
        }
        if (out.getVersion().onOrAfter(Version.V_7_12_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.retentionPolicyConfig);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformConfigUpdate that = (TransformConfigUpdate)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.settings, that.settings) && Objects.equals(this.retentionPolicyConfig, that.retentionPolicyConfig) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.dest, this.frequency, this.syncConfig, this.description, this.settings, this.retentionPolicyConfig, this.headers);
    }

    public static TransformConfigUpdate fromXContent(XContentParser parser) {
        return (TransformConfigUpdate)PARSER.apply(parser, null);
    }

    public boolean isNoop(TransformConfig config) {
        return this.isNullOrEqual(this.source, config.getSource()) && this.isNullOrEqual(this.dest, config.getDestination()) && this.isNullOrEqual(this.frequency, config.getFrequency()) && this.isNullOrEqual(this.syncConfig, config.getSyncConfig()) && this.isNullOrEqual(this.description, config.getDescription()) && this.isNullOrEqual(this.settings, config.getSettings()) && this.isNullOrEqual(this.retentionPolicyConfig, config.getRetentionPolicyConfig()) && this.isNullOrEqual(this.headers, config.getHeaders());
    }

    public boolean changesSettings(TransformConfig config) {
        return !this.isNullOrEqual(this.settings, config.getSettings());
    }

    private boolean isNullOrEqual(Object lft, Object rgt) {
        return lft == null || lft.equals(rgt);
    }

    public TransformConfig apply(TransformConfig config) {
        if (this.isNoop(config)) {
            return config;
        }
        TransformConfig.Builder builder = new TransformConfig.Builder(config);
        if (this.source != null) {
            builder.setSource(this.source);
        }
        if (this.dest != null) {
            builder.setDest(this.dest);
        }
        if (this.frequency != null) {
            builder.setFrequency(this.frequency);
        }
        if (this.syncConfig != null) {
            String currentConfigName;
            String string = currentConfigName = config.getSyncConfig() == null ? "null" : config.getSyncConfig().getWriteableName();
            if (!this.syncConfig.getWriteableName().equals(currentConfigName)) {
                throw new ElasticsearchStatusException(TransformMessages.getMessage("Cannot change the current sync configuration of transform [{0}] from [{1}] to [{2}]", config.getId(), currentConfigName, this.syncConfig.getWriteableName()), RestStatus.BAD_REQUEST, new Object[0]);
            }
            builder.setSyncConfig(this.syncConfig);
        }
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        if (this.headers != null) {
            builder.setHeaders(this.headers);
        }
        if (this.settings != null) {
            SettingsConfig.Builder settingsBuilder = new SettingsConfig.Builder(config.getSettings());
            settingsBuilder.update(this.settings);
            builder.setSettings(settingsBuilder.build());
        }
        if (this.retentionPolicyConfig != null) {
            builder.setRetentionPolicyConfig(this.retentionPolicyConfig);
        }
        builder.setVersion(Version.CURRENT);
        return builder.build();
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SourceConfig.fromXContent(p, false), TransformField.SOURCE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DestConfig.fromXContent(p, false), TransformField.DESTINATION);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.FREQUENCY);
        PARSER.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (SyncConfig)p.namedObject(SyncConfig.class, n, c), TransformField.SYNC);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.DESCRIPTION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfig.fromXContent(p, false), TransformField.SETTINGS);
        PARSER.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (RetentionPolicyConfig)p.namedObject(RetentionPolicyConfig.class, n, c), TransformField.RETENTION_POLICY);
    }
}

