/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.env.Environment;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.ml.MachineLearningFeatureSet;
import org.elasticsearch.xpack.ml.datafeed.DatafeedRunner;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeControllerHolder;

public class MlLifeCycleService {
    public static final Duration MAX_GRACEFUL_SHUTDOWN_TIME = Duration.of(10L, ChronoUnit.MINUTES);
    private static final Logger logger = LogManager.getLogger(MlLifeCycleService.class);
    private final Environment environment;
    private final ClusterService clusterService;
    private final DatafeedRunner datafeedRunner;
    private final AutodetectProcessManager autodetectProcessManager;
    private final DataFrameAnalyticsManager analyticsManager;
    private final MlMemoryTracker memoryTracker;
    private volatile Instant shutdownStartTime;

    public MlLifeCycleService(Environment environment, ClusterService clusterService, DatafeedRunner datafeedRunner, AutodetectProcessManager autodetectProcessManager, DataFrameAnalyticsManager analyticsManager, MlMemoryTracker memoryTracker) {
        this.environment = environment;
        this.clusterService = clusterService;
        this.datafeedRunner = datafeedRunner;
        this.autodetectProcessManager = autodetectProcessManager;
        this.analyticsManager = analyticsManager;
        this.memoryTracker = memoryTracker;
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                MlLifeCycleService.this.stop();
            }
        });
    }

    public synchronized void stop() {
        try {
            if (MachineLearningFeatureSet.isRunningOnMlPlatform(false)) {
                NativeController nativeController;
                this.analyticsManager.markNodeAsShuttingDown();
                if (this.datafeedRunner != null) {
                    this.datafeedRunner.prepareForImmediateShutdown();
                }
                if ((nativeController = NativeControllerHolder.getNativeController(this.clusterService.getNodeName(), this.environment)) != null) {
                    if (this.autodetectProcessManager != null) {
                        this.autodetectProcessManager.killAllProcessesOnThisNode();
                    }
                    nativeController.stop();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.memoryTracker != null) {
            this.memoryTracker.stop();
        }
    }

    public boolean isNodeSafeToShutdown(String nodeId) {
        return MlLifeCycleService.isNodeSafeToShutdown(nodeId, this.clusterService.state(), this.shutdownStartTime, Clock.systemUTC());
    }

    static boolean isNodeSafeToShutdown(String nodeId, ClusterState state, Instant shutdownStartTime, Clock clock) {
        if (!PersistentTasksService.isLocalAbortSupported((ClusterState)state)) {
            return true;
        }
        if (shutdownStartTime != null && shutdownStartTime.isBefore(clock.instant().minus(MAX_GRACEFUL_SHUTDOWN_TIME))) {
            return true;
        }
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        return MlTasks.nonFailedJobTasksOnNode((PersistentTasksCustomMetadata)tasks, (String)nodeId).isEmpty() && MlTasks.nonFailedSnapshotUpgradeTasksOnNode((PersistentTasksCustomMetadata)tasks, (String)nodeId).isEmpty();
    }

    public void signalGracefulShutdown(Collection<String> shutdownNodeIds) {
        this.signalGracefulShutdown(this.clusterService.state(), shutdownNodeIds, Clock.systemUTC());
    }

    void signalGracefulShutdown(ClusterState state, Collection<String> shutdownNodeIds, Clock clock) {
        if (!PersistentTasksService.isLocalAbortSupported((ClusterState)state)) {
            return;
        }
        if (shutdownNodeIds.contains(state.nodes().getLocalNodeId())) {
            if (this.shutdownStartTime == null) {
                this.shutdownStartTime = Instant.now(clock);
                logger.info((Object)"Starting node shutdown sequence for ML");
            }
            this.datafeedRunner.vacateAllDatafeedsOnThisNode("previously assigned node [" + state.nodes().getLocalNode().getName() + "] is shutting down");
            this.autodetectProcessManager.vacateOpenJobsOnThisNode();
        }
    }

    Instant getShutdownStartTime() {
        return this.shutdownStartTime;
    }
}

