/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.IOException;
import org.elasticsearch.xpack.ml.job.categorization.AbstractMlTokenizer;

public class MlClassicTokenizer
extends AbstractMlTokenizer {
    public static String NAME = "ml_classic";

    MlClassicTokenizer() {
    }

    public final boolean incrementToken() throws IOException {
        char toCheck;
        int curChar;
        this.clearAttributes();
        this.skippedPositions = 0;
        int start = -1;
        int length = 0;
        boolean haveNonHex = false;
        while ((curChar = this.input.read()) >= 0) {
            ++this.nextOffset;
            if (Character.isLetterOrDigit(curChar) || length > 0 && (curChar == 95 || curChar == 46 || curChar == 45)) {
                if (length == 0) {
                    start = this.nextOffset - 1;
                }
                this.termAtt.append((char)curChar);
                ++length;
                haveNonHex = haveNonHex || Character.digit(curChar, 16) == -1 && curChar != 46 && curChar != 45;
                continue;
            }
            if (length <= 0) continue;
            if (haveNonHex && !Character.isDigit(this.termAtt.charAt(0))) break;
            ++this.skippedPositions;
            start = -1;
            length = 0;
            this.termAtt.setEmpty();
        }
        if (length == 0) {
            return false;
        }
        if (!haveNonHex || Character.isDigit(this.termAtt.charAt(0))) {
            ++this.skippedPositions;
            return false;
        }
        while ((toCheck = this.termAtt.charAt(length - 1)) == '_' || toCheck == '.' || toCheck == '-') {
            --length;
        }
        this.termAtt.setLength(length);
        this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + length));
        this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
        return true;
    }
}

