/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BitString;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.OID;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.DecodedPrivateKey;
import com.unboundid.util.ssl.cert.DecodedPublicKey;
import com.unboundid.util.ssl.cert.PKCS10CertificateSigningRequest;
import com.unboundid.util.ssl.cert.PKCS10CertificateSigningRequestVersion;
import com.unboundid.util.ssl.cert.PKCS8PrivateKey;
import com.unboundid.util.ssl.cert.PKCS8PrivateKeyVersion;
import com.unboundid.util.ssl.cert.X509Certificate;
import com.unboundid.util.ssl.cert.X509CertificateExtension;
import com.unboundid.util.ssl.cert.X509CertificateVersion;
import java.math.BigInteger;
import java.util.List;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class InternalCertHelper {
    private InternalCertHelper() {
    }

    @InternalUseOnly
    public static X509Certificate createX509Certificate(X509CertificateVersion version, BigInteger serialNumber, OID signatureAlgorithmOID, ASN1Element signatureAlgorithmParameters, ASN1BitString signatureValue, DN issuerDN, long notBefore, long notAfter, DN subjectDN, OID publicKeyAlgorithmOID, ASN1Element publicKeyAlgorithmParameters, ASN1BitString encodedPublicKey, DecodedPublicKey decodedPublicKey, ASN1BitString issuerUniqueID, ASN1BitString subjectUniqueID, X509CertificateExtension ... extensions) throws CertException {
        return new X509Certificate(version, serialNumber, signatureAlgorithmOID, signatureAlgorithmParameters, signatureValue, issuerDN, notBefore, notAfter, subjectDN, publicKeyAlgorithmOID, publicKeyAlgorithmParameters, encodedPublicKey, decodedPublicKey, issuerUniqueID, subjectUniqueID, extensions);
    }

    @InternalUseOnly
    public static PKCS10CertificateSigningRequest createPKCS10CertificateSigningRequest(PKCS10CertificateSigningRequestVersion version, OID signatureAlgorithmOID, ASN1Element signatureAlgorithmParameters, ASN1BitString signatureValue, DN subjectDN, OID publicKeyAlgorithmOID, ASN1Element publicKeyAlgorithmParameters, ASN1BitString encodedPublicKey, DecodedPublicKey decodedPublicKey, List<ObjectPair<OID, ASN1Set>> nonExtensionAttributes, X509CertificateExtension ... extensions) throws CertException {
        return new PKCS10CertificateSigningRequest(version, signatureAlgorithmOID, signatureAlgorithmParameters, signatureValue, subjectDN, publicKeyAlgorithmOID, publicKeyAlgorithmParameters, encodedPublicKey, decodedPublicKey, nonExtensionAttributes, extensions);
    }

    @InternalUseOnly
    public static PKCS8PrivateKey createPKCS8PrivateKey(PKCS8PrivateKeyVersion version, OID privateKeyAlgorithmOID, ASN1Element privateKeyAlgorithmParameters, ASN1OctetString encodedPrivateKey, DecodedPrivateKey decodedPrivateKey, ASN1Element attributesElement, ASN1BitString publicKey) throws CertException {
        return new PKCS8PrivateKey(version, privateKeyAlgorithmOID, privateKeyAlgorithmParameters, encodedPrivateKey, decodedPrivateKey, attributesElement, publicKey);
    }
}

