/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.slm.SLMFeatureSetUsage;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class SLMFeatureSet
implements XPackFeatureSet {
    private ClusterService clusterService;

    @Inject
    public SLMFeatureSet(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public String name() {
        return "slm";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        SnapshotLifecycleMetadata slmMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        SLMFeatureSetUsage usage = new SLMFeatureSetUsage(slmMeta == null ? null : slmMeta.getStats());
        listener.onResponse((Object)usage);
    }
}

