/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.kstest;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public abstract class SamplingMethod
implements Writeable {
    public static SamplingMethod fromString(String value) {
        switch (value) {
            case "upper_tail": {
                return new UpperTail();
            }
            case "lower_tail": {
                return new LowerTail();
            }
            case "uniform": {
                return new Uniform();
            }
        }
        throw new IllegalArgumentException("Unrecognized sampling_method [" + value + "]");
    }

    public static SamplingMethod fromStream(StreamInput in) throws IOException {
        String name = in.readString();
        return SamplingMethod.fromString(name);
    }

    public abstract String getName();

    protected abstract double[] cdfPoints();

    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public String toString() {
        return super.toString();
    }

    public static class UpperTail
    extends SamplingMethod {
        public static final String NAME = "upper_tail";
        private static final double[] CDF_POINTS;

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        protected double[] cdfPoints() {
            return CDF_POINTS;
        }

        static {
            ArrayList<Double> pts = new ArrayList<Double>();
            for (int i = 1; i < 11; ++i) {
                for (int j = 0; j < i; ++j) {
                    pts.add(0.1 * (double)(i - 1) + 0.05 / (double)i + 0.1 * (double)j / (double)i);
                }
            }
            CDF_POINTS = pts.stream().mapToDouble(Double::doubleValue).toArray();
        }
    }

    public static class LowerTail
    extends SamplingMethod {
        public static final String NAME = "lower_tail";
        private static final double[] CDF_POINTS = new double[UpperTail.access$000().length];

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        protected double[] cdfPoints() {
            return CDF_POINTS;
        }

        static {
            for (int i = 0; i < CDF_POINTS.length; ++i) {
                LowerTail.CDF_POINTS[i] = 1.0 - UpperTail.CDF_POINTS[i];
            }
        }
    }

    public static class Uniform
    extends SamplingMethod {
        public static final String NAME = "uniform";
        private static final double[] CDF_POINTS;

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        protected double[] cdfPoints() {
            return CDF_POINTS;
        }

        static {
            double interval;
            CDF_POINTS = new double[UpperTail.CDF_POINTS.length];
            Uniform.CDF_POINTS[0] = interval = 1.0 / (double)(UpperTail.CDF_POINTS.length + 1);
            for (int i = 1; i < CDF_POINTS.length; ++i) {
                Uniform.CDF_POINTS[i] = CDF_POINTS[i - 1] + interval;
            }
        }
    }
}

