/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.ml.dataframe.process.AnalysisFieldInfo;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;

public class AnalyticsProcessConfig
implements ToXContentObject {
    private static final String JOB_ID = "job_id";
    private static final String ROWS = "rows";
    private static final String COLS = "cols";
    private static final String MEMORY_LIMIT = "memory_limit";
    private static final String THREADS = "threads";
    private static final String ANALYSIS = "analysis";
    private static final String RESULTS_FIELD = "results_field";
    private static final String CATEGORICAL_FIELDS = "categorical_fields";
    private final String jobId;
    private final long rows;
    private final int cols;
    private final ByteSizeValue memoryLimit;
    private final int threads;
    private final String resultsField;
    private final Set<String> categoricalFields;
    private final DataFrameAnalysis analysis;
    private final ExtractedFields extractedFields;

    public AnalyticsProcessConfig(String jobId, long rows, int cols, ByteSizeValue memoryLimit, int threads, String resultsField, Set<String> categoricalFields, DataFrameAnalysis analysis, ExtractedFields extractedFields) {
        this.jobId = Objects.requireNonNull(jobId);
        this.rows = rows;
        this.cols = cols;
        this.memoryLimit = Objects.requireNonNull(memoryLimit);
        this.threads = threads;
        this.resultsField = Objects.requireNonNull(resultsField);
        this.categoricalFields = Objects.requireNonNull(categoricalFields);
        this.analysis = Objects.requireNonNull(analysis);
        this.extractedFields = Objects.requireNonNull(extractedFields);
    }

    public String jobId() {
        return this.jobId;
    }

    public long rows() {
        return this.rows;
    }

    public int cols() {
        return this.cols;
    }

    public int threads() {
        return this.threads;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID, this.jobId);
        builder.field(ROWS, this.rows);
        builder.field(COLS, this.cols);
        builder.field(MEMORY_LIMIT, this.memoryLimit.getBytes());
        builder.field(THREADS, this.threads);
        builder.field(RESULTS_FIELD, this.resultsField);
        builder.field(CATEGORICAL_FIELDS, this.categoricalFields);
        builder.field(ANALYSIS, (ToXContent)new DataFrameAnalysisWrapper(this.analysis, this.extractedFields));
        builder.endObject();
        return builder;
    }

    private static class DataFrameAnalysisWrapper
    implements ToXContentObject {
        private final DataFrameAnalysis analysis;
        private final ExtractedFields extractedFields;

        private DataFrameAnalysisWrapper(DataFrameAnalysis analysis, ExtractedFields extractedFields) {
            this.analysis = analysis;
            this.extractedFields = extractedFields;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.analysis.getWriteableName());
            builder.field("parameters", this.analysis.getParams((DataFrameAnalysis.FieldInfo)new AnalysisFieldInfo(this.extractedFields)));
            builder.endObject();
            return builder;
        }
    }
}

