/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.modelsize;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.OneHotEncoding;
import org.elasticsearch.xpack.ml.inference.modelsize.PreprocessorSize;
import org.elasticsearch.xpack.ml.inference.modelsize.SizeEstimatorHelper;

public class OneHotEncodingSize
implements PreprocessorSize {
    private static final ParseField FEATURE_NAME_LENGTHS = new ParseField("feature_name_lengths", new String[0]);
    private static final ConstructingObjectParser<OneHotEncodingSize, Void> PARSER = new ConstructingObjectParser("one_hot_encoding_size", false, a -> new OneHotEncodingSize((Integer)a[0], (List)a[1], (List)a[2]));
    private final int fieldLength;
    private final int[] featureNameLengths;
    private final int[] fieldValueLengths;

    public static OneHotEncodingSize fromXContent(XContentParser parser) {
        return (OneHotEncodingSize)PARSER.apply(parser, null);
    }

    OneHotEncodingSize(int fieldLength, List<Integer> featureNameLengths, List<Integer> fieldValueLengths) {
        assert (featureNameLengths.size() == fieldValueLengths.size());
        this.fieldLength = fieldLength;
        this.featureNameLengths = featureNameLengths.stream().mapToInt(Integer::intValue).toArray();
        this.fieldValueLengths = fieldValueLengths.stream().mapToInt(Integer::intValue).toArray();
    }

    public long ramBytesUsed() {
        long size = OneHotEncoding.SHALLOW_SIZE;
        size += SizeEstimatorHelper.sizeOfString(this.fieldLength);
        return RamUsageEstimator.alignObjectSize((long)(size += SizeEstimatorHelper.sizeOfHashMap(Arrays.stream(this.fieldValueLengths).mapToLong(SizeEstimatorHelper::sizeOfString).boxed().collect(Collectors.toList()), Arrays.stream(this.featureNameLengths).mapToLong(SizeEstimatorHelper::sizeOfString).boxed().collect(Collectors.toList()))));
    }

    @Override
    public String getName() {
        return OneHotEncoding.NAME.getPreferredName();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_LENGTH.getPreferredName(), this.fieldLength);
        builder.field(FEATURE_NAME_LENGTHS.getPreferredName(), (Object)this.featureNameLengths);
        builder.field(FIELD_VALUE_LENGTHS.getPreferredName(), (Object)this.fieldValueLengths);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneHotEncodingSize that = (OneHotEncodingSize)o;
        return this.fieldLength == that.fieldLength && Arrays.equals(this.featureNameLengths, that.featureNameLengths) && Arrays.equals(this.fieldValueLengths, that.fieldValueLengths);
    }

    public int hashCode() {
        int result = Objects.hash(this.fieldLength);
        result = 31 * result + Arrays.hashCode(this.featureNameLengths);
        result = 31 * result + Arrays.hashCode(this.fieldValueLengths);
        return result;
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), FIELD_LENGTH);
        PARSER.declareIntArray(ConstructingObjectParser.constructorArg(), FEATURE_NAME_LENGTHS);
        PARSER.declareIntArray(ConstructingObjectParser.constructorArg(), FIELD_VALUE_LENGTHS);
    }
}

