/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.List;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestGetJobStatsAction
extends BaseRestHandler {
    public java.util.List<RestHandler.Route> routes() {
        return List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}/_stats")).replaces(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}/_stats", RestApiVersion.V_7).build(), (Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_ml/anomaly_detectors/_stats").replaces(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/_stats", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_job_stats_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String jobId = restRequest.param(Job.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)jobId)) {
            jobId = "_all";
        }
        GetJobsStatsAction.Request request = new GetJobsStatsAction.Request(jobId);
        if (restRequest.hasParam("allow_no_jobs")) {
            LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, () -> null, "allow_no_jobs", "allow_no_match");
        }
        request.setAllowNoMatch(restRequest.paramAsBoolean("allow_no_match", restRequest.paramAsBoolean("allow_no_jobs", request.allowNoMatch())));
        return channel -> client.execute((ActionType)GetJobsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

