/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.latest;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.transform.transforms.Function;

class LatestChangeCollector
implements Function.ChangeCollector {
    private final String synchronizationField;

    LatestChangeCollector(String synchronizationField) {
        this.synchronizationField = Objects.requireNonNull(synchronizationField);
    }

    @Override
    public SearchSourceBuilder buildChangesQuery(SearchSourceBuilder searchSourceBuilder, Map<String, Object> position, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> processSearchResponse(SearchResponse searchResponse) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryBuilder buildFilterQuery(long lastCheckpointTimestamp, long nextCheckpointTimestamp) {
        return QueryBuilders.rangeQuery((String)this.synchronizationField).gte((Object)lastCheckpointTimestamp).lt((Object)nextCheckpointTimestamp).format("epoch_millis");
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isOptimized() {
        return true;
    }

    @Override
    public boolean queryForChanges() {
        return false;
    }
}

