/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.User;

public class CcrLicenseChecker {
    private final BooleanSupplier isCcrAllowed;
    private final BooleanSupplier isAuthAllowed;

    CcrLicenseChecker() {
        this(() -> XPackPlugin.getSharedLicenseState().checkFeature(XPackLicenseState.Feature.CCR), () -> ((XPackLicenseState)XPackPlugin.getSharedLicenseState()).isSecurityEnabled());
    }

    public CcrLicenseChecker(BooleanSupplier isCcrAllowed, BooleanSupplier isAuthAllowed) {
        this.isCcrAllowed = Objects.requireNonNull(isCcrAllowed, "isCcrAllowed");
        this.isAuthAllowed = Objects.requireNonNull(isAuthAllowed, "isAuthAllowed");
    }

    public boolean isCcrAllowed() {
        return this.isCcrAllowed.getAsBoolean();
    }

    public void checkRemoteClusterLicenseAndFetchLeaderIndexMetadataAndHistoryUUIDs(Client client, String clusterAlias, String leaderIndex, Consumer<Exception> onFailure, BiConsumer<String[], Tuple<IndexMetadata, DataStream>> consumer) {
        ClusterStateRequest request = new ClusterStateRequest();
        request.clear();
        request.metadata(true);
        request.indices(new String[]{leaderIndex});
        this.checkRemoteClusterLicenseAndFetchClusterState(client, clusterAlias, client.getRemoteClusterClient(clusterAlias), request, onFailure, remoteClusterStateResponse -> {
            ClusterState remoteClusterState = remoteClusterStateResponse.getState();
            IndexMetadata leaderIndexMetadata = remoteClusterState.getMetadata().index(leaderIndex);
            if (leaderIndexMetadata == null) {
                Object failure;
                IndexAbstraction indexAbstraction = (IndexAbstraction)remoteClusterState.getMetadata().getIndicesLookup().get(leaderIndex);
                if (indexAbstraction == null) {
                    failure = new IndexNotFoundException(leaderIndex);
                } else {
                    String message = String.format(Locale.ROOT, "cannot follow [%s], because it is a %s", leaderIndex, indexAbstraction.getType());
                    failure = new IllegalArgumentException(message);
                }
                onFailure.accept((Exception)failure);
                return;
            }
            if (leaderIndexMetadata.getState() == IndexMetadata.State.CLOSE) {
                onFailure.accept((Exception)new IndexClosedException(leaderIndexMetadata.getIndex()));
                return;
            }
            IndexAbstraction indexAbstraction = (IndexAbstraction)remoteClusterState.getMetadata().getIndicesLookup().get(leaderIndex);
            DataStream remoteDataStream = indexAbstraction.getParentDataStream() != null ? indexAbstraction.getParentDataStream().getDataStream() : null;
            Client remoteClient = client.getRemoteClusterClient(clusterAlias);
            this.hasPrivilegesToFollowIndices(remoteClient, new String[]{leaderIndex}, e -> {
                if (e == null) {
                    this.fetchLeaderHistoryUUIDs(remoteClient, leaderIndexMetadata, onFailure, historyUUIDs -> consumer.accept((String[])historyUUIDs, (Tuple<IndexMetadata, DataStream>)Tuple.tuple((Object)leaderIndexMetadata, (Object)remoteDataStream)));
                } else {
                    onFailure.accept((Exception)e);
                }
            });
        }, licenseCheck -> CcrLicenseChecker.indexMetadataNonCompliantRemoteLicense(leaderIndex, licenseCheck), e -> CcrLicenseChecker.indexMetadataUnknownRemoteLicense(leaderIndex, clusterAlias, e));
    }

    public void checkRemoteClusterLicenseAndFetchClusterState(Client client, String clusterAlias, ClusterStateRequest request, Consumer<Exception> onFailure, Consumer<ClusterStateResponse> leaderClusterStateConsumer) {
        try {
            Client remoteClient = CcrLicenseChecker.systemClient(client.getRemoteClusterClient(clusterAlias));
            this.checkRemoteClusterLicenseAndFetchClusterState(client, clusterAlias, remoteClient, request, onFailure, leaderClusterStateConsumer, CcrLicenseChecker::clusterStateNonCompliantRemoteLicense, e -> CcrLicenseChecker.clusterStateUnknownRemoteLicense(clusterAlias, e));
        }
        catch (Exception e2) {
            onFailure.accept(e2);
        }
    }

    private void checkRemoteClusterLicenseAndFetchClusterState(Client client, String clusterAlias, final Client remoteClient, final ClusterStateRequest request, final Consumer<Exception> onFailure, final Consumer<ClusterStateResponse> leaderClusterStateConsumer, final Function<RemoteClusterLicenseChecker.LicenseCheck, ElasticsearchStatusException> nonCompliantLicense, final Function<Exception, ElasticsearchStatusException> unknownLicense) {
        new RemoteClusterLicenseChecker(client, XPackLicenseState::isCcrAllowedForOperationMode).checkRemoteClusterLicenses(Collections.singletonList(clusterAlias), (ActionListener)new ActionListener<RemoteClusterLicenseChecker.LicenseCheck>(){

            public void onResponse(RemoteClusterLicenseChecker.LicenseCheck licenseCheck) {
                if (licenseCheck.isSuccess()) {
                    ActionListener clusterStateListener = ActionListener.wrap(leaderClusterStateConsumer::accept, (Consumer)onFailure);
                    remoteClient.admin().cluster().state(request, clusterStateListener);
                } else {
                    onFailure.accept((Exception)nonCompliantLicense.apply(licenseCheck));
                }
            }

            public void onFailure(Exception e) {
                onFailure.accept((Exception)unknownLicense.apply(e));
            }
        });
    }

    public void fetchLeaderHistoryUUIDs(Client remoteClient, IndexMetadata leaderIndexMetadata, Consumer<Exception> onFailure, Consumer<String[]> historyUUIDConsumer) {
        String leaderIndex = leaderIndexMetadata.getIndex().getName();
        CheckedConsumer indicesStatsHandler = indicesStatsResponse -> {
            IndexStats indexStats = (IndexStats)indicesStatsResponse.getIndices().get(leaderIndex);
            if (indexStats == null) {
                onFailure.accept(new IllegalArgumentException("no index stats available for the leader index"));
                return;
            }
            String[] historyUUIDs = new String[leaderIndexMetadata.getNumberOfShards()];
            for (IndexShardStats indexShardStats : indexStats) {
                for (ShardStats shardStats : indexShardStats) {
                    if (!shardStats.getShardRouting().primary()) continue;
                    CommitStats commitStats = shardStats.getCommitStats();
                    if (commitStats == null) {
                        onFailure.accept(new IllegalArgumentException("leader index's commit stats are missing"));
                        return;
                    }
                    String historyUUID = (String)commitStats.getUserData().get("history_uuid");
                    ShardId shardId = shardStats.getShardRouting().shardId();
                    historyUUIDs[shardId.id()] = historyUUID;
                }
            }
            for (int i = 0; i < historyUUIDs.length; ++i) {
                if (historyUUIDs[i] != null) continue;
                onFailure.accept(new IllegalArgumentException("no history uuid for [" + leaderIndex + "][" + i + "]"));
                return;
            }
            historyUUIDConsumer.accept(historyUUIDs);
        };
        IndicesStatsRequest request = new IndicesStatsRequest();
        request.clear();
        request.indices(new String[]{leaderIndex});
        remoteClient.admin().indices().stats(request, ActionListener.wrap((CheckedConsumer)indicesStatsHandler, onFailure));
    }

    public void hasPrivilegesToFollowIndices(Client remoteClient, String[] indices, Consumer<Exception> handler) {
        Objects.requireNonNull(remoteClient, "remoteClient");
        Objects.requireNonNull(indices, "indices");
        if (indices.length == 0) {
            throw new IllegalArgumentException("indices must not be empty");
        }
        Objects.requireNonNull(handler, "handler");
        if (!this.isAuthAllowed.getAsBoolean()) {
            handler.accept(null);
            return;
        }
        User user = this.getUser(remoteClient);
        if (user == null) {
            handler.accept(new IllegalStateException("missing or unable to read authentication info on request"));
            return;
        }
        String username = user.principal();
        RoleDescriptor.IndicesPrivileges privileges = RoleDescriptor.IndicesPrivileges.builder().indices(indices).privileges(new String[]{"indices:monitor/stats", "indices:data/read/xpack/ccr/shard_changes"}).build();
        HasPrivilegesRequest request = new HasPrivilegesRequest();
        request.username(username);
        request.clusterPrivileges(Strings.EMPTY_ARRAY);
        request.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{privileges});
        request.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
        CheckedConsumer responseHandler = response -> {
            if (response.isCompleteMatch()) {
                handler.accept(null);
            } else {
                StringBuilder message = new StringBuilder("insufficient privileges to follow");
                message.append(indices.length == 1 ? " index " : " indices ");
                message.append(Arrays.toString(indices));
                ResourcePrivileges resourcePrivileges = (ResourcePrivileges)response.getIndexPrivileges().iterator().next();
                for (Map.Entry entry : resourcePrivileges.getPrivileges().entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue()) continue;
                    message.append(", privilege for action [");
                    message.append((String)entry.getKey());
                    message.append("] is missing");
                }
                handler.accept((Exception)Exceptions.authorizationError((String)message.toString(), (Object[])new Object[0]));
            }
        };
        remoteClient.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)request, ActionListener.wrap((CheckedConsumer)responseHandler, handler));
    }

    User getUser(Client remoteClient) {
        ThreadContext threadContext = remoteClient.threadPool().getThreadContext();
        SecurityContext securityContext = new SecurityContext(Settings.EMPTY, threadContext);
        return securityContext.getUser();
    }

    public static Client wrapClient(final Client client, Map<String, String> headers) {
        if (headers.isEmpty()) {
            return client;
        }
        final Map filteredHeaders = ClientHelper.filterSecurityHeaders(headers);
        if (filteredHeaders.isEmpty()) {
            return client;
        }
        return new FilterClient(client){

            protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
                ClientHelper.executeWithHeadersAsync((Map)filteredHeaders, null, (Client)client, action, request, listener);
            }
        };
    }

    private static Client systemClient(Client client) {
        final ThreadContext threadContext = client.threadPool().getThreadContext();
        return new FilterClient(client){

            protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
                Supplier supplier = threadContext.newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                    threadContext.markAsSystemContext();
                    super.doExecute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
                }
            }
        };
    }

    private static ThreadContext.StoredContext stashWithHeaders(ThreadContext threadContext, Map<String, String> headers) {
        ThreadContext.StoredContext storedContext = threadContext.stashContext();
        threadContext.copyHeaders(headers.entrySet());
        return storedContext;
    }

    private static ElasticsearchStatusException indexMetadataNonCompliantRemoteLicense(String leaderIndex, RemoteClusterLicenseChecker.LicenseCheck licenseCheck) {
        String clusterAlias = licenseCheck.remoteClusterLicenseInfo().clusterAlias();
        String message = String.format(Locale.ROOT, "can not fetch remote index [%s:%s] metadata as the remote cluster [%s] is not licensed for [ccr]; %s", clusterAlias, leaderIndex, clusterAlias, RemoteClusterLicenseChecker.buildErrorMessage((String)"ccr", (RemoteClusterLicenseChecker.RemoteClusterLicenseInfo)licenseCheck.remoteClusterLicenseInfo(), RemoteClusterLicenseChecker::isAllowedByLicense));
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]);
    }

    private static ElasticsearchStatusException clusterStateNonCompliantRemoteLicense(RemoteClusterLicenseChecker.LicenseCheck licenseCheck) {
        String clusterAlias = licenseCheck.remoteClusterLicenseInfo().clusterAlias();
        String message = String.format(Locale.ROOT, "can not fetch remote cluster state as the remote cluster [%s] is not licensed for [ccr]; %s", clusterAlias, RemoteClusterLicenseChecker.buildErrorMessage((String)"ccr", (RemoteClusterLicenseChecker.RemoteClusterLicenseInfo)licenseCheck.remoteClusterLicenseInfo(), RemoteClusterLicenseChecker::isAllowedByLicense));
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]);
    }

    private static ElasticsearchStatusException indexMetadataUnknownRemoteLicense(String leaderIndex, String clusterAlias, Exception cause) {
        String message = String.format(Locale.ROOT, "can not fetch remote index [%s:%s] metadata as the license state of the remote cluster [%s] could not be determined", clusterAlias, leaderIndex, clusterAlias);
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, (Throwable)cause, new Object[0]);
    }

    private static ElasticsearchStatusException clusterStateUnknownRemoteLicense(String clusterAlias, Exception cause) {
        String message = String.format(Locale.ROOT, "can not fetch remote cluster state as the license state of the remote cluster [%s] could not be determined", clusterAlias);
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, (Throwable)cause, new Object[0]);
    }
}

