/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.io.IOException;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.Field;
import org.elasticsearch.script.FieldValues;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongField;

public class UnsignedLongScriptDocValues
extends ScriptDocValues<Long> {
    private final SortedNumericDocValues in;
    private long[] values = new long[0];
    private int count;

    public UnsignedLongScriptDocValues(SortedNumericDocValues in) {
        this.in = in;
    }

    public void setNextDocId(int docId) throws IOException {
        if (this.in.advanceExact(docId)) {
            this.resize(this.in.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = this.in.nextValue();
            }
        } else {
            this.resize(0);
        }
    }

    protected void resize(int newSize) {
        this.count = newSize;
        this.values = ArrayUtil.grow((long[])this.values, (int)this.count);
    }

    public long getValue() {
        this.throwIfEmpty();
        return this.format(0);
    }

    public Long get(int index) {
        this.throwIfEmpty();
        return this.format(index);
    }

    protected long format(int index) {
        return UnsignedLongScriptDocValues.shiftedLong(this.values[index]);
    }

    static long shiftedLong(long unshifted) {
        return unshifted ^ Long.MIN_VALUE;
    }

    public int size() {
        return this.count;
    }

    public long getLongValue() {
        this.throwIfEmpty();
        return this.format(0);
    }

    public double getDoubleValue() {
        this.throwIfEmpty();
        return this.format(0);
    }

    public Field<Long> toField(String fieldName) {
        return new UnsignedLongField(fieldName, (FieldValues<Long>)this);
    }
}

