/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentSubParser;
import org.elasticsearch.common.xcontent.support.MapXContentParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.geometry.utils.WellKnownText;

public class CartesianPoint
implements ToXContentFragment {
    private static final ParseField X_FIELD = new ParseField("x", new String[0]);
    private static final ParseField Y_FIELD = new ParseField("y", new String[0]);
    private static final ParseField Z_FIELD = new ParseField("z", new String[0]);
    protected double x;
    protected double y;

    public CartesianPoint() {
    }

    public CartesianPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public CartesianPoint reset(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public CartesianPoint resetFromString(String value, boolean ignoreZValue) {
        if (value.toLowerCase(Locale.ROOT).contains("point")) {
            return this.resetFromWKT(value, ignoreZValue);
        }
        return this.resetFromCoordinates(value, ignoreZValue);
    }

    public CartesianPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        double y;
        double x;
        String[] vals = value.split(",");
        if (vals.length > 3 || vals.length < 2) {
            throw new ElasticsearchParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", new Object[]{vals, vals.length});
        }
        try {
            x = Double.parseDouble(vals[0].trim());
            if (!Double.isFinite(x)) {
                throw new ElasticsearchParseException("invalid [{}] value [{}]; must be between -3.4028234663852886E38 and 3.4028234663852886E38", new Object[]{X_FIELD.getPreferredName(), x});
            }
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("[{}]] must be a number", new Object[]{X_FIELD.getPreferredName()});
        }
        try {
            y = Double.parseDouble(vals[1].trim());
            if (!Double.isFinite(y)) {
                throw new ElasticsearchParseException("invalid [{}] value [{}]; must be between -3.4028234663852886E38 and 3.4028234663852886E38", new Object[]{Y_FIELD.getPreferredName(), y});
            }
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("[{}]] must be a number", new Object[]{Y_FIELD.getPreferredName()});
        }
        if (vals.length > 2) {
            try {
                CartesianPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
            }
            catch (NumberFormatException ex) {
                throw new ElasticsearchParseException("[{}]] must be a number", new Object[]{Y_FIELD.getPreferredName()});
            }
        }
        return this.reset(x, y);
    }

    private CartesianPoint resetFromWKT(String value, boolean ignoreZValue) {
        Geometry geometry;
        try {
            geometry = WellKnownText.fromWKT((GeometryValidator)StandardValidator.instance((boolean)ignoreZValue), (boolean)false, (String)value);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid WKT format", (Throwable)e, new Object[0]);
        }
        if (geometry.type() != ShapeType.POINT) {
            throw new ElasticsearchParseException("[{}] supports only POINT among WKT primitives, but found {}", new Object[]{"point", geometry.type()});
        }
        Point point = (Point)geometry;
        return this.reset(point.getX(), point.getY());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartesianPoint point = (CartesianPoint)o;
        if (Double.compare(point.x, this.x) != 0) {
            return false;
        }
        return Double.compare(point.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return this.x + ", " + this.y;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(X_FIELD.getPreferredName(), this.x).field(Y_FIELD.getPreferredName(), this.y).endObject();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CartesianPoint parsePoint(XContentParser parser, CartesianPoint point, boolean ignoreZvalue) throws IOException, ElasticsearchParseException {
        block37: {
            x = NaN;
            y = NaN;
            numberFormatException = null;
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) break block37;
            subParser = new XContentSubParser(parser);
            ** GOTO lbl15
        }
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            if (parser.currentToken() != XContentParser.Token.VALUE_STRING) throw new ElasticsearchParseException("point expected", new Object[0]);
            val = parser.text();
            return point.resetFromString(val, ignoreZvalue);
        }
        subParser = new XContentSubParser(parser);
        try {
            block38: {
                break block38;
lbl15:
                // 1 sources

                try {
                    block25: while (subParser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if (subParser.currentToken() != XContentParser.Token.FIELD_NAME) {
                            throw new ElasticsearchParseException("token [{}] not allowed", new Object[]{subParser.currentToken()});
                        }
                        field = subParser.currentName();
                        if (field.equals(CartesianPoint.X_FIELD.getPreferredName())) {
                            subParser.nextToken();
                            switch (1.$SwitchMap$org$elasticsearch$common$xcontent$XContentParser$Token[subParser.currentToken().ordinal()]) {
                                case 1: 
                                case 2: {
                                    try {
                                        x = subParser.doubleValue(true);
                                    }
                                    catch (NumberFormatException e) {
                                        numberFormatException = e;
                                    }
                                    continue block25;
                                }
                            }
                            throw new ElasticsearchParseException("[{}] must be a number", new Object[]{CartesianPoint.X_FIELD.getPreferredName()});
                        }
                        if (field.equals(CartesianPoint.Y_FIELD.getPreferredName())) {
                            subParser.nextToken();
                            switch (1.$SwitchMap$org$elasticsearch$common$xcontent$XContentParser$Token[subParser.currentToken().ordinal()]) {
                                case 1: 
                                case 2: {
                                    try {
                                        y = subParser.doubleValue(true);
                                    }
                                    catch (NumberFormatException e) {
                                        numberFormatException = e;
                                    }
                                    continue block25;
                                }
                            }
                            throw new ElasticsearchParseException("[{}] must be a number", new Object[]{CartesianPoint.Y_FIELD.getPreferredName()});
                        }
                        if (!field.equals(CartesianPoint.Z_FIELD.getPreferredName())) {
                            throw new ElasticsearchParseException("field must be either [{}] or [{}]", new Object[]{CartesianPoint.X_FIELD.getPreferredName(), CartesianPoint.Y_FIELD.getPreferredName()});
                        }
                        subParser.nextToken();
                        switch (1.$SwitchMap$org$elasticsearch$common$xcontent$XContentParser$Token[subParser.currentToken().ordinal()]) {
                            case 1: 
                            case 2: {
                                try {
                                    CartesianPoint.assertZValue(ignoreZvalue, subParser.doubleValue(true));
                                }
                                catch (NumberFormatException e) {
                                    numberFormatException = e;
                                }
                                continue block25;
                            }
                        }
                        throw new ElasticsearchParseException("[{}] must be a number", new Object[]{CartesianPoint.Z_FIELD.getPreferredName()});
                    }
                }
                finally {
                    subParser.close();
                }
                if (numberFormatException != null) {
                    throw new ElasticsearchParseException("[{}] and [{}] must be valid double values", numberFormatException, new Object[]{CartesianPoint.X_FIELD.getPreferredName(), CartesianPoint.Y_FIELD.getPreferredName()});
                }
                if (Double.isNaN(x)) {
                    throw new ElasticsearchParseException("field [{}] missing", new Object[]{CartesianPoint.X_FIELD.getPreferredName()});
                }
                if (Double.isNaN(y) == false) return point.reset(x, y);
                throw new ElasticsearchParseException("field [{}] missing", new Object[]{CartesianPoint.Y_FIELD.getPreferredName()});
            }
            element = 0;
            while (subParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (subParser.currentToken() != XContentParser.Token.VALUE_NUMBER) throw new ElasticsearchParseException("numeric value expected", new Object[0]);
                if (++element == 1) {
                    x = subParser.doubleValue();
                    continue;
                }
                if (element != 2) throw new ElasticsearchParseException("[{}}] field type does not accept > 2 dimensions", new Object[]{"point"});
                y = subParser.doubleValue();
            }
            return point.reset(x, y);
        }
        finally {
            subParser.close();
        }
    }

    public static CartesianPoint parsePoint(Object value, boolean ignoreZValue) throws ElasticsearchParseException {
        return CartesianPoint.parsePoint(value, new CartesianPoint(), ignoreZValue);
    }

    public static CartesianPoint parsePoint(Object value, CartesianPoint point, boolean ignoreZValue) throws ElasticsearchParseException {
        CartesianPoint cartesianPoint;
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("null_value", value), null);
        try {
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            cartesianPoint = CartesianPoint.parsePoint((XContentParser)parser, point, ignoreZValue);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ElasticsearchParseException("error parsing point", (Throwable)ex, new Object[0]);
            }
        }
        parser.close();
        return cartesianPoint;
    }

    public static double assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [ignore_z_value] parameter is [{}]", new Object[]{zValue, ignoreZValue});
        }
        if (!Double.isFinite(zValue)) {
            throw new ElasticsearchParseException("invalid [{}] value [{}]; must be between -3.4028234663852886E38 and 3.4028234663852886E38", new Object[]{Z_FIELD.getPreferredName(), zValue});
        }
        return zValue;
    }
}

