/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.index.PointValues;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.TriangleTreeReader;

public abstract class Component2DVisitor
implements TriangleTreeReader.Visitor {
    protected final Component2D component2D;
    private final CoordinateEncoder encoder;

    private Component2DVisitor(Component2D component2D, CoordinateEncoder encoder) {
        this.component2D = component2D;
        this.encoder = encoder;
    }

    public abstract boolean matches();

    public abstract void reset();

    @Override
    public void visitPoint(int x, int y) {
        this.doVisitPoint(this.encoder.decodeX(x), this.encoder.decodeY(y));
    }

    abstract void doVisitPoint(double var1, double var3);

    @Override
    public void visitLine(int aX, int aY, int bX, int bY, byte metadata) {
        this.doVisitLine(this.encoder.decodeX(aX), this.encoder.decodeY(aY), this.encoder.decodeX(bX), this.encoder.decodeY(bY), metadata);
    }

    abstract void doVisitLine(double var1, double var3, double var5, double var7, byte var9);

    @Override
    public void visitTriangle(int aX, int aY, int bX, int bY, int cX, int cY, byte metadata) {
        this.doVisitTriangle(this.encoder.decodeX(aX), this.encoder.decodeY(aY), this.encoder.decodeX(bX), this.encoder.decodeY(bY), this.encoder.decodeX(cX), this.encoder.decodeY(cY), metadata);
    }

    abstract void doVisitTriangle(double var1, double var3, double var5, double var7, double var9, double var11, byte var13);

    @Override
    public boolean pushX(int minX) {
        return this.component2D.getMaxX() >= this.encoder.decodeX(minX);
    }

    @Override
    public boolean pushY(int minY) {
        return this.component2D.getMaxY() >= this.encoder.decodeY(minY);
    }

    @Override
    public boolean push(int maxX, int maxY) {
        return this.component2D.getMinX() <= this.encoder.decodeX(maxX) && this.component2D.getMinY() <= this.encoder.decodeY(maxY);
    }

    @Override
    public boolean push(int minX, int minY, int maxX, int maxY) {
        PointValues.Relation relation = this.component2D.relate(this.encoder.decodeX(minX), this.encoder.decodeX(maxX), this.encoder.decodeY(minY), this.encoder.decodeY(maxY));
        return this.doPush(relation);
    }

    abstract boolean doPush(PointValues.Relation var1);

    public static Component2DVisitor getVisitor(Component2D component2D, ShapeField.QueryRelation relation, CoordinateEncoder encoder) {
        switch (relation) {
            case CONTAINS: {
                return new ContainsVisitor(component2D, encoder);
            }
            case INTERSECTS: {
                return new IntersectsVisitor(component2D, encoder);
            }
            case DISJOINT: {
                return new DisjointVisitor(component2D, encoder);
            }
            case WITHIN: {
                return new WithinVisitor(component2D, encoder);
            }
        }
        throw new IllegalArgumentException("Invalid query relation:[" + relation + "]");
    }

    private static class ContainsVisitor
    extends Component2DVisitor {
        Component2D.WithinRelation answer = Component2D.WithinRelation.DISJOINT;

        private ContainsVisitor(Component2D component2D, CoordinateEncoder encoder) {
            super(component2D, encoder);
        }

        @Override
        public boolean matches() {
            return this.answer == Component2D.WithinRelation.CANDIDATE;
        }

        @Override
        public void reset() {
            this.answer = Component2D.WithinRelation.DISJOINT;
        }

        @Override
        void doVisitPoint(double x, double y) {
            Component2D.WithinRelation rel = this.component2D.withinPoint(x, y);
            if (rel != Component2D.WithinRelation.DISJOINT) {
                this.answer = rel;
            }
        }

        @Override
        void doVisitLine(double aX, double aY, double bX, double bY, byte metadata) {
            boolean ab = (metadata & 0x10) == 16;
            Component2D.WithinRelation rel = this.component2D.withinLine(aX, aY, ab, bX, bY);
            if (rel != Component2D.WithinRelation.DISJOINT) {
                this.answer = rel;
            }
        }

        @Override
        void doVisitTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
            boolean ca;
            boolean bc;
            boolean ab = (metadata & 0x10) == 16;
            Component2D.WithinRelation rel = this.component2D.withinTriangle(aX, aY, ab, bX, bY, bc = (metadata & 0x20) == 32, cX, cY, ca = (metadata & 0x40) == 64);
            if (rel != Component2D.WithinRelation.DISJOINT) {
                this.answer = rel;
            }
        }

        @Override
        public boolean push() {
            return this.answer != Component2D.WithinRelation.NOTWITHIN;
        }

        @Override
        boolean doPush(PointValues.Relation relation) {
            return relation == PointValues.Relation.CELL_CROSSES_QUERY;
        }
    }

    private static class IntersectsVisitor
    extends Component2DVisitor {
        boolean intersects;

        private IntersectsVisitor(Component2D component2D, CoordinateEncoder encoder) {
            super(component2D, encoder);
        }

        @Override
        public boolean matches() {
            return this.intersects;
        }

        @Override
        public void reset() {
            this.intersects = false;
        }

        @Override
        void doVisitPoint(double x, double y) {
            this.intersects = this.component2D.contains(x, y);
        }

        @Override
        void doVisitLine(double aX, double aY, double bX, double bY, byte metadata) {
            this.intersects = this.component2D.intersectsLine(aX, aY, bX, bY);
        }

        @Override
        void doVisitTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
            this.intersects = this.component2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
        }

        @Override
        public boolean push() {
            return !this.intersects;
        }

        @Override
        boolean doPush(PointValues.Relation relation) {
            if (relation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return false;
            }
            if (relation == PointValues.Relation.CELL_INSIDE_QUERY) {
                this.intersects = true;
                return false;
            }
            return true;
        }
    }

    private static class DisjointVisitor
    extends Component2DVisitor {
        boolean disjoint = true;

        private DisjointVisitor(Component2D component2D, CoordinateEncoder encoder) {
            super(component2D, encoder);
        }

        @Override
        public boolean matches() {
            return this.disjoint;
        }

        @Override
        public void reset() {
            this.disjoint = true;
        }

        @Override
        void doVisitPoint(double x, double y) {
            this.disjoint = !this.component2D.contains(x, y);
        }

        @Override
        void doVisitLine(double aX, double aY, double bX, double bY, byte metadata) {
            this.disjoint = !this.component2D.intersectsLine(aX, aY, bX, bY);
        }

        @Override
        void doVisitTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
            this.disjoint = !this.component2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
        }

        @Override
        public boolean push() {
            return this.disjoint;
        }

        @Override
        boolean doPush(PointValues.Relation relation) {
            if (relation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return false;
            }
            if (relation == PointValues.Relation.CELL_INSIDE_QUERY) {
                this.disjoint = false;
                return false;
            }
            return true;
        }
    }

    private static class WithinVisitor
    extends Component2DVisitor {
        boolean within = true;

        private WithinVisitor(Component2D component2D, CoordinateEncoder encoder) {
            super(component2D, encoder);
        }

        @Override
        public boolean matches() {
            return this.within;
        }

        @Override
        public void reset() {
            this.within = true;
        }

        @Override
        void doVisitPoint(double x, double y) {
            this.within = this.component2D.contains(x, y);
        }

        @Override
        void doVisitLine(double aX, double aY, double bX, double bY, byte metadata) {
            this.within = this.component2D.containsLine(aX, aY, bX, bY);
        }

        @Override
        void doVisitTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
            this.within = this.component2D.containsTriangle(aX, aY, bX, bY, cX, cY);
        }

        @Override
        public boolean push() {
            return this.within;
        }

        @Override
        public boolean pushX(int minX) {
            this.within = super.pushX(minX);
            return this.within;
        }

        @Override
        public boolean pushY(int minY) {
            this.within = super.pushY(minY);
            return this.within;
        }

        @Override
        public boolean push(int maxX, int maxY) {
            this.within = super.push(maxX, maxY);
            return this.within;
        }

        @Override
        boolean doPush(PointValues.Relation relation) {
            if (relation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                this.within = false;
            }
            return this.within;
        }
    }
}

