/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.ldap.sdk.unboundidds.monitors.ReplicationSummaryReplica;
import com.unboundid.ldap.sdk.unboundidds.monitors.ReplicationSummaryReplicationServer;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplicationSummaryMonitorEntry
extends MonitorEntry {
    static final String REPLICATION_SUMMARY_MONITOR_OC = "ds-replication-server-summary-monitor-entry";
    private static final String ATTR_BASE_DN = "base-dn";
    private static final String ATTR_REPLICATION_SERVER = "replication-server";
    private static final String ATTR_REPLICA = "replica";
    private static final long serialVersionUID = 3144471025744197014L;
    private final String baseDN = this.getString("base-dn");
    private final List<ReplicationSummaryReplica> replicas;
    private final List<ReplicationSummaryReplicationServer> replicationServers;

    public ReplicationSummaryMonitorEntry(Entry entry) {
        super(entry);
        List<String> replicaStrings = this.getStrings(ATTR_REPLICA);
        ArrayList<ReplicationSummaryReplica> replList = new ArrayList<ReplicationSummaryReplica>(replicaStrings.size());
        for (String s : replicaStrings) {
            replList.add(new ReplicationSummaryReplica(s));
        }
        this.replicas = Collections.unmodifiableList(replList);
        List<String> serverStrings = this.getStrings(ATTR_REPLICATION_SERVER);
        ArrayList<ReplicationSummaryReplicationServer> serverList = new ArrayList<ReplicationSummaryReplicationServer>(serverStrings.size());
        for (String s : serverStrings) {
            serverList.add(new ReplicationSummaryReplicationServer(s));
        }
        this.replicationServers = Collections.unmodifiableList(serverList);
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public List<ReplicationSummaryReplica> getReplicas() {
        return this.replicas;
    }

    public List<ReplicationSummaryReplicationServer> getReplicationServers() {
        return this.replicationServers;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_REPLICATION_SUMMARY_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_REPLICATION_SUMMARY_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(10);
        if (this.baseDN != null) {
            ReplicationSummaryMonitorEntry.addMonitorAttribute(attrs, ATTR_BASE_DN, MonitorMessages.INFO_REPLICATION_SUMMARY_DISPNAME_BASE_DN.get(), MonitorMessages.INFO_REPLICATION_SUMMARY_DESC_BASE_DN.get(), this.baseDN);
        }
        if (!this.replicas.isEmpty()) {
            ArrayList<String> replStrings = new ArrayList<String>(this.replicas.size());
            for (ReplicationSummaryReplica r : this.replicas) {
                replStrings.add(r.toString());
            }
            ReplicationSummaryMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICA, MonitorMessages.INFO_REPLICATION_SUMMARY_DISPNAME_REPLICA.get(), MonitorMessages.INFO_REPLICATION_SUMMARY_DESC_REPLICA.get(), replStrings);
        }
        if (!this.replicationServers.isEmpty()) {
            ArrayList<String> serverStrings = new ArrayList<String>(this.replicationServers.size());
            for (ReplicationSummaryReplicationServer s : this.replicationServers) {
                serverStrings.add(s.toString());
            }
            ReplicationSummaryMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_SERVER, MonitorMessages.INFO_REPLICATION_SUMMARY_DISPNAME_REPLICATION_SERVER.get(), MonitorMessages.INFO_REPLICATION_SUMMARY_DESC_REPLICATION_SERVER.get(), serverStrings);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

