/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPTestUtils {
    private LDAPTestUtils() {
    }

    public static Entry generateDomainEntry(String name, String parentDN, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateDomainEntry(name, parentDN, StaticUtils.toList(additionalAttributes));
    }

    public static Entry generateDomainEntry(String name, String parentDN, Collection<Attribute> additionalAttributes) {
        return LDAPTestUtils.generateEntry("dc", name, parentDN, new String[]{"top", "domain"}, additionalAttributes);
    }

    public static Entry generateOrgEntry(String name, String parentDN, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateOrgEntry(name, parentDN, StaticUtils.toList(additionalAttributes));
    }

    public static Entry generateOrgEntry(String name, String parentDN, Collection<Attribute> additionalAttributes) {
        return LDAPTestUtils.generateEntry("o", name, parentDN, new String[]{"top", "organization"}, additionalAttributes);
    }

    public static Entry generateOrgUnitEntry(String name, String parentDN, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateOrgUnitEntry(name, parentDN, StaticUtils.toList(additionalAttributes));
    }

    public static Entry generateOrgUnitEntry(String name, String parentDN, Collection<Attribute> additionalAttributes) {
        return LDAPTestUtils.generateEntry("ou", name, parentDN, new String[]{"top", "organizationalUnit"}, additionalAttributes);
    }

    public static Entry generateCountryEntry(String name, String parentDN, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateCountryEntry(name, parentDN, StaticUtils.toList(additionalAttributes));
    }

    public static Entry generateCountryEntry(String name, String parentDN, Collection<Attribute> additionalAttributes) {
        return LDAPTestUtils.generateEntry("c", name, parentDN, new String[]{"top", "country"}, additionalAttributes);
    }

    public static Entry generateUserEntry(String uid, String parentDN, String firstName, String lastName, String password, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateUserEntry(uid, parentDN, firstName, lastName, password, StaticUtils.toList(additionalAttributes));
    }

    public static Entry generateUserEntry(String uid, String parentDN, String firstName, String lastName, String password, Collection<Attribute> additionalAttributes) {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(4);
        attrList.add(new Attribute("givenName", firstName));
        attrList.add(new Attribute("sn", lastName));
        attrList.add(new Attribute("cn", firstName + ' ' + lastName));
        if (password != null) {
            attrList.add(new Attribute("userPassword", password));
        }
        if (additionalAttributes != null) {
            attrList.addAll(additionalAttributes);
        }
        String[] objectClasses = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"};
        return LDAPTestUtils.generateEntry("uid", uid, parentDN, objectClasses, attrList);
    }

    public static Entry generateGroupOfNamesEntry(String name, String parentDN, String ... memberDNs) {
        return LDAPTestUtils.generateGroupOfNamesEntry(name, parentDN, StaticUtils.toList(memberDNs));
    }

    public static Entry generateGroupOfNamesEntry(String name, String parentDN, Collection<String> memberDNs) {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(new Attribute("member", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), memberDNs));
        return LDAPTestUtils.generateEntry("cn", name, parentDN, new String[]{"top", "groupOfNames"}, attrList);
    }

    public static Entry generateGroupOfUniqueNamesEntry(String name, String parentDN, String ... memberDNs) {
        return LDAPTestUtils.generateGroupOfUniqueNamesEntry(name, parentDN, StaticUtils.toList(memberDNs));
    }

    public static Entry generateGroupOfUniqueNamesEntry(String name, String parentDN, Collection<String> memberDNs) {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(new Attribute("uniqueMember", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), memberDNs));
        return LDAPTestUtils.generateEntry("cn", name, parentDN, new String[]{"top", "groupOfUniqueNames"}, attrList);
    }

    private static Entry generateEntry(String rdnAttr, String rdnValue, String parentDN, String[] objectClasses, Collection<Attribute> additionalAttributes) {
        RDN rdn = new RDN(rdnAttr, rdnValue);
        String dn = parentDN == null || parentDN.trim().isEmpty() ? rdn.toString() : rdn.toString() + ',' + parentDN;
        Entry entry = new Entry(dn, new Attribute("objectClass", objectClasses), new Attribute(rdnAttr, rdnValue));
        if (additionalAttributes != null) {
            for (Attribute a : additionalAttributes) {
                entry.addAttribute(a);
            }
        }
        return entry;
    }

    public static boolean entryExists(LDAPInterface conn, String dn) throws LDAPException {
        return conn.getEntry(dn, "1.1") != null;
    }

    public static boolean entryExists(LDAPInterface conn, String dn, String filter) throws LDAPException {
        try {
            SearchResult searchResult = conn.search(dn, SearchScope.BASE, filter, "1.1");
            return searchResult.getEntryCount() == 1;
        }
        catch (LDAPException le) {
            if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return false;
            }
            throw le;
        }
    }

    public static boolean entryExists(LDAPInterface conn, Entry entry) throws LDAPException {
        Collection<Attribute> attrs = entry.getAttributes();
        ArrayList<Filter> comps = new ArrayList<Filter>(attrs.size());
        for (Attribute a : attrs) {
            for (byte[] value : a.getValueByteArrays()) {
                comps.add(Filter.createEqualityFilter(a.getName(), value));
            }
        }
        try {
            SearchResult searchResult = conn.search(entry.getDN(), SearchScope.BASE, Filter.createANDFilter(comps), "1.1");
            return searchResult.getEntryCount() == 1;
        }
        catch (LDAPException le) {
            if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return false;
            }
            throw le;
        }
    }

    public static void assertEntryExists(LDAPInterface conn, String dn) throws LDAPException, AssertionError {
        if (conn.getEntry(dn, "1.1") == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
        }
    }

    public static void assertEntryExists(LDAPInterface conn, String dn, String filter) throws LDAPException, AssertionError {
        try {
            SearchResult searchResult = conn.search(dn, SearchScope.BASE, filter, "1.1");
            if (searchResult.getEntryCount() == 0) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_DOES_NOT_MATCH_FILTER.get(dn, filter));
            }
        }
        catch (LDAPException le) {
            if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
            }
            throw le;
        }
    }

    public static void assertEntryExists(LDAPInterface conn, Entry entry) throws LDAPException, AssertionError {
        if (LDAPTestUtils.entryExists(conn, entry)) {
            return;
        }
        Collection<Attribute> attributes = entry.getAttributes();
        ArrayList<String> messages = new ArrayList<String>(attributes.size());
        for (Attribute a : attributes) {
            try {
                SearchResult searchResult = conn.search(entry.getDN(), SearchScope.BASE, Filter.createPresenceFilter(a.getName()), "1.1");
                if (searchResult.getEntryCount() == 0) {
                    messages.add(UtilityMessages.ERR_TEST_ATTR_MISSING.get(entry.getDN(), a.getName()));
                    continue;
                }
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(entry.getDN()));
                }
                throw le;
            }
            for (byte[] value : a.getValueByteArrays()) {
                SearchResult searchResult = conn.search(entry.getDN(), SearchScope.BASE, Filter.createEqualityFilter(a.getName(), value), "1.1");
                if (searchResult.getEntryCount() != 0) continue;
                messages.add(UtilityMessages.ERR_TEST_VALUE_MISSING.get(entry.getDN(), a.getName(), StaticUtils.toUTF8String(value)));
            }
        }
        if (!messages.isEmpty()) {
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    public static List<String> getMissingEntryDNs(LDAPInterface conn, String ... dns) throws LDAPException {
        return LDAPTestUtils.getMissingEntryDNs(conn, StaticUtils.toList(dns));
    }

    public static List<String> getMissingEntryDNs(LDAPInterface conn, Collection<String> dns) throws LDAPException {
        ArrayList<String> missingDNs = new ArrayList<String>(dns.size());
        for (String dn : dns) {
            if (conn.getEntry(dn, "1.1") != null) continue;
            missingDNs.add(dn);
        }
        return missingDNs;
    }

    public static void assertEntriesExist(LDAPInterface conn, String ... dns) throws LDAPException, AssertionError {
        LDAPTestUtils.assertEntriesExist(conn, StaticUtils.toList(dns));
    }

    public static void assertEntriesExist(LDAPInterface conn, Collection<String> dns) throws LDAPException, AssertionError {
        List<String> missingDNs = LDAPTestUtils.getMissingEntryDNs(conn, dns);
        if (missingDNs.isEmpty()) {
            return;
        }
        ArrayList<String> msgList = new ArrayList<String>(missingDNs.size());
        for (String dn : missingDNs) {
            msgList.add(UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
        }
        throw new AssertionError((Object)StaticUtils.concatenateStrings(msgList));
    }

    public static List<String> getMissingAttributeNames(LDAPInterface conn, String dn, String ... attributeNames) throws LDAPException {
        return LDAPTestUtils.getMissingAttributeNames(conn, dn, StaticUtils.toList(attributeNames));
    }

    public static List<String> getMissingAttributeNames(LDAPInterface conn, String dn, Collection<String> attributeNames) throws LDAPException {
        ArrayList<String> missingAttrs = new ArrayList<String>(attributeNames.size());
        for (String attrName : attributeNames) {
            try {
                SearchResult result = conn.search(dn, SearchScope.BASE, Filter.createPresenceFilter(attrName), new String[0]);
                if (result.getEntryCount() != 0) continue;
                missingAttrs.add(attrName);
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    return null;
                }
                throw le;
            }
        }
        return missingAttrs;
    }

    public static void assertAttributeExists(LDAPInterface conn, String dn, String ... attributeNames) throws LDAPException, AssertionError {
        LDAPTestUtils.assertAttributeExists(conn, dn, StaticUtils.toList(attributeNames));
    }

    public static void assertAttributeExists(LDAPInterface conn, String dn, Collection<String> attributeNames) throws LDAPException, AssertionError {
        List<String> missingAttrs = LDAPTestUtils.getMissingAttributeNames(conn, dn, attributeNames);
        if (missingAttrs == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
        }
        if (missingAttrs.isEmpty()) {
            return;
        }
        ArrayList<String> msgList = new ArrayList<String>(missingAttrs.size());
        for (String attrName : missingAttrs) {
            msgList.add(UtilityMessages.ERR_TEST_ATTR_MISSING.get(dn, attrName));
        }
        throw new AssertionError((Object)StaticUtils.concatenateStrings(msgList));
    }

    public static List<String> getMissingAttributeValues(LDAPInterface conn, String dn, String attributeName, String ... attributeValues) throws LDAPException {
        return LDAPTestUtils.getMissingAttributeValues(conn, dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public static List<String> getMissingAttributeValues(LDAPInterface conn, String dn, String attributeName, Collection<String> attributeValues) throws LDAPException {
        ArrayList<String> missingValues = new ArrayList<String>(attributeValues.size());
        for (String value : attributeValues) {
            try {
                SearchResult searchResult = conn.search(dn, SearchScope.BASE, Filter.createEqualityFilter(attributeName, value), "1.1");
                if (searchResult.getEntryCount() != 0) continue;
                missingValues.add(value);
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    return null;
                }
                throw le;
            }
        }
        return missingValues;
    }

    public static void assertValueExists(LDAPInterface conn, String dn, String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        LDAPTestUtils.assertValueExists(conn, dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public static void assertValueExists(LDAPInterface conn, String dn, String attributeName, Collection<String> attributeValues) throws LDAPException, AssertionError {
        List<String> missingValues = LDAPTestUtils.getMissingAttributeValues(conn, dn, attributeName, attributeValues);
        if (missingValues == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
        }
        if (missingValues.isEmpty()) {
            return;
        }
        SearchResultEntry entry = conn.getEntry(dn, attributeName);
        if (entry != null && entry.hasAttribute(attributeName)) {
            Attribute a = entry.getAttribute(attributeName);
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ATTR_MISSING_VALUE.get(dn, attributeName, StaticUtils.concatenateStrings("{", " '", ",", "'", " }", a.getValues()), StaticUtils.concatenateStrings("{", " '", ",", "'", " }", missingValues)));
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_ATTR_MISSING.get(dn, attributeName));
    }

    public static void assertEntryMissing(LDAPInterface conn, String dn) throws LDAPException, AssertionError {
        if (conn.getEntry(dn, "1.1") != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_EXISTS.get(dn));
        }
    }

    public static void assertAttributeMissing(LDAPInterface conn, String dn, String ... attributeNames) throws LDAPException, AssertionError {
        LDAPTestUtils.assertAttributeMissing(conn, dn, StaticUtils.toList(attributeNames));
    }

    public static void assertAttributeMissing(LDAPInterface conn, String dn, Collection<String> attributeNames) throws LDAPException, AssertionError {
        ArrayList<String> messages = new ArrayList<String>(attributeNames.size());
        for (String attrName : attributeNames) {
            try {
                SearchResult searchResult = conn.search(dn, SearchScope.BASE, Filter.createPresenceFilter(attrName), attrName);
                if (searchResult.getEntryCount() != 1) continue;
                Attribute a = searchResult.getSearchEntries().get(0).getAttribute(attrName);
                if (a == null) {
                    messages.add(UtilityMessages.ERR_TEST_ATTR_EXISTS.get(dn, attrName));
                    continue;
                }
                messages.add(UtilityMessages.ERR_TEST_ATTR_EXISTS_WITH_VALUES.get(dn, attrName, StaticUtils.concatenateStrings("{", " '", ",", "'", " }", a.getValues())));
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
                }
                throw le;
            }
        }
        if (!messages.isEmpty()) {
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    public static void assertValueMissing(LDAPInterface conn, String dn, String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        LDAPTestUtils.assertValueMissing(conn, dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public static void assertValueMissing(LDAPInterface conn, String dn, String attributeName, Collection<String> attributeValues) throws LDAPException, AssertionError {
        ArrayList<String> messages = new ArrayList<String>(attributeValues.size());
        for (String value : attributeValues) {
            try {
                SearchResult searchResult = conn.search(dn, SearchScope.BASE, Filter.createEqualityFilter(attributeName, value), "1.1");
                if (searchResult.getEntryCount() != 1) continue;
                messages.add(UtilityMessages.ERR_TEST_VALUE_EXISTS.get(dn, attributeName, value));
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
                }
                throw le;
            }
        }
        if (!messages.isEmpty()) {
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    public static void assertResultCodeEquals(LDAPResult result, ResultCode ... acceptableResultCodes) throws AssertionError {
        for (ResultCode rc : acceptableResultCodes) {
            if (!rc.equals(result.getResultCode())) continue;
            return;
        }
        if (acceptableResultCodes.length == 1) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_MISSING.get(String.valueOf(result), String.valueOf(acceptableResultCodes[0])));
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_MISSING.get(String.valueOf(result), Arrays.toString(acceptableResultCodes)));
    }

    public static void assertResultCodeEquals(LDAPException exception, ResultCode ... acceptableResultCodes) throws AssertionError {
        for (ResultCode rc : acceptableResultCodes) {
            if (!rc.equals(exception.getResultCode())) continue;
            return;
        }
        if (acceptableResultCodes.length == 1) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_MISSING.get(StaticUtils.getExceptionMessage(exception), String.valueOf(acceptableResultCodes[0])));
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_MISSING.get(StaticUtils.getExceptionMessage(exception), Arrays.toString(acceptableResultCodes)));
    }

    public static LDAPResult assertResultCodeEquals(LDAPConnection conn, LDAPRequest request, ResultCode ... acceptableResultCodes) throws AssertionError {
        LDAPResult result;
        try {
            result = conn.processOperation(request);
        }
        catch (LDAPException le) {
            result = le.toLDAPResult();
        }
        for (ResultCode rc : acceptableResultCodes) {
            if (!rc.equals(result.getResultCode())) continue;
            return result;
        }
        if (acceptableResultCodes.length == 1) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_MISSING.get(String.valueOf(result), String.valueOf(acceptableResultCodes[0])));
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_MISSING.get(String.valueOf(result), Arrays.toString(acceptableResultCodes)));
    }

    public static void assertResultCodeNot(LDAPResult result, ResultCode ... unacceptableResultCodes) throws AssertionError {
        for (ResultCode rc : unacceptableResultCodes) {
            if (!rc.equals(result.getResultCode())) continue;
            if (unacceptableResultCodes.length == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_FOUND.get(String.valueOf(result), String.valueOf(unacceptableResultCodes[0])));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_FOUND.get(String.valueOf(result), Arrays.toString(unacceptableResultCodes)));
        }
    }

    public static void assertResultCodeNot(LDAPException exception, ResultCode ... unacceptableResultCodes) throws AssertionError {
        for (ResultCode rc : unacceptableResultCodes) {
            if (!rc.equals(exception.getResultCode())) continue;
            if (unacceptableResultCodes.length == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_FOUND.get(StaticUtils.getExceptionMessage(exception), String.valueOf(unacceptableResultCodes[0])));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_FOUND.get(StaticUtils.getExceptionMessage(exception), Arrays.toString(unacceptableResultCodes)));
        }
    }

    public static LDAPResult assertResultCodeNot(LDAPConnection conn, LDAPRequest request, ResultCode ... unacceptableResultCodes) throws AssertionError {
        LDAPResult result;
        try {
            result = conn.processOperation(request);
        }
        catch (LDAPException le) {
            result = le.toLDAPResult();
        }
        for (ResultCode rc : unacceptableResultCodes) {
            if (!rc.equals(result.getResultCode())) continue;
            if (unacceptableResultCodes.length == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_FOUND.get(String.valueOf(result), String.valueOf(unacceptableResultCodes[0])));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_FOUND.get(String.valueOf(result), Arrays.toString(unacceptableResultCodes)));
        }
        return result;
    }

    public static void assertContainsMatchedDN(LDAPResult result) throws AssertionError {
        if (result.getMatchedDN() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_MATCHED_DN.get(String.valueOf(result)));
        }
    }

    public static void assertContainsMatchedDN(LDAPException exception) throws AssertionError {
        if (exception.getMatchedDN() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_MATCHED_DN.get(StaticUtils.getExceptionMessage(exception)));
        }
    }

    public static void assertMissingMatchedDN(LDAPResult result) throws AssertionError {
        if (result.getMatchedDN() != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_CONTAINS_MATCHED_DN.get(String.valueOf(result), result.getMatchedDN()));
        }
    }

    public static void assertMissingMatchedDN(LDAPException exception) throws AssertionError {
        if (exception.getMatchedDN() != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_CONTAINS_MATCHED_DN.get(StaticUtils.getExceptionMessage(exception), exception.getMatchedDN()));
        }
    }

    public static void assertMatchedDNEquals(LDAPResult result, String matchedDN) throws LDAPException, AssertionError {
        DN expectedDN;
        if (result.getMatchedDN() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_EXPECTED_MATCHED_DN.get(String.valueOf(result), matchedDN));
        }
        DN foundDN = new DN(result.getMatchedDN());
        if (!foundDN.equals(expectedDN = new DN(matchedDN))) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MATCHED_DN_MISMATCH.get(String.valueOf(result), matchedDN, result.getMatchedDN()));
        }
    }

    public static void assertMatchedDNEquals(LDAPException exception, String matchedDN) throws LDAPException, AssertionError {
        DN expectedDN;
        if (exception.getMatchedDN() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_EXPECTED_MATCHED_DN.get(StaticUtils.getExceptionMessage(exception), matchedDN));
        }
        DN foundDN = new DN(exception.getMatchedDN());
        if (!foundDN.equals(expectedDN = new DN(matchedDN))) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MATCHED_DN_MISMATCH.get(StaticUtils.getExceptionMessage(exception), matchedDN, exception.getMatchedDN()));
        }
    }

    public static void assertContainsDiagnosticMessage(LDAPResult result) throws AssertionError {
        if (result.getDiagnosticMessage() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_DIAGNOSTIC_MESSAGE.get(String.valueOf(result)));
        }
    }

    public static void assertContainsDiagnosticMessage(LDAPException exception) throws AssertionError {
        if (exception.getDiagnosticMessage() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_DIAGNOSTIC_MESSAGE.get(StaticUtils.getExceptionMessage(exception)));
        }
    }

    public static void assertMissingDiagnosticMessage(LDAPResult result) throws AssertionError {
        if (result.getDiagnosticMessage() != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_CONTAINS_DIAGNOSTIC_MESSAGE.get(String.valueOf(result), result.getDiagnosticMessage()));
        }
    }

    public static void assertMissingDiagnosticMessage(LDAPException exception) throws AssertionError {
        if (exception.getDiagnosticMessage() != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_CONTAINS_DIAGNOSTIC_MESSAGE.get(StaticUtils.getExceptionMessage(exception), exception.getDiagnosticMessage()));
        }
    }

    public static void assertDiagnosticMessageEquals(LDAPResult result, String diagnosticMessage) throws AssertionError {
        if (result.getDiagnosticMessage() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_EXPECTED_DIAGNOSTIC_MESSAGE.get(String.valueOf(result), diagnosticMessage));
        }
        if (!result.getDiagnosticMessage().equals(diagnosticMessage)) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_DIAGNOSTIC_MESSAGE_MISMATCH.get(String.valueOf(result), diagnosticMessage, result.getDiagnosticMessage()));
        }
    }

    public static void assertDiagnosticMessageEquals(LDAPException exception, String diagnosticMessage) throws AssertionError {
        if (exception.getDiagnosticMessage() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_EXPECTED_DIAGNOSTIC_MESSAGE.get(StaticUtils.getExceptionMessage(exception), diagnosticMessage));
        }
        if (!exception.getDiagnosticMessage().equals(diagnosticMessage)) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_DIAGNOSTIC_MESSAGE_MISMATCH.get(StaticUtils.getExceptionMessage(exception), diagnosticMessage, exception.getDiagnosticMessage()));
        }
    }

    public static void assertHasReferral(LDAPResult result) throws AssertionError {
        String[] referralURLs = result.getReferralURLs();
        if (referralURLs == null || referralURLs.length == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_REFERRAL.get(String.valueOf(result)));
        }
    }

    public static void assertHasReferral(LDAPException exception) throws AssertionError {
        String[] referralURLs = exception.getReferralURLs();
        if (referralURLs == null || referralURLs.length == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_REFERRAL.get(StaticUtils.getExceptionMessage(exception)));
        }
    }

    public static void assertMissingReferral(LDAPResult result) throws AssertionError {
        String[] referralURLs = result.getReferralURLs();
        if (referralURLs != null && referralURLs.length > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_HAS_REFERRAL.get(String.valueOf(result)));
        }
    }

    public static void assertMissingReferral(LDAPException exception) throws AssertionError {
        String[] referralURLs = exception.getReferralURLs();
        if (referralURLs != null && referralURLs.length > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_HAS_REFERRAL.get(StaticUtils.getExceptionMessage(exception)));
        }
    }

    public static Control assertHasControl(LDAPResult result, String oid) throws AssertionError {
        for (Control c : result.getResponseControls()) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_CONTROL.get(String.valueOf(result), oid));
    }

    public static Control assertHasControl(LDAPException exception, String oid) throws AssertionError {
        for (Control c : exception.getResponseControls()) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_CONTROL.get(StaticUtils.getExceptionMessage(exception), oid));
    }

    public static Control assertHasControl(SearchResultEntry entry, String oid) throws AssertionError {
        for (Control c : entry.getControls()) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING_CONTROL.get(String.valueOf(entry), oid));
    }

    public static Control assertHasControl(SearchResultReference reference, String oid) throws AssertionError {
        for (Control c : reference.getControls()) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_REF_MISSING_CONTROL.get(String.valueOf(reference), oid));
    }

    public static void assertMissingControl(LDAPResult result, String oid) throws AssertionError {
        for (Control c : result.getResponseControls()) {
            if (c.getOID().equals(oid)) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_HAS_CONTROL.get(String.valueOf(result), oid));
            }
        }
    }

    public static void assertMissingControl(LDAPException exception, String oid) throws AssertionError {
        for (Control c : exception.getResponseControls()) {
            if (c.getOID().equals(oid)) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_HAS_CONTROL.get(StaticUtils.getExceptionMessage(exception), oid));
            }
        }
    }

    public static void assertMissingControl(SearchResultEntry entry, String oid) throws AssertionError {
        for (Control c : entry.getControls()) {
            if (c.getOID().equals(oid)) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_HAS_CONTROL.get(String.valueOf(entry), oid));
            }
        }
    }

    public static void assertMissingControl(SearchResultReference reference, String oid) throws AssertionError {
        for (Control c : reference.getControls()) {
            if (c.getOID().equals(oid)) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_REF_HAS_CONTROL.get(String.valueOf(reference), oid));
            }
        }
    }

    public static int assertEntryReturned(SearchResult result) throws AssertionError {
        if (result.getEntryCount() == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_NO_ENTRIES_RETURNED.get(String.valueOf(result)));
        }
        return result.getEntryCount();
    }

    public static int assertEntryReturned(LDAPSearchException exception) throws AssertionError {
        if (exception.getEntryCount() == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_NO_ENTRIES_RETURNED.get(StaticUtils.getExceptionMessage(exception)));
        }
        return exception.getEntryCount();
    }

    public static SearchResultEntry assertEntryReturned(SearchResult result, String dn) throws LDAPException, AssertionError {
        DN parsedDN = new DN(dn);
        List<SearchResultEntry> entryList = result.getSearchEntries();
        if (entryList != null) {
            for (SearchResultEntry e : entryList) {
                if (!e.getParsedDN().equals(parsedDN)) continue;
                return e;
            }
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_NOT_RETURNED.get(String.valueOf(result), dn));
    }

    public static SearchResultEntry assertEntryReturned(LDAPSearchException exception, String dn) throws LDAPException, AssertionError {
        DN parsedDN = new DN(dn);
        List<SearchResultEntry> entryList = exception.getSearchEntries();
        if (entryList != null) {
            for (SearchResultEntry e : entryList) {
                if (!e.getParsedDN().equals(parsedDN)) continue;
                return e;
            }
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_NOT_RETURNED.get(StaticUtils.getExceptionMessage(exception), dn));
    }

    public static void assertNoEntriesReturned(SearchResult result) throws AssertionError {
        if (result.getEntryCount() > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRIES_RETURNED.get(String.valueOf(result), result.getEntryCount()));
        }
    }

    public static void assertNoEntriesReturned(LDAPSearchException exception) throws AssertionError {
        if (exception.getEntryCount() > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRIES_RETURNED.get(StaticUtils.getExceptionMessage(exception), exception.getEntryCount()));
        }
    }

    public static void assertEntriesReturnedEquals(SearchResult result, int expectedEntryCount) throws AssertionError {
        if (result.getEntryCount() != expectedEntryCount) {
            if (expectedEntryCount == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_ONE_EXPECTED.get(String.valueOf(result), result.getEntryCount()));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_MULTI_EXPECTED.get(expectedEntryCount, String.valueOf(result), result.getEntryCount()));
        }
    }

    public static void assertEntriesReturnedEquals(LDAPSearchException exception, int expectedEntryCount) throws AssertionError {
        if (exception.getEntryCount() != expectedEntryCount) {
            if (expectedEntryCount == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_ONE_EXPECTED.get(StaticUtils.getExceptionMessage(exception), exception.getEntryCount()));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_MULTI_EXPECTED.get(expectedEntryCount, StaticUtils.getExceptionMessage(exception), exception.getEntryCount()));
        }
    }

    public static int assertReferenceReturned(SearchResult result) throws AssertionError {
        if (result.getReferenceCount() == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_NO_REFS_RETURNED.get(String.valueOf(result)));
        }
        return result.getReferenceCount();
    }

    public static int assertReferenceReturned(LDAPSearchException exception) throws AssertionError {
        if (exception.getReferenceCount() == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_NO_REFS_RETURNED.get(StaticUtils.getExceptionMessage(exception)));
        }
        return exception.getReferenceCount();
    }

    public static void assertNoReferencesReturned(SearchResult result) throws AssertionError {
        if (result.getReferenceCount() > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REFS_RETURNED.get(String.valueOf(result), result.getReferenceCount()));
        }
    }

    public static void assertNoReferencesReturned(LDAPSearchException exception) throws AssertionError {
        if (exception.getReferenceCount() > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REFS_RETURNED.get(StaticUtils.getExceptionMessage(exception), exception.getReferenceCount()));
        }
    }

    public static void assertReferencesReturnedEquals(SearchResult result, int expectedReferenceCount) throws AssertionError {
        if (result.getReferenceCount() != expectedReferenceCount) {
            if (expectedReferenceCount == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REF_COUNT_MISMATCH_ONE_EXPECTED.get(String.valueOf(result), result.getReferenceCount()));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REF_COUNT_MISMATCH_MULTI_EXPECTED.get(expectedReferenceCount, String.valueOf(result), result.getReferenceCount()));
        }
    }

    public static void assertReferencesReturnedEquals(LDAPSearchException exception, int expectedReferenceCount) throws AssertionError {
        if (exception.getReferenceCount() != expectedReferenceCount) {
            if (expectedReferenceCount == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REF_COUNT_MISMATCH_ONE_EXPECTED.get(StaticUtils.getExceptionMessage(exception), exception.getReferenceCount()));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REF_COUNT_MISMATCH_MULTI_EXPECTED.get(expectedReferenceCount, StaticUtils.getExceptionMessage(exception), exception.getReferenceCount()));
        }
    }

    public static void assertDNsEqual(String s1, String s2) throws AssertionError {
        DN dn2;
        DN dn1;
        try {
            dn1 = new DN(s1);
        }
        catch (Exception e) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_VALUE_NOT_VALID_DN.get(s1, StaticUtils.getExceptionMessage(e)));
        }
        try {
            dn2 = new DN(s2);
        }
        catch (Exception e) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_VALUE_NOT_VALID_DN.get(s2, StaticUtils.getExceptionMessage(e)));
        }
        if (!dn1.equals(dn2)) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_DNS_NOT_EQUAL.get(s1, s2));
        }
    }
}

