/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.ReplicaShardAllocator;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.TransportSearchableSnapshotCacheStoresAction;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheInfoService;

public class SearchableSnapshotAllocator
implements ExistingShardsAllocator {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotAllocator.class);
    private static final ActionListener<ClusterState> REROUTE_LISTENER = new ActionListener<ClusterState>(){

        public void onResponse(ClusterState clusterRerouteResponse) {
            logger.trace("reroute succeeded after loading snapshot cache information");
        }

        public void onFailure(Exception e) {
            logger.warn("reroute failed", (Throwable)e);
        }
    };
    public static final String ALLOCATOR_NAME = "searchable_snapshot_allocator";
    private final ConcurrentMap<ShardId, AsyncCacheStatusFetch> asyncFetchStore = ConcurrentCollections.newConcurrentMap();
    private final Client client;
    private final RerouteService rerouteService;
    private final FrozenCacheInfoService frozenCacheInfoService;

    public SearchableSnapshotAllocator(Client client, RerouteService rerouteService, FrozenCacheInfoService frozenCacheInfoService) {
        this.client = client;
        this.rerouteService = rerouteService;
        this.frozenCacheInfoService = frozenCacheInfoService;
    }

    public void beforeAllocation(RoutingAllocation allocation) {
        boolean hasPartialIndices = false;
        for (IndexMetadata indexMetadata : allocation.metadata()) {
            Settings indexSettings = indexMetadata.getSettings();
            if (!SearchableSnapshotsSettings.isPartialSearchableSnapshotIndex((Settings)indexSettings)) continue;
            hasPartialIndices = true;
            break;
        }
        if (hasPartialIndices) {
            this.frozenCacheInfoService.updateNodes(this.client, StreamSupport.stream(allocation.routingNodes().spliterator(), false).map(RoutingNode::node).collect(Collectors.toSet()), this.rerouteService);
        } else {
            this.frozenCacheInfoService.updateNodes(this.client, Collections.emptySet(), this.rerouteService);
        }
    }

    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
    }

    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        AllocateUnassignedDecision allocateUnassignedDecision;
        String recoveryUuid;
        if (shardRouting.primary() && (recoveryUuid = SearchableSnapshotAllocator.getRecoverySourceRestoreUuid(shardRouting, allocation)) != null) {
            String repositoryName;
            Settings indexSettings = allocation.metadata().index(shardRouting.index()).getSettings();
            IndexId indexId = new IndexId((String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings), (String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings));
            SnapshotId snapshotId = new SnapshotId((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.get(indexSettings), (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings));
            String repositoryUuid = (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.get(indexSettings);
            if (!Strings.hasLength((String)repositoryUuid)) {
                repositoryName = (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.get(indexSettings);
            } else {
                RepositoriesMetadata repoMetadata = (RepositoriesMetadata)allocation.metadata().custom("repositories");
                List repositories = repoMetadata == null ? Collections.emptyList() : repoMetadata.repositories();
                repositoryName = repositories.stream().filter(r -> repositoryUuid.equals(r.uuid())).map(RepositoryMetadata::name).findFirst().orElse(null);
            }
            if (repositoryName == null) {
                unassignedAllocationHandler.removeAndIgnore(UnassignedInfo.AllocationStatus.DECIDERS_NO, allocation.changes());
                return;
            }
            Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
            Version version = shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT ? ((RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource()).version() : Version.CURRENT;
            RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(recoveryUuid, snapshot, version, indexId);
            if (!shardRouting.recoverySource().equals((Object)recoverySource)) {
                shardRouting = unassignedAllocationHandler.updateUnassigned(shardRouting.unassignedInfo(), (RecoverySource)recoverySource, allocation.changes());
            }
        }
        if ((allocateUnassignedDecision = this.decideAllocation(allocation, shardRouting)).isDecisionTaken()) {
            if (allocateUnassignedDecision.getAllocationDecision() == AllocationDecision.YES) {
                unassignedAllocationHandler.initialize(allocateUnassignedDecision.getTargetNode().getId(), allocateUnassignedDecision.getAllocationId(), DiskThresholdDecider.getExpectedShardSize((ShardRouting)shardRouting, (long)-1L, (ClusterInfo)allocation.clusterInfo(), (SnapshotShardSizeInfo)allocation.snapshotShardSizeInfo(), (Metadata)allocation.metadata(), (RoutingTable)allocation.routingTable()), allocation.changes());
            } else {
                unassignedAllocationHandler.removeAndIgnore(allocateUnassignedDecision.getAllocationStatus(), allocation.changes());
            }
        }
    }

    @Nullable
    private static String getRecoverySourceRestoreUuid(ShardRouting shardRouting, RoutingAllocation allocation) {
        switch (shardRouting.recoverySource().getType()) {
            case EXISTING_STORE: 
            case EMPTY_STORE: {
                return "_no_api_";
            }
            case SNAPSHOT: {
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource();
                if (recoverySource.restoreUUID().equals("_no_api_")) {
                    return "_no_api_";
                }
                RestoreInProgress restoreInProgress = (RestoreInProgress)allocation.custom("restore");
                if (restoreInProgress == null) {
                    return "_no_api_";
                }
                RestoreInProgress.Entry entry = restoreInProgress.get(recoverySource.restoreUUID());
                if (entry == null) {
                    return "_no_api_";
                }
                RestoreInProgress.ShardRestoreStatus shardRestoreStatus = (RestoreInProgress.ShardRestoreStatus)entry.shards().get((Object)shardRouting.shardId());
                if (shardRestoreStatus == null || shardRestoreStatus.state().completed()) {
                    return "_no_api_";
                }
                return recoverySource.restoreUUID();
            }
        }
        return null;
    }

    private AllocateUnassignedDecision decideAllocation(RoutingAllocation allocation, ShardRouting shardRouting) {
        assert (shardRouting.unassigned());
        assert (((String)ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.get(allocation.metadata().getIndexSafe(shardRouting.index()).getSettings())).equals(ALLOCATOR_NAME));
        if (shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && allocation.snapshotShardSizeInfo().getShardSize(shardRouting) == null) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null);
        }
        if (((Boolean)SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING.get(allocation.metadata().index(shardRouting.index()).getSettings())).booleanValue() && this.frozenCacheInfoService.isFetching()) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null);
        }
        boolean explain = allocation.debugDecision();
        Tuple result = ReplicaShardAllocator.canBeAllocatedToAtLeastOneNode((ShardRouting)shardRouting, (RoutingAllocation)allocation);
        Decision allocateDecision = (Decision)result.v1();
        if (!(allocateDecision.type() == Decision.Type.YES || explain && this.asyncFetchStore.get(shardRouting.shardId()) != null)) {
            logger.trace("{}: ignoring allocation, can't be allocated on any node", (Object)shardRouting);
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.fromDecision((Decision.Type)allocateDecision.type()), (List)(result.v2() != null ? new ArrayList(((Map)result.v2()).values()) : null));
        }
        AsyncShardFetch.FetchResult<TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> fetchedCacheData = this.fetchData(shardRouting, allocation);
        if (!fetchedCacheData.hasData()) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null);
        }
        MatchingNodes matchingNodes = this.findMatchingNodes(shardRouting, allocation, fetchedCacheData, explain);
        assert (!explain || matchingNodes.nodeDecisions != null) : "in explain mode, we must have individual node decisions";
        List<NodeAllocationResult> nodeDecisions = SearchableSnapshotAllocator.augmentExplanationsWithStoreInfo((Map)result.v2(), matchingNodes.nodeDecisions);
        if (allocateDecision.type() != Decision.Type.YES) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.fromDecision((Decision.Type)allocateDecision.type()), nodeDecisions);
        }
        if (matchingNodes.getNodeWithHighestMatch() != null) {
            RoutingNode nodeWithHighestMatch = allocation.routingNodes().node(matchingNodes.getNodeWithHighestMatch().getId());
            Decision decision = allocation.deciders().canAllocate(shardRouting, nodeWithHighestMatch, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent cache", (Object)shardRouting.index(), (Object)shardRouting.id(), (Object)shardRouting, (Object)nodeWithHighestMatch.node());
                return AllocateUnassignedDecision.throttle(nodeDecisions);
            }
            logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its persistent cache", (Object)shardRouting.index(), (Object)shardRouting.id(), (Object)shardRouting, (Object)nodeWithHighestMatch.node());
            return AllocateUnassignedDecision.yes((DiscoveryNode)nodeWithHighestMatch.node(), null, nodeDecisions, (boolean)true);
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting shardRouting, RoutingAllocation routingAllocation) {
        assert (shardRouting.unassigned());
        assert (routingAllocation.debugDecision());
        return this.decideAllocation(routingAllocation, shardRouting);
    }

    public void cleanCaches() {
        this.asyncFetchStore.clear();
        this.frozenCacheInfoService.clear();
    }

    public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        for (ShardRouting startedShard : startedShards) {
            this.asyncFetchStore.remove(startedShard.shardId());
        }
    }

    public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        for (FailedShard failedShard : failedShards) {
            this.asyncFetchStore.remove(failedShard.getRoutingEntry().shardId());
        }
    }

    public int getNumberOfInFlightFetches() {
        int count = 0;
        for (AsyncCacheStatusFetch fetch : this.asyncFetchStore.values()) {
            count += fetch.numberOfInFlightFetches();
        }
        return count;
    }

    private AsyncShardFetch.FetchResult<TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> fetchData(ShardRouting shard, RoutingAllocation allocation) {
        DiscoveryNodes nodes;
        ShardId shardId = shard.shardId();
        Settings indexSettings = allocation.metadata().index(shard.index()).getSettings();
        if (((Boolean)SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING.get(indexSettings)).booleanValue()) {
            return new AsyncShardFetch.FetchResult(shardId, Collections.emptyMap(), Collections.emptySet());
        }
        SnapshotId snapshotId = new SnapshotId((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.get(indexSettings), (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings));
        final AsyncCacheStatusFetch asyncFetch = this.asyncFetchStore.computeIfAbsent(shardId, sid -> new AsyncCacheStatusFetch());
        final DiscoveryNode[] dataNodes = asyncFetch.addFetches((DiscoveryNode[])(nodes = allocation.nodes()).getDataNodes().values().toArray(DiscoveryNode[]::new));
        if (dataNodes.length > 0) {
            this.client.execute(TransportSearchableSnapshotCacheStoresAction.TYPE, (ActionRequest)new TransportSearchableSnapshotCacheStoresAction.Request(snapshotId, shardId, dataNodes), ActionListener.runAfter((ActionListener)new ActionListener<TransportSearchableSnapshotCacheStoresAction.NodesCacheFilesMetadata>(){

                public void onResponse(TransportSearchableSnapshotCacheStoresAction.NodesCacheFilesMetadata nodesCacheFilesMetadata) {
                    HashMap<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> res = new HashMap<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata>(nodesCacheFilesMetadata.getNodesMap().size());
                    for (Map.Entry entry : nodesCacheFilesMetadata.getNodesMap().entrySet()) {
                        res.put(nodes.get((String)entry.getKey()), (TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata)((Object)entry.getValue()));
                    }
                    for (FailedNodeException failedNodeException : nodesCacheFilesMetadata.failures()) {
                        DiscoveryNode dataNode = nodes.get(failedNodeException.nodeId());
                        logger.warn("Failed fetching cache size from datanode", (Throwable)failedNodeException);
                        res.put(dataNode, new TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata(dataNode, 0L));
                    }
                    asyncFetch.addData(res);
                }

                public void onFailure(Exception e) {
                    logger.warn("Failure when trying to fetch existing cache sizes", (Throwable)e);
                    HashMap<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> res = new HashMap<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata>(dataNodes.length);
                    for (DiscoveryNode dataNode : dataNodes) {
                        res.put(dataNode, new TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata(dataNode, 0L));
                    }
                    asyncFetch.addData(res);
                }
            }, () -> {
                if (asyncFetch.data() != null) {
                    this.rerouteService.reroute("async_shard_cache_fetch", Priority.HIGH, REROUTE_LISTENER);
                }
            }));
        }
        return new AsyncShardFetch.FetchResult(shardId, asyncFetch.data(), Collections.emptySet());
    }

    private static List<NodeAllocationResult> augmentExplanationsWithStoreInfo(Map<String, NodeAllocationResult> nodeDecisions, Map<String, NodeAllocationResult> withShardStores) {
        if (nodeDecisions == null || withShardStores == null) {
            return null;
        }
        ArrayList<NodeAllocationResult> augmented = new ArrayList<NodeAllocationResult>();
        for (Map.Entry<String, NodeAllocationResult> entry : nodeDecisions.entrySet()) {
            if (withShardStores.containsKey(entry.getKey())) {
                augmented.add(withShardStores.get(entry.getKey()));
                continue;
            }
            augmented.add(entry.getValue());
        }
        return augmented;
    }

    private MatchingNodes findMatchingNodes(ShardRouting shard, RoutingAllocation allocation, AsyncShardFetch.FetchResult<TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> data, boolean explain) {
        HashMap<DiscoveryNode, Long> matchingNodesCacheSizes = new HashMap<DiscoveryNode, Long>();
        HashMap<String, NodeAllocationResult> nodeDecisionsDebug = explain ? new HashMap<String, NodeAllocationResult>() : null;
        for (Map.Entry nodeStoreEntry : data.getData().entrySet()) {
            RoutingNode node;
            DiscoveryNode discoNode = (DiscoveryNode)nodeStoreEntry.getKey();
            TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata nodeCacheFilesMetadata = (TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata)((Object)nodeStoreEntry.getValue());
            if (nodeCacheFilesMetadata.bytesCached() == 0L || (node = allocation.routingNodes().node(discoNode.getId())) == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            Long matchingBytes = null;
            if (explain) {
                matchingBytes = nodeCacheFilesMetadata.bytesCached();
                NodeAllocationResult.ShardStoreInfo shardStoreInfo = new NodeAllocationResult.ShardStoreInfo(matchingBytes.longValue());
                nodeDecisionsDebug.put(node.nodeId(), new NodeAllocationResult(discoNode, shardStoreInfo, decision));
            }
            if (decision.type() == Decision.Type.NO) continue;
            if (matchingBytes == null) {
                matchingBytes = nodeCacheFilesMetadata.bytesCached();
            }
            matchingNodesCacheSizes.put(discoNode, matchingBytes);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable cache data", (Object)shard, (Object)discoNode.getName(), (Object)new ByteSizeValue(matchingBytes.longValue()), (Object)matchingBytes);
        }
        return new MatchingNodes(matchingNodesCacheSizes, nodeDecisionsDebug);
    }

    private static final class MatchingNodes {
        private final DiscoveryNode nodeWithHighestMatch;
        @Nullable
        private final Map<String, NodeAllocationResult> nodeDecisions;

        MatchingNodes(Map<DiscoveryNode, Long> matchingNodes, @Nullable Map<String, NodeAllocationResult> nodeDecisions) {
            this.nodeDecisions = nodeDecisions;
            this.nodeWithHighestMatch = matchingNodes.entrySet().stream().filter(entry -> (Long)entry.getValue() > 0L).max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        }

        @Nullable
        public DiscoveryNode getNodeWithHighestMatch() {
            return this.nodeWithHighestMatch;
        }
    }

    private static final class AsyncCacheStatusFetch {
        private final Set<DiscoveryNode> fetchingDataNodes = new HashSet<DiscoveryNode>();
        private final Map<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> data = new HashMap<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata>();

        AsyncCacheStatusFetch() {
        }

        synchronized DiscoveryNode[] addFetches(DiscoveryNode[] nodes) {
            ArrayList<DiscoveryNode> nodesToFetch = new ArrayList<DiscoveryNode>();
            for (DiscoveryNode node : nodes) {
                if (this.data.containsKey(node) || !this.fetchingDataNodes.add(node)) continue;
                nodesToFetch.add(node);
            }
            return nodesToFetch.toArray(new DiscoveryNode[0]);
        }

        synchronized void addData(Map<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> newData) {
            this.data.putAll(newData);
            this.fetchingDataNodes.removeAll(newData.keySet());
        }

        @Nullable
        synchronized Map<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> data() {
            return this.fetchingDataNodes.size() > 0 ? null : Map.copyOf(this.data);
        }

        synchronized int numberOfInFlightFetches() {
            return this.fetchingDataNodes.size();
        }
    }
}

