/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class RemoveProcessor
extends AbstractProcessor {
    public static final String TYPE = "remove";
    private final List<TemplateScript.Factory> fields;
    private final boolean ignoreMissing;

    RemoveProcessor(String tag, String description, List<TemplateScript.Factory> fields, boolean ignoreMissing) {
        super(tag, description);
        this.fields = new ArrayList<TemplateScript.Factory>(fields);
        this.ignoreMissing = ignoreMissing;
    }

    public List<TemplateScript.Factory> getFields() {
        return this.fields;
    }

    public IngestDocument execute(IngestDocument document) {
        if (this.ignoreMissing) {
            this.fields.forEach(field -> {
                String path = document.renderTemplate(field);
                if (document.hasField(path)) {
                    document.removeField(path);
                }
            });
        } else {
            this.fields.forEach(arg_0 -> ((IngestDocument)document).removeField(arg_0));
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public RemoveProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            ArrayList<String> fields = new ArrayList<String>();
            Object field = ConfigurationUtils.readObject((String)RemoveProcessor.TYPE, (String)processorTag, config, (String)"field");
            if (field instanceof List) {
                List stringList = (List)field;
                fields.addAll(stringList);
            } else {
                fields.add((String)field);
            }
            List<TemplateScript.Factory> compiledTemplates = fields.stream().map(f -> ConfigurationUtils.compileTemplate((String)RemoveProcessor.TYPE, (String)processorTag, (String)"field", (String)f, (ScriptService)this.scriptService)).collect(Collectors.toList());
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RemoveProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new RemoveProcessor(processorTag, description, compiledTemplates, ignoreMissing);
        }
    }
}

