/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.persistence;

import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;

public final class TransformIndex {
    private static final Logger logger = LogManager.getLogger(TransformIndex.class);
    private static final String PROPERTIES = "properties";
    private static final String META = "_meta";

    private TransformIndex() {
    }

    public static void createDestinationIndex(Client client, TransformConfig transformConfig, TransformDestIndexSettings destIndexSettings, ActionListener<Boolean> listener) {
        CreateIndexRequest request = new CreateIndexRequest(transformConfig.getDestination().getIndex());
        request.settings(destIndexSettings.getSettings());
        request.mapping(destIndexSettings.getMappings());
        for (Alias alias : destIndexSettings.getAliases()) {
            request.alias(alias);
        }
        client.execute((ActionType)CreateIndexAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(createIndexResponse -> listener.onResponse((Object)true), e -> {
            String message = TransformMessages.getMessage((String)"Could not create destination index [{0}] for transform [{1}]", (Object[])new Object[]{transformConfig.getDestination().getIndex(), transformConfig.getId()});
            logger.error(message);
            listener.onFailure((Exception)new RuntimeException(message, (Throwable)e));
        }));
    }

    public static TransformDestIndexSettings createTransformDestIndexSettings(Map<String, String> mappings, String id, Clock clock) {
        HashMap<String, Map<String, Object>> indexMappings = new HashMap<String, Map<String, Object>>();
        indexMappings.put(PROPERTIES, TransformIndex.createMappingsFromStringMap(mappings));
        indexMappings.put(META, TransformIndex.createMetadata(id, clock));
        Settings settings = TransformIndex.createSettings();
        Set aliases = null;
        return new TransformDestIndexSettings(indexMappings, settings, aliases);
    }

    private static Map<String, Object> createMetadata(String id, Clock clock) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("created_by", "transform");
        HashMap<String, Object> transformMetadata = new HashMap<String, Object>();
        transformMetadata.put("creation_date_in_millis", clock.millis());
        transformMetadata.put(TransformField.VERSION.getPreferredName(), Map.of("created", Version.CURRENT.toString()));
        transformMetadata.put("transform", id);
        metadata.put("_transform", transformMetadata);
        return metadata;
    }

    private static Settings createSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").build();
    }

    static Map<String, Object> createMappingsFromStringMap(Map<String, String> mappings) {
        return mappings.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> Collections.singletonMap("type", (String)e.getValue())));
    }
}

