/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.TransformDeprecations;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskParams;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;
import org.elasticsearch.xpack.transform.transforms.ClientTransformIndexerBuilder;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransformPersistentTasksExecutor
extends PersistentTasksExecutor<TransformTaskParams> {
    private static final Logger logger = LogManager.getLogger(TransformPersistentTasksExecutor.class);
    private static final int MARK_AS_FAILED_TIMEOUT_SEC = 90;
    private final Client client;
    private final TransformServices transformServices;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private final TransformAuditor auditor;
    private volatile int numFailureRetries;

    public TransformPersistentTasksExecutor(Client client, TransformServices transformServices, ThreadPool threadPool, ClusterService clusterService, Settings settings, IndexNameExpressionResolver resolver) {
        super("data_frame/transforms", "transform_indexing");
        this.client = client;
        this.transformServices = transformServices;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.auditor = transformServices.getAuditor();
        this.numFailureRetries = (Integer)Transform.NUM_FAILURE_RETRIES_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(Transform.NUM_FAILURE_RETRIES_SETTING, this::setNumFailureRetries);
    }

    public PersistentTasksCustomMetadata.Assignment getAssignment(TransformTaskParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        if (TransformMetadata.getTransformMetadata((ClusterState)clusterState).isResetMode()) {
            return new PersistentTasksCustomMetadata.Assignment(null, "Transform task will not be assigned as a feature reset is in progress.");
        }
        List<String> unavailableIndices = TransformPersistentTasksExecutor.verifyIndicesPrimaryShardsAreActive(clusterState, this.resolver);
        if (unavailableIndices.size() != 0) {
            String reason = "Not starting transform [" + params.getId() + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
            logger.debug(reason);
            return new PersistentTasksCustomMetadata.Assignment(null, reason);
        }
        DiscoveryNode discoveryNode = this.selectLeastLoadedNode(clusterState, candidateNodes, node -> TransformNodes.nodeCanRunThisTransform(node, params.getVersion(), params.requiresRemote(), null));
        if (discoveryNode == null) {
            TreeMap<String, String> explainWhyAssignmentFailed = new TreeMap<String, String>();
            for (DiscoveryNode node2 : clusterState.getNodes()) {
                TransformNodes.nodeCanRunThisTransform(node2, params.getVersion(), params.requiresRemote(), explainWhyAssignmentFailed);
            }
            String reason = "Not starting transform [" + params.getId() + "], reasons [" + explainWhyAssignmentFailed.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining("|")) + "]";
            logger.debug(reason);
            return new PersistentTasksCustomMetadata.Assignment(null, reason);
        }
        return new PersistentTasksCustomMetadata.Assignment(discoveryNode.getId(), "");
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(ClusterState clusterState, IndexNameExpressionResolver resolver) {
        String[] indices = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{".transform-internal-*", ".data-frame-internal-*"});
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable = clusterState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    protected void nodeOperation(AllocatedPersistentTask task, @Nullable TransformTaskParams params, PersistentTaskState state) {
        String transformId = params.getId();
        TransformTask buildTask = (TransformTask)task;
        ClientTransformIndexerBuilder indexerBuilder = new ClientTransformIndexerBuilder().setClient(buildTask.getParentTaskClient()).setTransformServices(this.transformServices);
        SetOnce stateHolder = new SetOnce();
        ActionListener startTaskListener = ActionListener.wrap(response -> logger.info("[{}] successfully completed and scheduled task in node operation", (Object)transformId), failure -> {
            this.auditor.error(transformId, "Failed to start transform. Please stop and attempt to start again. Failure: " + failure.getMessage());
            logger.error("Failed to start task [" + transformId + "] in node operation", (Throwable)failure);
        });
        ActionListener getTransformNextCheckpointListener = ActionListener.wrap(nextCheckpoint -> {
            if (nextCheckpoint.isEmpty()) {
                indexerBuilder.setInitialPosition(null);
                indexerBuilder.setProgress(null);
            } else {
                logger.trace("[{}] Loaded next checkpoint [{}] found, starting the task", (Object)transformId, (Object)nextCheckpoint.getCheckpoint());
                indexerBuilder.setNextCheckpoint((TransformCheckpoint)nextCheckpoint);
            }
            long lastCheckpoint = ((TransformState)stateHolder.get()).getCheckpoint();
            this.startTask(buildTask, indexerBuilder, lastCheckpoint, (ActionListener<StartTransformAction.Response>)startTaskListener);
        }, error -> {
            String msg = TransformMessages.getMessage((String)"Failed to load transform checkpoint for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            this.markAsFailed(buildTask, msg);
        });
        ActionListener getTransformLastCheckpointListener = ActionListener.wrap(lastCheckpoint -> {
            indexerBuilder.setLastCheckpoint((TransformCheckpoint)lastCheckpoint);
            logger.trace("[{}] Loaded last checkpoint [{}], looking for next checkpoint", (Object)transformId, (Object)lastCheckpoint.getCheckpoint());
            this.transformServices.getConfigManager().getTransformCheckpoint(transformId, lastCheckpoint.getCheckpoint() + 1L, (ActionListener<TransformCheckpoint>)getTransformNextCheckpointListener);
        }, error -> {
            String msg = TransformMessages.getMessage((String)"Failed to load transform checkpoint for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            this.markAsFailed(buildTask, msg);
        });
        ActionListener transformStatsActionListener = ActionListener.wrap(stateAndStatsAndSeqNoPrimaryTermAndIndex -> {
            TransformStoredDoc stateAndStats = (TransformStoredDoc)stateAndStatsAndSeqNoPrimaryTermAndIndex.v1();
            SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex = (SeqNoPrimaryTermAndIndex)stateAndStatsAndSeqNoPrimaryTermAndIndex.v2();
            logger.trace("[{}] initializing state and stats: [{}]", (Object)transformId, (Object)stateAndStats.toString());
            TransformState transformState = stateAndStats.getTransformState();
            indexerBuilder.setInitialStats(stateAndStats.getTransformStats()).setInitialPosition(stateAndStats.getTransformState().getPosition()).setProgress(stateAndStats.getTransformState().getProgress()).setIndexerState(TransformPersistentTasksExecutor.currentIndexerState(transformState)).setSeqNoPrimaryTermAndIndex(seqNoPrimaryTermAndIndex).setShouldStopAtCheckpoint(transformState.shouldStopAtNextCheckpoint());
            logger.debug("[{}] Loading existing state: [{}], position [{}]", (Object)transformId, (Object)stateAndStats.getTransformState(), (Object)stateAndStats.getTransformState().getPosition());
            stateHolder.set((Object)transformState);
            long lastCheckpoint = ((TransformState)stateHolder.get()).getCheckpoint();
            if (lastCheckpoint == 0L) {
                logger.trace("[{}] No last checkpoint found, looking for next checkpoint", (Object)transformId);
                this.transformServices.getConfigManager().getTransformCheckpoint(transformId, lastCheckpoint + 1L, (ActionListener<TransformCheckpoint>)getTransformNextCheckpointListener);
            } else {
                logger.trace("[{}] Restore last checkpoint: [{}]", (Object)transformId, (Object)lastCheckpoint);
                this.transformServices.getConfigManager().getTransformCheckpoint(transformId, lastCheckpoint, (ActionListener<TransformCheckpoint>)getTransformLastCheckpointListener);
            }
        }, error -> {
            if (!(error instanceof ResourceNotFoundException)) {
                String msg = TransformMessages.getMessage((String)"Failed to load transform state for transform [{0}]", (Object[])new Object[]{transformId});
                logger.error(msg, (Throwable)error);
                this.markAsFailed(buildTask, msg);
            } else {
                logger.trace("[{}] No stats found (new transform), starting the task", (Object)transformId);
                this.startTask(buildTask, indexerBuilder, null, (ActionListener<StartTransformAction.Response>)startTaskListener);
            }
        });
        ActionListener getTransformConfigListener = ActionListener.wrap(config -> {
            if (config.getVersion() == null || config.getVersion().before(TransformDeprecations.MIN_TRANSFORM_VERSION)) {
                String transformTooOldError = new ParameterizedMessage("Transform configuration is too old [{}], use the upgrade API to fix your transform. Minimum required version is [{}]", (Object)config.getVersion(), (Object)TransformDeprecations.MIN_TRANSFORM_VERSION).getFormattedMessage();
                this.auditor.error(transformId, transformTooOldError);
                this.markAsFailed(buildTask, transformTooOldError);
                return;
            }
            ActionRequestValidationException validationException = config.validate(null);
            if (validationException == null) {
                indexerBuilder.setTransformConfig((TransformConfig)config);
                this.transformServices.getConfigManager().getTransformStoredDoc(transformId, false, (ActionListener<Tuple<TransformStoredDoc, SeqNoPrimaryTermAndIndex>>)transformStatsActionListener);
            } else {
                this.auditor.error(transformId, validationException.getMessage());
                this.markAsFailed(buildTask, TransformMessages.getMessage((String)"Transform configuration [{0}] has invalid elements: [{1}]", (Object[])new Object[]{transformId, validationException.getMessage()}));
            }
        }, error -> {
            String msg = TransformMessages.getMessage((String)"Failed to load transform configuration for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            this.markAsFailed(buildTask, msg);
        });
        ActionListener templateCheckListener = ActionListener.wrap(aVoid -> this.transformServices.getConfigManager().getTransformConfiguration(transformId, (ActionListener<TransformConfig>)getTransformConfigListener), error -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)error);
            String msg = "Failed to create internal index mappings";
            logger.error(msg, cause);
            this.markAsFailed(buildTask, msg + "[" + cause + "]");
        });
        TransformInternalIndex.createLatestVersionedIndexIfRequired(this.clusterService, (Client)buildTask.getParentTaskClient(), (ActionListener<Void>)templateCheckListener);
    }

    private static IndexerState currentIndexerState(TransformState previousState) {
        if (previousState == null) {
            return IndexerState.STOPPED;
        }
        switch (previousState.getIndexerState()) {
            case STARTED: 
            case INDEXING: {
                return IndexerState.STARTED;
            }
        }
        return IndexerState.STOPPED;
    }

    private void markAsFailed(TransformTask task, String reason) {
        CountDownLatch latch = new CountDownLatch(1);
        task.fail(reason, (ActionListener<Void>)new LatchedActionListener(ActionListener.wrap(nil -> {}, failure -> logger.error("Failed to set task [" + task.getTransformId() + "] to failed", (Throwable)failure)), latch));
        try {
            latch.await(90L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Timeout waiting for task [" + task.getTransformId() + "] to be marked as failed in cluster state", (Throwable)e);
        }
    }

    private void startTask(TransformTask buildTask, ClientTransformIndexerBuilder indexerBuilder, Long previousCheckpoint, ActionListener<StartTransformAction.Response> listener) {
        buildTask.initializeIndexer(indexerBuilder);
        buildTask.setNumFailureRetries(this.numFailureRetries).start(previousCheckpoint, listener);
    }

    private void setNumFailureRetries(int numFailureRetries) {
        this.numFailureRetries = numFailureRetries;
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<TransformTaskParams> persistentTask, Map<String, String> headers) {
        return new TransformTask(id, type, action, parentTaskId, this.client, (TransformTaskParams)persistentTask.getParams(), (TransformState)persistentTask.getState(), this.transformServices.getSchedulerEngine(), this.auditor, this.threadPool, headers);
    }
}

