/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.tools.launchers.SystemMemoryInfo;

public final class OverridableSystemMemoryInfo
implements SystemMemoryInfo {
    private final List<String> userDefinedJvmOptions;
    private final SystemMemoryInfo fallbackSystemMemoryInfo;

    public OverridableSystemMemoryInfo(List<String> userDefinedJvmOptions, SystemMemoryInfo fallbackSystemMemoryInfo) {
        this.userDefinedJvmOptions = Objects.requireNonNull(userDefinedJvmOptions);
        this.fallbackSystemMemoryInfo = Objects.requireNonNull(fallbackSystemMemoryInfo);
    }

    @Override
    public long availableSystemMemory() throws SystemMemoryInfo.SystemMemoryInfoException {
        return this.userDefinedJvmOptions.stream().filter(option -> option.startsWith("-Des.total_memory_bytes=")).map(totalMemoryBytesOption -> {
            try {
                long bytes = Long.parseLong(totalMemoryBytesOption.split("=", 2)[1]);
                if (bytes < 0L) {
                    throw new IllegalArgumentException("Negative memory size specified in [" + totalMemoryBytesOption + "]");
                }
                return bytes;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse number of bytes from [" + totalMemoryBytesOption + "]", e);
            }
        }).reduce((previous, current) -> current).orElse(this.fallbackSystemMemoryInfo.availableSystemMemory());
    }
}

