/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SamlValidateAuthnRequestResponse
extends ActionResponse {
    private final String spEntityId;
    private final String assertionConsumerService;
    private final boolean forceAuthn;
    private final Map<String, Object> authnState;

    public SamlValidateAuthnRequestResponse(StreamInput in) throws IOException {
        super(in);
        this.spEntityId = in.readString();
        this.assertionConsumerService = in.readString();
        this.forceAuthn = in.readBoolean();
        this.authnState = in.readMap();
    }

    public SamlValidateAuthnRequestResponse(String spEntityId, String acs, boolean forceAuthn, Map<String, Object> authnState) {
        this.spEntityId = Objects.requireNonNull(spEntityId, "spEntityId is required for successful responses");
        this.assertionConsumerService = Objects.requireNonNull(acs, "ACS is required for successful responses");
        this.forceAuthn = forceAuthn;
        this.authnState = Map.copyOf(Objects.requireNonNull(authnState));
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public String getAssertionConsumerService() {
        return this.assertionConsumerService;
    }

    public boolean isForceAuthn() {
        return this.forceAuthn;
    }

    public Map<String, Object> getAuthnState() {
        return this.authnState;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.spEntityId);
        out.writeString(this.assertionConsumerService);
        out.writeBoolean(this.forceAuthn);
        out.writeMap(this.authnState);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{ spEntityId='" + this.getSpEntityId() + "',\n acs='" + this.getAssertionConsumerService() + "',\n forceAuthn='" + this.isForceAuthn() + "',\n authnState='" + this.getAuthnState() + "' }";
    }
}

