/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.idp.privileges.ServiceProviderPrivileges;
import org.elasticsearch.xpack.idp.saml.sp.CloudServiceProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderDocument;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderDefaults;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderException;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;

public final class SamlServiceProviderFactory {
    private final ServiceProviderDefaults defaults;

    public SamlServiceProviderFactory(ServiceProviderDefaults defaults) {
        this.defaults = defaults;
    }

    SamlServiceProvider buildServiceProvider(SamlServiceProviderDocument document) {
        ServiceProviderPrivileges privileges = this.buildPrivileges(document.privileges);
        SamlServiceProvider.AttributeNames attributes = new SamlServiceProvider.AttributeNames(document.attributeNames.principal, document.attributeNames.name, document.attributeNames.email, document.attributeNames.roles);
        Set<X509Credential> credentials = document.certificates.getServiceProviderX509SigningCertificates().stream().map(BasicX509Credential::new).collect(Collectors.toUnmodifiableSet());
        URL acs = this.parseUrl(document);
        String nameIdFormat = document.nameIdFormat;
        if (nameIdFormat == null) {
            nameIdFormat = this.defaults.nameIdFormat;
        }
        Duration authnExpiry = Optional.ofNullable(document.getAuthenticationExpiry()).orElse(this.defaults.authenticationExpiry);
        boolean signAuthnRequests = document.signMessages.contains("authn");
        boolean signLogoutRequests = document.signMessages.contains("logout");
        return new CloudServiceProvider(document.entityId, document.name, document.enabled, acs, nameIdFormat, authnExpiry, privileges, attributes, credentials, signAuthnRequests, signLogoutRequests);
    }

    private ServiceProviderPrivileges buildPrivileges(SamlServiceProviderDocument.Privileges configuredPrivileges) {
        Function<String, Set<String>> roleMapping;
        String resource = configuredPrivileges.resource;
        if (configuredPrivileges.rolePatterns == null || configuredPrivileges.rolePatterns.isEmpty()) {
            roleMapping = in -> Set.of();
        } else {
            Set patterns = configuredPrivileges.rolePatterns.stream().map(Pattern::compile).collect(Collectors.toUnmodifiableSet());
            roleMapping = action -> patterns.stream().map(p -> p.matcher((CharSequence)action)).filter(Matcher::matches).map(m -> m.group(1)).collect(Collectors.toUnmodifiableSet());
        }
        return new ServiceProviderPrivileges(this.defaults.applicationName, resource, roleMapping);
    }

    private URL parseUrl(SamlServiceProviderDocument document) {
        URL acs;
        try {
            acs = new URL(document.acs);
        }
        catch (MalformedURLException e) {
            ServiceProviderException exception = new ServiceProviderException("Service provider [{}] (doc {}) has an invalid ACS [{}]", e, document.entityId, document.docId, document.acs);
            exception.setEntityId(document.entityId);
            throw exception;
        }
        return acs;
    }
}

