/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.license.DeleteLicenseAction;
import org.elasticsearch.license.GetBasicStatusAction;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetTrialStatusAction;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.license.PostStartBasicAction;
import org.elasticsearch.license.PostStartTrialAction;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.RestDeleteLicenseAction;
import org.elasticsearch.license.RestGetBasicStatus;
import org.elasticsearch.license.RestGetFeatureUsageAction;
import org.elasticsearch.license.RestGetLicenseAction;
import org.elasticsearch.license.RestGetTrialStatus;
import org.elasticsearch.license.RestPostStartBasicLicense;
import org.elasticsearch.license.RestPostStartTrialLicense;
import org.elasticsearch.license.RestPutLicenseAction;
import org.elasticsearch.license.TransportDeleteLicenseAction;
import org.elasticsearch.license.TransportGetBasicStatusAction;
import org.elasticsearch.license.TransportGetFeatureUsageAction;
import org.elasticsearch.license.TransportGetLicenseAction;
import org.elasticsearch.license.TransportGetTrialStatusAction;
import org.elasticsearch.license.TransportPostStartBasicAction;
import org.elasticsearch.license.TransportPostStartTrialAction;
import org.elasticsearch.license.TransportPutLicenseAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;

public class Licensing
implements ActionPlugin {
    public static final String NAME = "license";
    protected final Settings settings;

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "licenses", LicensesMetadata::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "licenses", LicensesMetadata::readDiffFrom));
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("licenses", new String[0]), LicensesMetadata::fromXContent));
        return entries;
    }

    public Licensing(Settings settings) {
        this.settings = settings;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutLicenseAction.INSTANCE, TransportPutLicenseAction.class), new ActionPlugin.ActionHandler((ActionType)GetLicenseAction.INSTANCE, TransportGetLicenseAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteLicenseAction.INSTANCE, TransportDeleteLicenseAction.class), new ActionPlugin.ActionHandler((ActionType)PostStartTrialAction.INSTANCE, TransportPostStartTrialAction.class), new ActionPlugin.ActionHandler((ActionType)GetTrialStatusAction.INSTANCE, TransportGetTrialStatusAction.class), new ActionPlugin.ActionHandler((ActionType)PostStartBasicAction.INSTANCE, TransportPostStartBasicAction.class), new ActionPlugin.ActionHandler((ActionType)GetBasicStatusAction.INSTANCE, TransportGetBasicStatusAction.class), new ActionPlugin.ActionHandler(TransportGetFeatureUsageAction.TYPE, TransportGetFeatureUsageAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new RestGetLicenseAction());
        handlers.add((RestHandler)new RestPutLicenseAction());
        handlers.add((RestHandler)new RestDeleteLicenseAction());
        handlers.add((RestHandler)new RestGetTrialStatus());
        handlers.add((RestHandler)new RestGetBasicStatus());
        handlers.add((RestHandler)new RestPostStartTrialLicense());
        handlers.add((RestHandler)new RestPostStartBasicLicense());
        handlers.add((RestHandler)new RestGetFeatureUsageAction());
        return handlers;
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(Setting.groupSetting((String)"license.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    }
}

