/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.PassThroughConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class PassThroughConfigUpdate
extends NlpConfigUpdate
implements NamedXContentObject {
    public static final String NAME = "pass_through";
    private static final ObjectParser<Builder, Void> STRICT_PARSER = PassThroughConfigUpdate.createParser(false);
    private final String resultsField;

    public static PassThroughConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        String resultsField = (String)options.remove(NlpConfig.RESULTS_FIELD.getPreferredName());
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", options.keySet());
        }
        return new PassThroughConfigUpdate(resultsField);
    }

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME, lenient, Builder::new);
        parser.declareString(Builder::setResultsField, NlpConfig.RESULTS_FIELD);
        return parser;
    }

    public static PassThroughConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public PassThroughConfigUpdate(String resultsField) {
        this.resultsField = resultsField;
    }

    public PassThroughConfigUpdate(StreamInput in) throws IOException {
        this.resultsField = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.resultsField);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.resultsField != null) {
            builder.field(NlpConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public InferenceConfig apply(InferenceConfig originalConfig) {
        if (this.resultsField == null || this.resultsField.equals(originalConfig.getResultsField())) {
            return originalConfig;
        }
        if (!(originalConfig instanceof PassThroughConfig)) {
            throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a inference request of type [{}]", originalConfig.getName(), this.getName());
        }
        PassThroughConfig passThroughConfig = (PassThroughConfig)originalConfig;
        return new PassThroughConfig(passThroughConfig.getVocabularyConfig(), passThroughConfig.getTokenization(), this.resultsField);
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return config instanceof PassThroughConfig;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setResultsField(this.resultsField);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PassThroughConfigUpdate that = (PassThroughConfigUpdate)o;
        return Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.resultsField);
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, PassThroughConfigUpdate> {
        private String resultsField;

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        @Override
        public PassThroughConfigUpdate build() {
            return new PassThroughConfigUpdate(this.resultsField);
        }
    }
}

