/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public final class CreateApiKeyRequestBuilder
extends ActionRequestBuilder<CreateApiKeyRequest, CreateApiKeyResponse> {
    static final ConstructingObjectParser<CreateApiKeyRequest, Void> PARSER = new ConstructingObjectParser("api_key_request", false, (args, v) -> new CreateApiKeyRequest((String)args[0], (List)args[1], TimeValue.parseTimeValue((String)((String)args[2]), null, (String)"expiration"), (Map)args[3]));

    public CreateApiKeyRequestBuilder(ElasticsearchClient client) {
        super(client, (ActionType)CreateApiKeyAction.INSTANCE, (ActionRequest)new CreateApiKeyRequest());
    }

    public CreateApiKeyRequestBuilder setName(String name) {
        ((CreateApiKeyRequest)this.request).setName(name);
        return this;
    }

    public CreateApiKeyRequestBuilder setExpiration(TimeValue expiration) {
        ((CreateApiKeyRequest)this.request).setExpiration(expiration);
        return this;
    }

    public CreateApiKeyRequestBuilder setRoleDescriptors(List<RoleDescriptor> roleDescriptors) {
        ((CreateApiKeyRequest)this.request).setRoleDescriptors(roleDescriptors);
        return this;
    }

    public CreateApiKeyRequestBuilder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        ((CreateApiKeyRequest)this.request).setRefreshPolicy(refreshPolicy);
        return this;
    }

    public CreateApiKeyRequestBuilder setMetadata(Map<String, Object> metadata) {
        ((CreateApiKeyRequest)this.request).setMetadata(metadata);
        return this;
    }

    public CreateApiKeyRequestBuilder source(BytesReference source, XContentType xContentType) throws IOException {
        NamedXContentRegistry registry = NamedXContentRegistry.EMPTY;
        try (StreamInput stream = source.streamInput();
             XContentParser parser = xContentType.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
            CreateApiKeyRequest createApiKeyRequest = CreateApiKeyRequestBuilder.parse(parser);
            this.setName(createApiKeyRequest.getName());
            this.setRoleDescriptors(createApiKeyRequest.getRoleDescriptors());
            this.setExpiration(createApiKeyRequest.getExpiration());
            this.setMetadata(createApiKeyRequest.getMetadata());
        }
        return this;
    }

    public static CreateApiKeyRequest parse(XContentParser parser) throws IOException {
        return (CreateApiKeyRequest)((Object)PARSER.parse(parser, null));
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
            p.nextToken();
            return RoleDescriptor.parse(n, p, false);
        }, new ParseField("role_descriptors", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
    }
}

