/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class FieldPermissionsCache {
    public static final Setting<Long> CACHE_SIZE_SETTING = Setting.longSetting((String)SecurityField.setting("authz.store.roles.field_permissions.cache.max_size_in_bytes"), (long)0x6400000L, (long)-1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Cache<FieldPermissionsDefinition, FieldPermissions> cache;

    public FieldPermissionsCache(Settings settings) {
        this.cache = CacheBuilder.builder().setMaximumWeight(((Long)CACHE_SIZE_SETTING.get(settings)).longValue()).weigher((key, fieldPermissions) -> fieldPermissions.ramBytesUsed()).build();
    }

    FieldPermissions getFieldPermissions(String[] granted, String[] denied) {
        return this.getFieldPermissions(new FieldPermissionsDefinition(granted, denied));
    }

    public FieldPermissions getFieldPermissions(FieldPermissionsDefinition fieldPermissionsDefinition) {
        try {
            return (FieldPermissions)this.cache.computeIfAbsent((Object)fieldPermissionsDefinition, key -> new FieldPermissions((FieldPermissionsDefinition)key, FieldPermissions.initializePermittedFieldsAutomaton(key)));
        }
        catch (ExecutionException e) {
            throw new ElasticsearchException("unable to compute field permissions", (Throwable)e, new Object[0]);
        }
    }

    FieldPermissions getFieldPermissions(Collection<FieldPermissions> fieldPermissionsCollection) {
        Optional<FieldPermissions> allowAllFieldPermissions = fieldPermissionsCollection.stream().filter(((Predicate<FieldPermissions>)FieldPermissions::hasFieldLevelSecurity).negate()).findFirst();
        return allowAllFieldPermissions.orElseGet(() -> {
            HashSet<FieldPermissionsDefinition.FieldGrantExcludeGroup> fieldGrantExcludeGroups = new HashSet<FieldPermissionsDefinition.FieldGrantExcludeGroup>();
            for (FieldPermissions fieldPermissions : fieldPermissionsCollection) {
                FieldPermissionsDefinition definition = fieldPermissions.getFieldPermissionsDefinition();
                FieldPermissionsDefinition limitedByDefinition = fieldPermissions.getLimitedByFieldPermissionsDefinition();
                if (definition == null) {
                    throw new IllegalArgumentException("Expected field permission definition, but found null");
                }
                if (limitedByDefinition != null) {
                    throw new IllegalArgumentException("Expected no limited-by field permission definition, but found [" + limitedByDefinition + "]");
                }
                fieldGrantExcludeGroups.addAll(definition.getFieldGrantExcludeGroups());
            }
            FieldPermissionsDefinition combined = new FieldPermissionsDefinition(fieldGrantExcludeGroups);
            try {
                return (FieldPermissions)this.cache.computeIfAbsent((Object)combined, key -> {
                    List<Automaton> automatonList = fieldPermissionsCollection.stream().map(FieldPermissions::getIncludeAutomaton).collect(Collectors.toList());
                    return new FieldPermissions((FieldPermissionsDefinition)key, Automatons.unionAndMinimize(automatonList));
                });
            }
            catch (ExecutionException e) {
                throw new ElasticsearchException("unable to compute field permissions", (Throwable)e, new Object[0]);
            }
        });
    }
}

