/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli.keystore;

import joptsimple.OptionSet;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cli.keystore.BaseKeyStoreCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;

class ChangeKeyStorePasswordCommand
extends BaseKeyStoreCommand {
    ChangeKeyStorePasswordCommand() {
        super("Changes the password of a keystore", true);
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString newPassword = ChangeKeyStorePasswordCommand.readPassword((Terminal)terminal, (boolean)true);){
            KeyStoreWrapper keyStore = this.getKeyStore();
            keyStore.save(env.configFile(), newPassword.getChars());
            terminal.println((CharSequence)"Elasticsearch keystore password changed successfully.");
        }
        catch (SecurityException e) {
            throw new UserException(65, e.getMessage());
        }
    }
}

