/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.xpack.core.XPackSettings;

public class SecurityImplicitBehaviorBootstrapCheck
implements BootstrapCheck {
    private final NodeMetadata nodeMetadata;

    public SecurityImplicitBehaviorBootstrapCheck(NodeMetadata nodeMetadata) {
        this.nodeMetadata = nodeMetadata;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        if (this.nodeMetadata == null) {
            return BootstrapCheck.BootstrapCheckResult.success();
        }
        License license = LicenseService.getLicense((Metadata)context.metadata());
        Version lastKnownVersion = this.nodeMetadata.previousNodeVersion();
        if (lastKnownVersion.before(Version.V_8_0_0) && !XPackSettings.SECURITY_ENABLED.exists(context.settings()) && (license.operationMode() == License.OperationMode.BASIC || license.operationMode() == License.OperationMode.TRIAL)) {
            return BootstrapCheck.BootstrapCheckResult.failure((String)("The default value for [" + XPackSettings.SECURITY_ENABLED.getKey() + "] has changed in the current version.  Security features were implicitly disabled for this node but they would now be enabled, possibly preventing access to the node. See https://www.elastic.co/guide/en/elasticsearch/reference/" + Version.CURRENT.major + "." + Version.CURRENT.minor + "/security-minimal-setup.html to configure security, or explicitly disable security by setting [xpack.security.enabled] to \"false\" in elasticsearch.yml before restarting the node."));
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    public boolean alwaysEnforce() {
        return true;
    }
}

