/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.saml.SamlRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.saml.IdpConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SamlAttributes;
import org.elasticsearch.xpack.security.authc.saml.SamlAuthenticator;
import org.elasticsearch.xpack.security.authc.saml.SamlAuthnRequestBuilder;
import org.elasticsearch.xpack.security.authc.saml.SamlLogoutRequestHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlLogoutRequestMessageBuilder;
import org.elasticsearch.xpack.security.authc.saml.SamlLogoutResponseBuilder;
import org.elasticsearch.xpack.security.authc.saml.SamlLogoutResponseHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlNameId;
import org.elasticsearch.xpack.security.authc.saml.SamlToken;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SigningConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.elasticsearch.xpack.security.authc.support.DelegatedAuthorizationSupport;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.impl.X509KeyManagerX509CredentialAdapter;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;

public final class SamlRealm
extends Realm
implements Releasable {
    private static final Logger logger = LogManager.getLogger(SamlRealm.class);
    public static final String USER_METADATA_NAMEID_VALUE = "saml_nameid";
    public static final String USER_METADATA_NAMEID_FORMAT = "saml_nameid_format";
    public static final String CONTEXT_TOKEN_DATA = "_xpack_saml_tokendata";
    public static final String TOKEN_METADATA_NAMEID_VALUE = "saml_nameid_val";
    public static final String TOKEN_METADATA_NAMEID_FORMAT = "saml_nameid_fmt";
    public static final String TOKEN_METADATA_NAMEID_QUALIFIER = "saml_nameid_qual";
    public static final String TOKEN_METADATA_NAMEID_SP_QUALIFIER = "saml_nameid_sp_qual";
    public static final String TOKEN_METADATA_NAMEID_SP_PROVIDED_ID = "saml_nameid_sp_id";
    public static final String TOKEN_METADATA_SESSION = "saml_session";
    public static final String TOKEN_METADATA_REALM = "saml_realm";
    private final List<Releasable> releasables;
    private final SamlAuthenticator authenticator;
    private final SamlLogoutRequestHandler logoutHandler;
    private final UserRoleMapper roleMapper;
    private final SamlLogoutResponseHandler logoutResponseHandler;
    private final Supplier<EntityDescriptor> idpDescriptor;
    private final SpConfiguration serviceProvider;
    private final SamlAuthnRequestBuilder.NameIDPolicySettings nameIdPolicy;
    private final Boolean forceAuthn;
    private final boolean useSingleLogout;
    private final Boolean populateUserMetadata;
    private final AttributeParser principalAttribute;
    private final AttributeParser groupsAttribute;
    private final AttributeParser dnAttribute;
    private final AttributeParser nameAttribute;
    private final AttributeParser mailAttribute;
    private DelegatedAuthorizationSupport delegatedRealms;

    public static SamlRealm create(RealmConfig config, SSLService sslService, ResourceWatcherService watcherService, UserRoleMapper roleMapper) throws Exception {
        SamlUtils.initialize(logger);
        if (!TokenService.isTokenServiceEnabled(config.settings()).booleanValue()) {
            throw new IllegalStateException("SAML requires that the token service be enabled (" + XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.getKey() + ")");
        }
        Tuple<AbstractReloadingMetadataResolver, Supplier<EntityDescriptor>> tuple = SamlRealm.initializeResolver(logger, config, sslService, watcherService);
        AbstractReloadingMetadataResolver metadataResolver = (AbstractReloadingMetadataResolver)tuple.v1();
        Supplier idpDescriptor = (Supplier)tuple.v2();
        SpConfiguration serviceProvider = SamlRealm.getSpConfiguration(config);
        Clock clock = Clock.systemUTC();
        IdpConfiguration idpConfiguration = SamlRealm.getIdpConfiguration(config, (MetadataResolver)metadataResolver, idpDescriptor);
        TimeValue maxSkew = (TimeValue)config.getSetting(SamlRealmSettings.CLOCK_SKEW);
        SamlAuthenticator authenticator = new SamlAuthenticator(clock, idpConfiguration, serviceProvider, maxSkew);
        SamlLogoutRequestHandler logoutHandler = new SamlLogoutRequestHandler(clock, idpConfiguration, serviceProvider, maxSkew);
        SamlLogoutResponseHandler logoutResponseHandler = new SamlLogoutResponseHandler(clock, idpConfiguration, serviceProvider, maxSkew);
        SamlRealm realm = new SamlRealm(config, roleMapper, authenticator, logoutHandler, logoutResponseHandler, idpDescriptor, serviceProvider);
        realm.releasables.add(() -> metadataResolver.destroy());
        return realm;
    }

    public SpConfiguration getServiceProvider() {
        return this.serviceProvider;
    }

    SamlRealm(RealmConfig config, UserRoleMapper roleMapper, SamlAuthenticator authenticator, SamlLogoutRequestHandler logoutHandler, SamlLogoutResponseHandler logoutResponseHandler, Supplier<EntityDescriptor> idpDescriptor, SpConfiguration spConfiguration) throws Exception {
        super(config);
        this.roleMapper = roleMapper;
        this.authenticator = authenticator;
        this.logoutHandler = logoutHandler;
        this.logoutResponseHandler = logoutResponseHandler;
        this.idpDescriptor = idpDescriptor;
        this.serviceProvider = spConfiguration;
        this.nameIdPolicy = new SamlAuthnRequestBuilder.NameIDPolicySettings((String)config.getSetting(SamlRealmSettings.NAMEID_FORMAT), (Boolean)config.getSetting(SamlRealmSettings.NAMEID_ALLOW_CREATE), (String)config.getSetting(SamlRealmSettings.NAMEID_SP_QUALIFIER));
        this.forceAuthn = (Boolean)config.getSetting(SamlRealmSettings.FORCE_AUTHN, () -> null);
        this.useSingleLogout = (Boolean)config.getSetting(SamlRealmSettings.IDP_SINGLE_LOGOUT);
        this.populateUserMetadata = (Boolean)config.getSetting(SamlRealmSettings.POPULATE_USER_METADATA);
        this.principalAttribute = AttributeParser.forSetting(logger, SamlRealmSettings.PRINCIPAL_ATTRIBUTE, config, true);
        this.groupsAttribute = AttributeParser.forSetting(logger, SamlRealmSettings.GROUPS_ATTRIBUTE, config, false);
        this.dnAttribute = AttributeParser.forSetting(logger, SamlRealmSettings.DN_ATTRIBUTE, config, false);
        this.nameAttribute = AttributeParser.forSetting(logger, SamlRealmSettings.NAME_ATTRIBUTE, config, false);
        this.mailAttribute = AttributeParser.forSetting(logger, SamlRealmSettings.MAIL_ATTRIBUTE, config, false);
        this.releasables = new ArrayList<Releasable>();
    }

    public void initialize(Iterable<Realm> realms, XPackLicenseState licenseState) {
        if (this.delegatedRealms != null) {
            throw new IllegalStateException("Realm has already been initialized");
        }
        this.delegatedRealms = new DelegatedAuthorizationSupport(realms, this.config, licenseState);
    }

    static String require(RealmConfig config, Setting.AffixSetting<String> setting) {
        String value = (String)config.getSetting(setting);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("The configuration setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, setting) + "] is required");
        }
        return value;
    }

    private static IdpConfiguration getIdpConfiguration(RealmConfig config, MetadataResolver metadataResolver, Supplier<EntityDescriptor> idpDescriptor) {
        MetadataCredentialResolver resolver = new MetadataCredentialResolver();
        PredicateRoleDescriptorResolver roleDescriptorResolver = new PredicateRoleDescriptorResolver(metadataResolver);
        resolver.setRoleDescriptorResolver((RoleDescriptorResolver)roleDescriptorResolver);
        InlineX509DataProvider keyInfoProvider = new InlineX509DataProvider();
        resolver.setKeyInfoCredentialResolver((KeyInfoCredentialResolver)new BasicProviderKeyInfoCredentialResolver(Collections.singletonList(keyInfoProvider)));
        try {
            roleDescriptorResolver.initialize();
            resolver.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new IllegalStateException("Cannot initialise SAML IDP resolvers for realm " + config.name(), e);
        }
        String entityID = idpDescriptor.get().getEntityID();
        return new IdpConfiguration(entityID, () -> {
            try {
                Iterable credentials = resolver.resolve(new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID), new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME), new UsageCriterion(UsageType.SIGNING)}));
                return CollectionUtils.iterableAsArrayList((Iterable)credentials);
            }
            catch (ResolverException e) {
                throw new IllegalStateException("Cannot resolve SAML IDP credentials resolver for realm " + config.name(), e);
            }
        });
    }

    static SpConfiguration getSpConfiguration(RealmConfig config) throws IOException, GeneralSecurityException {
        String serviceProviderId = SamlRealm.require(config, (Setting.AffixSetting<String>)SamlRealmSettings.SP_ENTITY_ID);
        String assertionConsumerServiceURL = SamlRealm.require(config, (Setting.AffixSetting<String>)SamlRealmSettings.SP_ACS);
        String logoutUrl = (String)config.getSetting(SamlRealmSettings.SP_LOGOUT);
        List reqAuthnCtxClassRef = (List)config.getSetting(SamlRealmSettings.REQUESTED_AUTHN_CONTEXT_CLASS_REF);
        return new SpConfiguration(serviceProviderId, assertionConsumerServiceURL, logoutUrl, SamlRealm.buildSigningConfiguration(config), SamlRealm.buildEncryptionCredential(config), reqAuthnCtxClassRef);
    }

    static List<X509Credential> buildEncryptionCredential(RealmConfig config) throws IOException, GeneralSecurityException {
        return SamlRealm.buildCredential(config, RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)config.identifier()) + "encryption.", (Setting.AffixSetting<String>)SamlRealmSettings.ENCRYPTION_KEY_ALIAS, true);
    }

    static SigningConfiguration buildSigningConfiguration(RealmConfig config) throws IOException, GeneralSecurityException {
        List<X509Credential> credentials = SamlRealm.buildCredential(config, RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)config.identifier()) + "signing.", (Setting.AffixSetting<String>)SamlRealmSettings.SIGNING_KEY_ALIAS, false);
        if (credentials == null || credentials.isEmpty()) {
            if (config.hasSetting(SamlRealmSettings.SIGNING_MESSAGE_TYPES)) {
                throw new IllegalArgumentException("The setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)SamlRealmSettings.SIGNING_MESSAGE_TYPES) + "] cannot be specified if there are no signing credentials");
            }
            return new SigningConfiguration(Collections.emptySet(), null);
        }
        List types = (List)config.getSetting(SamlRealmSettings.SIGNING_MESSAGE_TYPES);
        return new SigningConfiguration(Sets.newHashSet((Iterable)types), credentials.get(0));
    }

    private static List<X509Credential> buildCredential(RealmConfig config, String prefix, Setting.AffixSetting<String> aliasSetting, boolean allowMultiple) {
        SslKeyConfig keyConfig = CertParsingUtils.createKeyConfig((Settings)config.settings(), (String)prefix, (Environment)config.env(), (boolean)false);
        if (!keyConfig.hasKeyMaterial()) {
            return null;
        }
        X509ExtendedKeyManager keyManager = keyConfig.createKeyManager();
        if (keyManager == null) {
            return null;
        }
        HashSet<String> aliases = new HashSet<String>();
        String configuredAlias = (String)config.getSetting(aliasSetting);
        if (Strings.isNullOrEmpty((String)configuredAlias)) {
            String[] serverAliases = keyManager.getServerAliases("RSA", null);
            if (serverAliases != null) {
                aliases.addAll(Arrays.asList(serverAliases));
            }
            if (aliases.isEmpty()) {
                throw new IllegalArgumentException("The configured key store for " + prefix + " does not contain any RSA key pairs");
            }
            if (!allowMultiple && aliases.size() > 1) {
                throw new IllegalArgumentException("The configured key store for " + prefix + " has multiple keys but no alias has been specified (from setting " + RealmSettings.getFullSettingKey((RealmConfig)config, aliasSetting) + ")");
            }
        } else {
            aliases.add(configuredAlias);
        }
        ArrayList<X509Credential> credentials = new ArrayList<X509Credential>();
        for (String alias : aliases) {
            if (keyManager.getPrivateKey(alias) == null) {
                throw new IllegalArgumentException("The configured key store for " + prefix + " does not have a key associated with alias [" + alias + "] " + (String)(!Strings.isNullOrEmpty((String)configuredAlias) ? "(from setting " + RealmSettings.getFullSettingKey((RealmConfig)config, aliasSetting) + ")" : ""));
            }
            String keyType = keyManager.getPrivateKey(alias).getAlgorithm();
            if (!keyType.equals("RSA")) {
                throw new IllegalArgumentException("The key associated with alias [" + alias + "] (from setting " + RealmSettings.getFullSettingKey((RealmConfig)config, aliasSetting) + ") uses unsupported key algorithm type [" + keyType + "], only RSA is supported");
            }
            credentials.add((X509Credential)new X509KeyManagerX509CredentialAdapter((X509KeyManager)keyManager, alias));
        }
        return credentials;
    }

    public static List<SamlRealm> findSamlRealms(Realms realms, String realmName, String acsUrl) {
        Stream<SamlRealm> stream = realms.stream().filter(r -> r instanceof SamlRealm).map(r -> (SamlRealm)((Object)r));
        if (Strings.hasText((String)realmName)) {
            stream = stream.filter(r -> realmName.equals(r.name()));
        }
        if (Strings.hasText((String)acsUrl)) {
            stream = stream.filter(r -> acsUrl.equals(r.assertionConsumerServiceURL()));
        }
        return stream.collect(Collectors.toList());
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof SamlToken;
    }

    private boolean isTokenForRealm(SamlToken samlToken) {
        if (samlToken.getAuthenticatingRealm() == null) {
            return true;
        }
        return samlToken.getAuthenticatingRealm().equals(this.name());
    }

    public AuthenticationToken token(ThreadContext threadContext) {
        return null;
    }

    public void authenticate(AuthenticationToken authenticationToken, ActionListener<AuthenticationResult<User>> listener) {
        block5: {
            if (authenticationToken instanceof SamlToken && this.isTokenForRealm((SamlToken)authenticationToken)) {
                try {
                    SamlToken token = (SamlToken)authenticationToken;
                    SamlAttributes attributes = this.authenticator.authenticate(token);
                    logger.debug("Parsed token [{}] to attributes [{}]", (Object)token, (Object)attributes);
                    this.buildUser(attributes, listener);
                }
                catch (ElasticsearchSecurityException e) {
                    if (SamlUtils.isSamlException(e)) {
                        listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("Provided SAML response is not valid for realm " + this), (Exception)((Object)e)));
                        break block5;
                    }
                    listener.onFailure((Exception)((Object)e));
                }
            } else {
                listener.onResponse((Object)AuthenticationResult.notHandled());
            }
        }
    }

    private void buildUser(SamlAttributes attributes, ActionListener<AuthenticationResult<User>> baseListener) {
        String principal = this.resolveSingleValueAttribute(attributes, this.principalAttribute, SamlRealmSettings.PRINCIPAL_ATTRIBUTE.name(this.config));
        if (Strings.isNullOrEmpty((String)principal)) {
            String msg = this.principalAttribute + " not found in saml attributes" + attributes.attributes() + " or NameID [" + attributes.name() + "]";
            baseListener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
            return;
        }
        Map<String, Object> tokenMetadata = this.createTokenMetadata(attributes.name(), attributes.session());
        ActionListener wrappedListener = ActionListener.wrap(auth -> {
            if (auth.isAuthenticated()) {
                HashMap<String, Map> metadata = new HashMap<String, Map>(auth.getMetadata());
                metadata.put(CONTEXT_TOKEN_DATA, tokenMetadata);
                auth = AuthenticationResult.success((Object)((User)auth.getValue()), metadata);
            }
            baseListener.onResponse(auth);
        }, arg_0 -> baseListener.onFailure(arg_0));
        if (this.delegatedRealms.hasDelegation()) {
            this.delegatedRealms.resolve(principal, (ActionListener<AuthenticationResult<User>>)wrappedListener);
            return;
        }
        HashMap<Object, Object> userMetaBuilder = new HashMap<Object, Object>();
        if (this.populateUserMetadata.booleanValue()) {
            for (SamlAttributes.SamlAttribute a : attributes.attributes()) {
                userMetaBuilder.put("saml(" + a.name + ")", a.values);
                if (!Strings.hasText((String)a.friendlyName)) continue;
                userMetaBuilder.put("saml_" + a.friendlyName, a.values);
            }
        }
        if (attributes.name() != null) {
            userMetaBuilder.put(USER_METADATA_NAMEID_VALUE, attributes.name().value);
            if (attributes.name().format != null) {
                userMetaBuilder.put(USER_METADATA_NAMEID_FORMAT, attributes.name().format);
            }
        }
        Map userMeta = Map.copyOf(userMetaBuilder);
        List<String> groups = this.groupsAttribute.getAttribute(attributes);
        String dn = this.resolveSingleValueAttribute(attributes, this.dnAttribute, SamlRealmSettings.DN_ATTRIBUTE.name(this.config));
        String name = this.resolveSingleValueAttribute(attributes, this.nameAttribute, SamlRealmSettings.NAME_ATTRIBUTE.name(this.config));
        String mail = this.resolveSingleValueAttribute(attributes, this.mailAttribute, SamlRealmSettings.MAIL_ATTRIBUTE.name(this.config));
        UserRoleMapper.UserData userData = new UserRoleMapper.UserData(principal, dn, groups, userMeta, this.config);
        logger.debug("SAML attribute mapping = [{}]", (Object)userData);
        this.roleMapper.resolveRoles(userData, ActionListener.wrap(roles -> {
            User user = new User(principal, roles.toArray(new String[roles.size()]), name, mail, userMeta, true);
            logger.debug("SAML user = [{}]", (Object)user);
            wrappedListener.onResponse((Object)AuthenticationResult.success((Object)user));
        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
    }

    public Map<String, Object> createTokenMetadata(SamlNameId nameId, String session) {
        HashMap<String, Object> tokenMeta = new HashMap<String, Object>();
        if (nameId != null) {
            tokenMeta.put(TOKEN_METADATA_NAMEID_VALUE, nameId.value);
            tokenMeta.put(TOKEN_METADATA_NAMEID_FORMAT, nameId.format);
            tokenMeta.put(TOKEN_METADATA_NAMEID_QUALIFIER, nameId.idpNameQualifier);
            tokenMeta.put(TOKEN_METADATA_NAMEID_SP_QUALIFIER, nameId.spNameQualifier);
            tokenMeta.put(TOKEN_METADATA_NAMEID_SP_PROVIDED_ID, nameId.spProvidedId);
        } else {
            tokenMeta.put(TOKEN_METADATA_NAMEID_VALUE, null);
            tokenMeta.put(TOKEN_METADATA_NAMEID_FORMAT, null);
            tokenMeta.put(TOKEN_METADATA_NAMEID_QUALIFIER, null);
            tokenMeta.put(TOKEN_METADATA_NAMEID_SP_QUALIFIER, null);
            tokenMeta.put(TOKEN_METADATA_NAMEID_SP_PROVIDED_ID, null);
        }
        tokenMeta.put(TOKEN_METADATA_SESSION, session);
        tokenMeta.put(TOKEN_METADATA_REALM, this.name());
        return tokenMeta;
    }

    private String resolveSingleValueAttribute(SamlAttributes attributes, AttributeParser parser, String name) {
        List<String> list = parser.getAttribute(attributes);
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        logger.info("SAML assertion contains multiple values for attribute [{}] returning first one", (Object)name);
        return list.get(0);
    }

    public void lookupUser(String username, ActionListener<User> listener) {
        listener.onResponse(null);
    }

    static Tuple<AbstractReloadingMetadataResolver, Supplier<EntityDescriptor>> initializeResolver(Logger logger, RealmConfig config, SSLService sslService, ResourceWatcherService watcherService) throws ResolverException, ComponentInitializationException, PrivilegedActionException, IOException {
        String metadataUrl = SamlRealm.require(config, (Setting.AffixSetting<String>)SamlRealmSettings.IDP_METADATA_PATH);
        if (metadataUrl.startsWith("http://")) {
            throw new IllegalArgumentException("The [http] protocol is not supported as it is insecure. Use [https] instead");
        }
        if (metadataUrl.startsWith("https://")) {
            return SamlRealm.parseHttpMetadata(metadataUrl, config, sslService);
        }
        return SamlRealm.parseFileSystemMetadata(logger, metadataUrl, config, watcherService);
    }

    private static Tuple<AbstractReloadingMetadataResolver, Supplier<EntityDescriptor>> parseHttpMetadata(String metadataUrl, RealmConfig config, SSLService sslService) throws ResolverException, ComponentInitializationException, PrivilegedActionException {
        String entityId = SamlRealm.require(config, (Setting.AffixSetting<String>)SamlRealmSettings.IDP_ENTITY_ID);
        HttpClientBuilder builder = HttpClientBuilder.create();
        String sslKey = RealmSettings.realmSslPrefix((RealmConfig.RealmIdentifier)config.identifier());
        SslConfiguration sslConfiguration = sslService.getSSLConfiguration(sslKey);
        HostnameVerifier verifier = SSLService.getHostnameVerifier((SslConfiguration)sslConfiguration);
        SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslService.sslSocketFactory(sslConfiguration), verifier);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)factory);
        PrivilegedHTTPMetadataResolver resolver = new PrivilegedHTTPMetadataResolver((HttpClient)builder.build(), metadataUrl);
        TimeValue refresh = (TimeValue)config.getSetting(SamlRealmSettings.IDP_METADATA_HTTP_REFRESH);
        resolver.setMinRefreshDelay(Duration.ofMillis(refresh.millis()));
        resolver.setMaxRefreshDelay(Duration.ofMillis(refresh.millis()));
        SamlRealm.initialiseResolver((AbstractReloadingMetadataResolver)resolver, config);
        return new Tuple((Object)resolver, () -> {
            SpecialPermission.check();
            try {
                return AccessController.doPrivileged(() -> SamlRealm.resolveEntityDescriptor((AbstractReloadingMetadataResolver)resolver, entityId, metadataUrl));
            }
            catch (PrivilegedActionException e) {
                throw ExceptionsHelper.convertToRuntime((Exception)((Exception)ExceptionsHelper.unwrapCause((Throwable)e)));
            }
        });
    }

    @SuppressForbidden(reason="uses toFile")
    private static Tuple<AbstractReloadingMetadataResolver, Supplier<EntityDescriptor>> parseFileSystemMetadata(Logger logger, String metadataPath, RealmConfig config, ResourceWatcherService watcherService) throws ResolverException, ComponentInitializationException, IOException, PrivilegedActionException {
        String entityId = SamlRealm.require(config, (Setting.AffixSetting<String>)SamlRealmSettings.IDP_ENTITY_ID);
        Path path = config.env().configFile().resolve(metadataPath);
        FilesystemMetadataResolver resolver = new FilesystemMetadataResolver(path.toFile());
        if (config.hasSetting(SamlRealmSettings.IDP_METADATA_HTTP_REFRESH)) {
            logger.info("Ignoring setting [{}] because the IdP metadata is being loaded from a file", (Object)RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)SamlRealmSettings.IDP_METADATA_HTTP_REFRESH));
        }
        Duration oneDayMs = Duration.ofMillis(TimeValue.timeValueHours((long)24L).millis());
        resolver.setMinRefreshDelay(oneDayMs);
        resolver.setMaxRefreshDelay(oneDayMs);
        SamlRealm.initialiseResolver((AbstractReloadingMetadataResolver)resolver, config);
        FileWatcher watcher = new FileWatcher(path);
        watcher.addListener((Object)new FileListener(logger, (CheckedRunnable<Exception>)((CheckedRunnable)() -> ((FilesystemMetadataResolver)resolver).refresh())));
        watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.MEDIUM);
        return new Tuple((Object)resolver, () -> SamlRealm.resolveEntityDescriptor((AbstractReloadingMetadataResolver)resolver, entityId, path.toString()));
    }

    private static EntityDescriptor resolveEntityDescriptor(AbstractReloadingMetadataResolver resolver, String entityId, String sourceLocation) {
        try {
            EntityDescriptor descriptor = resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId)}));
            if (descriptor == null) {
                throw SamlUtils.samlException("Cannot find metadata for entity [{}] in [{}]", entityId, sourceLocation);
            }
            return descriptor;
        }
        catch (ResolverException e) {
            throw SamlUtils.samlException("Cannot resolve entity metadata", (Exception)((Object)e), new Object[0]);
        }
    }

    public void close() {
        Releasables.close(this.releasables);
    }

    private static void initialiseResolver(AbstractReloadingMetadataResolver resolver, RealmConfig config) throws ComponentInitializationException, PrivilegedActionException {
        resolver.setRequireValidMetadata(true);
        BasicParserPool pool = new BasicParserPool();
        pool.initialize();
        resolver.setParserPool((ParserPool)pool);
        resolver.setId(config.name());
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            resolver.initialize();
            return null;
        });
    }

    public String serviceProviderEntityId() {
        return this.serviceProvider.getEntityId();
    }

    public String assertionConsumerServiceURL() {
        return this.serviceProvider.getAscUrl();
    }

    public AuthnRequest buildAuthenticationRequest() {
        AuthnRequest authnRequest = new SamlAuthnRequestBuilder(this.serviceProvider, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", this.idpDescriptor.get(), "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", Clock.systemUTC()).nameIDPolicy(this.nameIdPolicy).forceAuthn(this.forceAuthn).build();
        if (logger.isTraceEnabled()) {
            logger.trace("Constructed SAML Authentication Request: {}", (Object)SamlUtils.getXmlContent((SAMLObject)authnRequest, true));
        }
        return authnRequest;
    }

    public LogoutRequest buildLogoutRequest(NameID nameId, String session) {
        if (this.useSingleLogout) {
            LogoutRequest logoutRequest = new SamlLogoutRequestMessageBuilder(Clock.systemUTC(), this.serviceProvider, this.idpDescriptor.get(), nameId, session).build();
            if (logoutRequest != null && logger.isTraceEnabled()) {
                logger.trace("Constructed SAML Logout Request: {}", (Object)SamlUtils.getXmlContent((SAMLObject)logoutRequest, true));
            }
            return logoutRequest;
        }
        return null;
    }

    public LogoutResponse buildLogoutResponse(String inResponseTo) {
        LogoutResponse logoutResponse = new SamlLogoutResponseBuilder(Clock.systemUTC(), this.serviceProvider, this.idpDescriptor.get(), inResponseTo, "urn:oasis:names:tc:SAML:2.0:status:Success").build();
        if (logoutResponse != null && logger.isTraceEnabled()) {
            logger.trace("Constructed SAML Logout Response: {}", (Object)SamlUtils.getXmlContent((SAMLObject)logoutResponse, true));
        }
        return logoutResponse;
    }

    public SigningConfiguration getSigningConfiguration() {
        return this.serviceProvider.getSigningConfiguration();
    }

    public SamlLogoutRequestHandler getLogoutHandler() {
        return this.logoutHandler;
    }

    public SamlLogoutResponseHandler getLogoutResponseHandler() {
        return this.logoutResponseHandler;
    }

    static final class AttributeParser {
        private final String name;
        private final Function<SamlAttributes, List<String>> parser;

        AttributeParser(String name, Function<SamlAttributes, List<String>> parser) {
            this.name = name;
            this.parser = parser;
        }

        List<String> getAttribute(SamlAttributes attributes) {
            List<String> attrValue = this.parser.apply(attributes);
            logger.trace(() -> new ParameterizedMessage("Parser [{}] generated values [{}]", (Object)this.name, (Object)Strings.collectionToCommaDelimitedString((Iterable)attrValue)));
            return attrValue;
        }

        public String toString() {
            return this.name;
        }

        static AttributeParser forSetting(Logger logger, SamlRealmSettings.AttributeSetting setting, RealmConfig realmConfig, boolean required) {
            if (realmConfig.hasSetting(setting.getAttribute())) {
                String attributeName = (String)realmConfig.getSetting(setting.getAttribute());
                if (realmConfig.hasSetting(setting.getPattern())) {
                    Pattern regex = Pattern.compile((String)realmConfig.getSetting(setting.getPattern()));
                    return new AttributeParser("SAML Attribute [" + attributeName + "] with pattern [" + regex.pattern() + "] for [" + setting.name(realmConfig) + "]", attributes -> attributes.getAttributeValues(attributeName).stream().map(s -> {
                        Matcher matcher = regex.matcher((CharSequence)s);
                        if (!matcher.find()) {
                            logger.debug("Attribute [{}] is [{}], which does not match [{}]", (Object)attributeName, s, (Object)regex.pattern());
                            return null;
                        }
                        String value = matcher.group(1);
                        if (Strings.isNullOrEmpty((String)value)) {
                            logger.debug("Attribute [{}] is [{}], which does match [{}] but group(1) is empty", (Object)attributeName, s, (Object)regex.pattern());
                            return null;
                        }
                        return value;
                    }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList()));
                }
                return new AttributeParser("SAML Attribute [" + attributeName + "] for [" + setting.name(realmConfig) + "]", attributes -> attributes.getAttributeValues(attributeName));
            }
            if (required) {
                throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getAttribute()) + "] is required");
            }
            if (realmConfig.hasSetting(setting.getPattern())) {
                throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getPattern()) + "] cannot be set unless [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getAttribute()) + "] is also set");
            }
            return new AttributeParser("No SAML attribute for [" + setting.name(realmConfig) + "]", attributes -> List.of());
        }
    }

    private static final class PrivilegedHTTPMetadataResolver
    extends HTTPMetadataResolver {
        PrivilegedHTTPMetadataResolver(HttpClient client, String metadataURL) throws ResolverException {
            super(client, metadataURL);
        }

        protected byte[] fetchMetadata() throws ResolverException {
            try {
                return AccessController.doPrivileged(() -> PrivilegedHTTPMetadataResolver.super.fetchMetadata());
            }
            catch (PrivilegedActionException e) {
                throw (ResolverException)e.getCause();
            }
        }
    }

    private static class FileListener
    implements FileChangesListener {
        private final Logger logger;
        private final CheckedRunnable<Exception> onChange;

        private FileListener(Logger logger, CheckedRunnable<Exception> onChange) {
            this.logger = logger;
            this.onChange = onChange;
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            try {
                this.onChange.run();
            }
            catch (Exception e) {
                this.logger.warn((Message)new ParameterizedMessage("An error occurred while reloading file [{}]", (Object)file), (Throwable)e);
            }
        }
    }
}

