/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml.saml2.metadata.OrganizationName;
import org.opensaml.saml.saml2.metadata.OrganizationURL;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.ServiceName;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.AttributeConsumingServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.ContactPersonBuilder;
import org.opensaml.saml.saml2.metadata.impl.EmailAddressBuilder;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.GivenNameBuilder;
import org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.NameIDFormatBuilder;
import org.opensaml.saml.saml2.metadata.impl.OrganizationBuilder;
import org.opensaml.saml.saml2.metadata.impl.OrganizationDisplayNameBuilder;
import org.opensaml.saml.saml2.metadata.impl.OrganizationNameBuilder;
import org.opensaml.saml.saml2.metadata.impl.OrganizationURLBuilder;
import org.opensaml.saml.saml2.metadata.impl.RequestedAttributeBuilder;
import org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.ServiceNameBuilder;
import org.opensaml.saml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.SurNameBuilder;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.impl.KeyInfoBuilder;

public class SamlSpMetadataBuilder {
    private final Locale locale;
    private final String entityId;
    private final Map<String, String> attributeNames;
    private final List<ContactInfo> contacts;
    private String serviceName;
    private String nameIdFormat;
    private String assertionConsumerServiceUrl;
    private String singleLogoutServiceUrl;
    private Boolean authnRequestsSigned;
    private X509Certificate signingCertificate;
    private List<X509Certificate> encryptionCertificates = new ArrayList<X509Certificate>();
    private OrganizationInfo organization;

    public SamlSpMetadataBuilder(Locale locale, String entityId) {
        this.locale = locale;
        this.entityId = entityId;
        this.attributeNames = new LinkedHashMap<String, String>();
        this.contacts = new ArrayList<ContactInfo>();
        this.serviceName = "Elasticsearch";
        this.nameIdFormat = null;
        this.authnRequestsSigned = Boolean.FALSE;
    }

    public SamlSpMetadataBuilder nameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
        return this;
    }

    public SamlSpMetadataBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public SamlSpMetadataBuilder withAttribute(String friendlyName, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Attribute name cannot be empty (friendly name was [" + friendlyName + "])");
        }
        this.attributeNames.put(name, friendlyName);
        return this;
    }

    public SamlSpMetadataBuilder assertionConsumerServiceUrl(String acsUrl) {
        this.assertionConsumerServiceUrl = acsUrl;
        return this;
    }

    public SamlSpMetadataBuilder singleLogoutServiceUrl(String slsUrl) {
        this.singleLogoutServiceUrl = slsUrl;
        return this;
    }

    public SamlSpMetadataBuilder authnRequestsSigned(Boolean authnRequestsSigned) {
        this.authnRequestsSigned = authnRequestsSigned;
        return this;
    }

    public SamlSpMetadataBuilder signingCertificate(X509Certificate signingCertificate) {
        this.signingCertificate = signingCertificate;
        return this;
    }

    public SamlSpMetadataBuilder signingCredential(X509Credential credential) {
        return this.signingCertificate(credential == null ? null : credential.getEntityCertificate());
    }

    public SamlSpMetadataBuilder encryptionCertificates(Collection<X509Certificate> encryptionCertificates) {
        if (encryptionCertificates != null) {
            this.encryptionCertificates.addAll(encryptionCertificates);
        }
        return this;
    }

    public SamlSpMetadataBuilder encryptionCredentials(Collection<X509Credential> credentials) {
        return this.encryptionCertificates(credentials == null ? Collections.emptyList() : (Collection)credentials.stream().map(credential -> credential.getEntityCertificate()).collect(Collectors.toList()));
    }

    public SamlSpMetadataBuilder organization(OrganizationInfo organization) {
        this.organization = organization;
        return this;
    }

    public SamlSpMetadataBuilder organization(String orgName, String displayName, String url) {
        return this.organization(new OrganizationInfo(orgName, displayName, url));
    }

    public SamlSpMetadataBuilder withContact(ContactInfo contact) {
        this.contacts.add(contact);
        return this;
    }

    public SamlSpMetadataBuilder withContact(String type, String givenName, String surName, String email) {
        return this.withContact(new ContactInfo(ContactInfo.getType(type), givenName, surName, email));
    }

    public EntityDescriptor build() throws Exception {
        SPSSODescriptor spRoleDescriptor = new SPSSODescriptorBuilder().buildObject();
        spRoleDescriptor.removeAllSupportedProtocols();
        spRoleDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spRoleDescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
        spRoleDescriptor.setAuthnRequestsSigned(this.authnRequestsSigned);
        if (!Strings.isNullOrEmpty((String)this.nameIdFormat)) {
            spRoleDescriptor.getNameIDFormats().add(this.buildNameIdFormat());
        }
        spRoleDescriptor.getAssertionConsumerServices().add(this.buildAssertionConsumerService());
        if (this.attributeNames.size() > 0) {
            spRoleDescriptor.getAttributeConsumingServices().add(this.buildAttributeConsumerService());
        }
        if (Strings.hasText((String)this.singleLogoutServiceUrl)) {
            spRoleDescriptor.getSingleLogoutServices().add(this.buildSingleLogoutService());
        }
        spRoleDescriptor.getKeyDescriptors().addAll(this.buildKeyDescriptors());
        EntityDescriptor descriptor = new EntityDescriptorBuilder().buildObject();
        descriptor.setEntityID(this.entityId);
        descriptor.getRoleDescriptors().add(spRoleDescriptor);
        if (this.organization != null) {
            descriptor.setOrganization(this.buildOrganization());
        }
        if (this.contacts.size() > 0) {
            this.contacts.forEach(c -> descriptor.getContactPersons().add(this.buildContact((ContactInfo)c)));
        }
        return descriptor;
    }

    private NameIDFormat buildNameIdFormat() {
        if (Strings.isNullOrEmpty((String)this.nameIdFormat)) {
            throw new IllegalStateException("NameID format has not been specified");
        }
        NameIDFormat format = new NameIDFormatBuilder().buildObject();
        format.setURI(this.nameIdFormat);
        return format;
    }

    private AssertionConsumerService buildAssertionConsumerService() {
        if (Strings.isNullOrEmpty((String)this.assertionConsumerServiceUrl)) {
            throw new IllegalStateException("AssertionConsumerService URL has not been specified");
        }
        AssertionConsumerService acs = new AssertionConsumerServiceBuilder().buildObject();
        acs.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        acs.setIndex(Integer.valueOf(1));
        acs.setIsDefault(Boolean.TRUE);
        acs.setLocation(this.assertionConsumerServiceUrl);
        return acs;
    }

    private AttributeConsumingService buildAttributeConsumerService() {
        AttributeConsumingService service = new AttributeConsumingServiceBuilder().buildObject();
        service.setIndex(1);
        service.setIsDefault(Boolean.valueOf(true));
        service.getNames().add(this.buildServiceName());
        this.attributeNames.forEach((name, friendlyName) -> service.getRequestedAttributes().add(this.buildRequestedAttribute((String)friendlyName, (String)name)));
        return service;
    }

    private ServiceName buildServiceName() {
        ServiceName name = new ServiceNameBuilder().buildObject();
        name.setValue(this.serviceName);
        name.setXMLLang(this.locale.toLanguageTag());
        return name;
    }

    private RequestedAttribute buildRequestedAttribute(String friendlyName, String name) {
        RequestedAttribute attribute = new RequestedAttributeBuilder().buildObject();
        if (Strings.hasText((String)friendlyName)) {
            attribute.setFriendlyName(friendlyName);
        }
        attribute.setName(name);
        attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        return attribute;
    }

    private SingleLogoutService buildSingleLogoutService() {
        SingleLogoutService service = new SingleLogoutServiceBuilder().buildObject();
        service.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        service.setLocation(this.singleLogoutServiceUrl);
        return service;
    }

    private List<? extends KeyDescriptor> buildKeyDescriptors() throws CertificateEncodingException {
        if (this.encryptionCertificates.isEmpty() && this.signingCertificate == null) {
            return Collections.emptyList();
        }
        if (this.encryptionCertificates.size() == 1 && Objects.equals(this.encryptionCertificates.get(0), this.signingCertificate)) {
            return Collections.singletonList(this.buildKeyDescriptor(this.encryptionCertificates.get(0), UsageType.UNSPECIFIED));
        }
        ArrayList<KeyDescriptor> keys = new ArrayList<KeyDescriptor>();
        if (this.signingCertificate != null) {
            keys.add(this.buildKeyDescriptor(this.signingCertificate, UsageType.SIGNING));
        }
        for (X509Certificate encryptionCertificate : this.encryptionCertificates) {
            keys.add(this.buildKeyDescriptor(encryptionCertificate, UsageType.ENCRYPTION));
        }
        return keys;
    }

    private KeyDescriptor buildKeyDescriptor(X509Certificate certificate, UsageType usageType) throws CertificateEncodingException {
        KeyDescriptor descriptor = new KeyDescriptorBuilder().buildObject();
        descriptor.setUse(usageType);
        KeyInfo keyInfo = new KeyInfoBuilder().buildObject();
        KeyInfoSupport.addCertificate((KeyInfo)keyInfo, (X509Certificate)certificate);
        descriptor.setKeyInfo(keyInfo);
        return descriptor;
    }

    private Organization buildOrganization() {
        String lang = this.locale.toLanguageTag();
        OrganizationName name = new OrganizationNameBuilder().buildObject();
        name.setValue(this.organization.organizationName);
        name.setXMLLang(lang);
        OrganizationDisplayName displayName = new OrganizationDisplayNameBuilder().buildObject();
        displayName.setValue(this.organization.displayName);
        displayName.setXMLLang(lang);
        OrganizationURL url = new OrganizationURLBuilder().buildObject();
        url.setURI(this.organization.url);
        url.setXMLLang(lang);
        Organization org = new OrganizationBuilder().buildObject();
        org.getOrganizationNames().add(name);
        org.getDisplayNames().add(displayName);
        org.getURLs().add(url);
        return org;
    }

    private ContactPerson buildContact(ContactInfo contact) {
        GivenName givenName = new GivenNameBuilder().buildObject();
        givenName.setValue(contact.givenName);
        SurName surName = new SurNameBuilder().buildObject();
        surName.setValue(contact.surName);
        EmailAddress email = new EmailAddressBuilder().buildObject();
        email.setURI(contact.email);
        ContactPerson person = new ContactPersonBuilder().buildObject();
        person.setType(contact.type);
        person.setGivenName(givenName);
        person.setSurName(surName);
        person.getEmailAddresses().add(email);
        return person;
    }

    public static class OrganizationInfo {
        public final String organizationName;
        public final String displayName;
        public final String url;

        public OrganizationInfo(String organizationName, String displayName, String url) {
            if (Strings.isNullOrEmpty((String)organizationName)) {
                throw new IllegalArgumentException("Organization Name is required");
            }
            if (Strings.isNullOrEmpty((String)displayName)) {
                throw new IllegalArgumentException("Organization Display Name is required");
            }
            if (Strings.isNullOrEmpty((String)url)) {
                throw new IllegalArgumentException("Organization URL is required");
            }
            this.organizationName = organizationName;
            this.displayName = displayName;
            this.url = url;
        }
    }

    public static class ContactInfo {
        static final Map<String, ContactPersonTypeEnumeration> TYPES = MapBuilder.newMapBuilder(new LinkedHashMap()).put((Object)ContactPersonTypeEnumeration.ADMINISTRATIVE.toString(), (Object)ContactPersonTypeEnumeration.ADMINISTRATIVE).put((Object)ContactPersonTypeEnumeration.BILLING.toString(), (Object)ContactPersonTypeEnumeration.BILLING).put((Object)ContactPersonTypeEnumeration.SUPPORT.toString(), (Object)ContactPersonTypeEnumeration.SUPPORT).put((Object)ContactPersonTypeEnumeration.TECHNICAL.toString(), (Object)ContactPersonTypeEnumeration.TECHNICAL).put((Object)ContactPersonTypeEnumeration.OTHER.toString(), (Object)ContactPersonTypeEnumeration.OTHER).map();
        public final ContactPersonTypeEnumeration type;
        public final String givenName;
        public final String surName;
        public final String email;

        public ContactInfo(ContactPersonTypeEnumeration type, String givenName, String surName, String email) {
            this.type = Objects.requireNonNull(type, "Contact Person Type is required");
            this.givenName = givenName;
            this.surName = surName;
            this.email = email;
        }

        private static ContactPersonTypeEnumeration getType(String name) {
            ContactPersonTypeEnumeration type = TYPES.get(name.toLowerCase(Locale.ROOT));
            if (type == null) {
                throw new IllegalArgumentException("Invalid contact type " + name + " allowed values are " + Strings.collectionToCommaDelimitedString(TYPES.keySet()));
            }
            return type;
        }
    }
}

