/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyResponse;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestInvalidateApiKeyAction
extends SecurityBaseRestHandler {
    static final ConstructingObjectParser<InvalidateApiKeyRequest, Void> PARSER = new ConstructingObjectParser("invalidate_api_key", a -> new InvalidateApiKeyRequest((String)a[0], (String)a[1], (String)a[2], a[3] == null ? false : (Boolean)a[3], a[4] == null ? null : ((List)a[4]).toArray(new String[0])));

    public RestInvalidateApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_security/api_key"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            InvalidateApiKeyRequest invalidateApiKeyRequest = (InvalidateApiKeyRequest)this.getObjectParser(request).parse(parser, null);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)InvalidateApiKeyAction.INSTANCE, (ActionRequest)invalidateApiKeyRequest, (ActionListener)new RestBuilderListener<InvalidateApiKeyResponse>(channel){

                public RestResponse buildResponse(InvalidateApiKeyResponse invalidateResp, XContentBuilder builder) throws Exception {
                    invalidateResp.toXContent(builder, (ToXContent.Params)this.channel.request());
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    public String getName() {
        return "xpack_security_invalidate_api_key";
    }

    private ConstructingObjectParser<InvalidateApiKeyRequest, Void> getObjectParser(RestRequest request) {
        if (request.getRestApiVersion() == RestApiVersion.V_7) {
            ConstructingObjectParser objectParser = new ConstructingObjectParser("invalidate_api_key_v7", a -> {
                String id = (String)a[5];
                List ids = (List)a[4];
                if (id != null && ids != null) {
                    throw new IllegalArgumentException("Must use either [id] or [ids], not both at the same time");
                }
                String[] idsArray = Strings.hasText((String)id) ? new String[]{id} : (ids != null ? (String[])ids.toArray(String[]::new) : null);
                return new InvalidateApiKeyRequest((String)a[0], (String)a[1], (String)a[2], a[3] == null ? false : (Boolean)a[3], idsArray);
            });
            RestInvalidateApiKeyAction.initObjectParser((ConstructingObjectParser<InvalidateApiKeyRequest, Void>)objectParser, true);
            return objectParser;
        }
        return PARSER;
    }

    private static void initObjectParser(ConstructingObjectParser<InvalidateApiKeyRequest, Void> objectParser, boolean restCompatMode) {
        objectParser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("realm_name", new String[0]));
        objectParser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("username", new String[0]));
        objectParser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("name", new String[0]));
        objectParser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("owner", new String[0]));
        objectParser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("ids", new String[0]));
        if (restCompatMode) {
            objectParser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("id", new String[0]).withAllDeprecated("ids"));
        }
    }

    static {
        RestInvalidateApiKeyAction.initObjectParser(PARSER, false);
    }
}

