/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;

public class MonitoringTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(MonitoringTemplateRegistry.class);
    public static final int REGISTRY_VERSION = Version.V_7_14_0.id;
    private static final String REGISTRY_VERSION_VARIABLE = "xpack.monitoring.template.release.version";
    private static final String TEMPLATE_VERSION = "7";
    private static final String TEMPLATE_VERSION_VARIABLE = "xpack.monitoring.template.version";
    private static final Map<String, String> ADDITIONAL_TEMPLATE_VARIABLES = Map.of("xpack.monitoring.template.version", "7");
    public static final Setting<Boolean> MONITORING_TEMPLATES_ENABLED = Setting.boolSetting((String)"xpack.monitoring.templates.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ClusterService clusterService;
    private volatile boolean monitoringTemplatesEnabled;
    public static final String ALERTS_INDEX_TEMPLATE_NAME = ".monitoring-alerts-7";
    public static final IndexTemplateConfig ALERTS_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-alerts-7", "/monitoring-alerts-7.json", REGISTRY_VERSION, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String BEATS_INDEX_TEMPLATE_NAME = ".monitoring-beats";
    public static final IndexTemplateConfig BEATS_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-beats", "/monitoring-beats.json", REGISTRY_VERSION, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String ES_INDEX_TEMPLATE_NAME = ".monitoring-es";
    public static final IndexTemplateConfig ES_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-es", "/monitoring-es.json", REGISTRY_VERSION, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String KIBANA_INDEX_TEMPLATE_NAME = ".monitoring-kibana";
    public static final IndexTemplateConfig KIBANA_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-kibana", "/monitoring-kibana.json", REGISTRY_VERSION, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String LOGSTASH_INDEX_TEMPLATE_NAME = ".monitoring-logstash";
    public static final IndexTemplateConfig LOGSTASH_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-logstash", "/monitoring-logstash.json", REGISTRY_VERSION, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String[] TEMPLATE_NAMES = new String[]{".monitoring-alerts-7", ".monitoring-beats", ".monitoring-es", ".monitoring-kibana", ".monitoring-logstash"};
    private static final Map<String, IndexTemplateConfig> MONITORED_SYSTEM_CONFIG_LOOKUP = new HashMap<String, IndexTemplateConfig>();

    public static IndexTemplateConfig getTemplateConfigForMonitoredSystem(MonitoredSystem system) {
        return Optional.ofNullable(MONITORED_SYSTEM_CONFIG_LOOKUP.get(system.getSystem())).orElseThrow(() -> new IllegalArgumentException("Invalid system [" + system + "]"));
    }

    public MonitoringTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.clusterService = clusterService;
        this.monitoringTemplatesEnabled = (Boolean)MONITORING_TEMPLATES_ENABLED.get(nodeSettings);
    }

    public void initialize() {
        super.initialize();
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(MONITORING_TEMPLATES_ENABLED, this::updateEnabledSetting);
    }

    private void updateEnabledSetting(boolean newValue) {
        if (newValue) {
            this.monitoringTemplatesEnabled = true;
        } else {
            logger.info("monitoring templates [{}] will not be installed or reinstalled", (Object)this.getLegacyTemplateConfigs().stream().map(IndexTemplateConfig::getTemplateName).collect(Collectors.joining(",")));
            this.monitoringTemplatesEnabled = false;
        }
    }

    protected List<IndexTemplateConfig> getLegacyTemplateConfigs() {
        if (this.monitoringTemplatesEnabled) {
            return Arrays.asList(ALERTS_INDEX_TEMPLATE, BEATS_INDEX_TEMPLATE, ES_INDEX_TEMPLATE, KIBANA_INDEX_TEMPLATE, LOGSTASH_INDEX_TEMPLATE);
        }
        return Collections.emptyList();
    }

    protected String getOrigin() {
        return "monitoring";
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    static {
        MONITORED_SYSTEM_CONFIG_LOOKUP.put(MonitoredSystem.BEATS.getSystem(), BEATS_INDEX_TEMPLATE);
        MONITORED_SYSTEM_CONFIG_LOOKUP.put(MonitoredSystem.ES.getSystem(), ES_INDEX_TEMPLATE);
        MONITORED_SYSTEM_CONFIG_LOOKUP.put(MonitoredSystem.KIBANA.getSystem(), KIBANA_INDEX_TEMPLATE);
        MONITORED_SYSTEM_CONFIG_LOOKUP.put(MonitoredSystem.LOGSTASH.getSystem(), LOGSTASH_INDEX_TEMPLATE);
    }
}

