/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;
import org.elasticsearch.xpack.autoscaling.Autoscaling;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.action.PolicyValidator;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResults;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.capacity.memory.AutoscalingMemoryInfo;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class AutoscalingCalculateCapacityService
implements PolicyValidator {
    private final Map<String, AutoscalingDeciderService> deciderByName;

    public AutoscalingCalculateCapacityService(Set<AutoscalingDeciderService> deciders) {
        assert (deciders.size() >= 1);
        this.deciderByName = deciders.stream().collect(Collectors.toMap(AutoscalingDeciderService::name, Function.identity()));
    }

    @Override
    public void validate(AutoscalingPolicy policy) {
        policy.deciders().forEach((name, configuration) -> this.validate((String)name, (Settings)configuration, policy.roles()));
        SortedMap<String, Settings> deciders = this.addDefaultDeciders(policy);
        if (deciders.isEmpty()) {
            throw new IllegalArgumentException("no default nor user configured deciders for policy [" + policy.name() + "] with roles [" + policy.roles() + "]");
        }
    }

    private void validate(String deciderName, Settings configuration, SortedSet<String> roles) {
        AutoscalingDeciderService deciderService = this.deciderByName.get(deciderName);
        if (deciderService == null) {
            throw new IllegalArgumentException("unknown decider [" + deciderName + "]");
        }
        if (!this.appliesToPolicy(deciderService, roles)) {
            throw new IllegalArgumentException("decider [" + deciderName + "] not applicable to policy with roles [ " + roles + "]");
        }
        Map deciderSettings = deciderService.deciderSettings().stream().collect(Collectors.toMap(Setting::getKey, Function.identity()));
        configuration.keySet().forEach(key -> this.validateSetting((String)key, configuration, deciderSettings, deciderName));
    }

    private void validateSetting(String key, Settings configuration, Map<String, Setting<?>> deciderSettings, String decider) {
        Setting<?> setting = deciderSettings.get(key);
        if (setting == null) {
            throw new IllegalArgumentException("unknown setting [" + key + "] for decider [" + decider + "]");
        }
        setting.get(configuration);
    }

    public SortedMap<String, AutoscalingDeciderResults> calculate(ClusterState state, ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, AutoscalingMemoryInfo memoryInfo) {
        AutoscalingMetadata autoscalingMetadata = (AutoscalingMetadata)state.metadata().custom("autoscaling");
        if (autoscalingMetadata != null) {
            return new TreeMap<String, AutoscalingDeciderResults>(autoscalingMetadata.policies().entrySet().stream().map(e -> Tuple.tuple((Object)((String)e.getKey()), (Object)this.calculateForPolicy(((AutoscalingPolicyMetadata)((Object)((Object)e.getValue()))).policy(), state, clusterInfo, shardSizeInfo, memoryInfo))).collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
        }
        return new TreeMap<String, AutoscalingDeciderResults>();
    }

    private AutoscalingDeciderResults calculateForPolicy(AutoscalingPolicy policy, ClusterState state, ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, AutoscalingMemoryInfo memoryInfo) {
        if (this.hasUnknownRoles(policy)) {
            return new AutoscalingDeciderResults(AutoscalingCapacity.ZERO, Collections.emptySortedSet(), new TreeMap<String, AutoscalingDeciderResult>(Map.of("_unknown_role", new AutoscalingDeciderResult(null, null))));
        }
        SortedMap<String, Settings> deciders = this.addDefaultDeciders(policy);
        DefaultAutoscalingDeciderContext context = this.createContext(policy.roles(), state, clusterInfo, shardSizeInfo, memoryInfo);
        SortedMap results = deciders.entrySet().stream().map(entry -> Tuple.tuple((Object)((String)entry.getKey()), (Object)this.calculateForDecider((String)entry.getKey(), (Settings)entry.getValue(), context))).collect(Collectors.toMap(Tuple::v1, Tuple::v2, (a, b) -> {
            throw new UnsupportedOperationException();
        }, TreeMap::new));
        return new AutoscalingDeciderResults(context.currentCapacity, context.currentNodes, results);
    }

    private SortedMap<String, Settings> addDefaultDeciders(AutoscalingPolicy policy) {
        TreeMap<String, Settings> deciders = new TreeMap<String, Settings>(policy.deciders());
        this.deciderByName.entrySet().stream().filter(e -> this.defaultForPolicy((AutoscalingDeciderService)e.getValue(), policy.roles())).forEach(e -> deciders.putIfAbsent((String)e.getKey(), Settings.EMPTY));
        return deciders;
    }

    private boolean defaultForPolicy(AutoscalingDeciderService deciderService, SortedSet<String> roles) {
        if (deciderService.defaultOn()) {
            return this.appliesToPolicy(deciderService, roles);
        }
        return false;
    }

    private boolean appliesToPolicy(AutoscalingDeciderService deciderService, SortedSet<String> roles) {
        if (roles.isEmpty()) {
            return deciderService.appliesToEmptyRoles();
        }
        return deciderService.roles().stream().map(DiscoveryNodeRole::roleName).anyMatch(roles::contains);
    }

    DefaultAutoscalingDeciderContext createContext(SortedSet<String> roles, ClusterState state, ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, AutoscalingMemoryInfo memoryInfo) {
        return new DefaultAutoscalingDeciderContext(roles, state, clusterInfo, shardSizeInfo, memoryInfo);
    }

    private boolean hasUnknownRoles(AutoscalingPolicy policy) {
        return !DiscoveryNodeRole.roleNames().containsAll(policy.roles());
    }

    private AutoscalingDeciderResult calculateForDecider(String name, Settings configuration, AutoscalingDeciderContext context) {
        assert (this.deciderByName.containsKey(name));
        AutoscalingDeciderService service = this.deciderByName.get(name);
        return service.scale(configuration, context);
    }

    static class DefaultAutoscalingDeciderContext
    implements AutoscalingDeciderContext {
        private final SortedSet<DiscoveryNodeRole> roles;
        private final ClusterState state;
        private final ClusterInfo clusterInfo;
        private final SnapshotShardSizeInfo snapshotShardSizeInfo;
        private final AutoscalingMemoryInfo memoryInfo;
        private final SortedSet<DiscoveryNode> currentNodes;
        private final AutoscalingCapacity currentCapacity;
        private final boolean currentCapacityAccurate;

        DefaultAutoscalingDeciderContext(SortedSet<String> roles, ClusterState state, ClusterInfo clusterInfo, SnapshotShardSizeInfo snapshotShardSizeInfo, AutoscalingMemoryInfo memoryInfo) {
            this.roles = (SortedSet)roles.stream().map(DiscoveryNodeRole::getRoleFromRoleName).collect(Sets.toUnmodifiableSortedSet());
            Objects.requireNonNull(state);
            Objects.requireNonNull(clusterInfo);
            this.state = state;
            this.clusterInfo = clusterInfo;
            this.snapshotShardSizeInfo = snapshotShardSizeInfo;
            this.memoryInfo = memoryInfo;
            this.currentNodes = StreamSupport.stream(state.nodes().spliterator(), false).filter(this::rolesFilter).collect(Collectors.toCollection(() -> new TreeSet<DiscoveryNode>(AutoscalingDeciderResults.DISCOVERY_NODE_COMPARATOR)));
            this.currentCapacity = this.calculateCurrentCapacity();
            this.currentCapacityAccurate = this.calculateCurrentCapacityAccurate();
        }

        @Override
        public ClusterState state() {
            return this.state;
        }

        @Override
        public AutoscalingCapacity currentCapacity() {
            if (this.currentCapacityAccurate) {
                assert (this.currentCapacity.total().storage() != null);
                assert (this.currentCapacity.node().storage() != null);
                return this.currentCapacity;
            }
            return null;
        }

        @Override
        public Set<DiscoveryNode> nodes() {
            return this.currentNodes;
        }

        @Override
        public Set<DiscoveryNodeRole> roles() {
            return this.roles;
        }

        private boolean calculateCurrentCapacityAccurate() {
            return this.currentNodes.stream().allMatch(this::nodeHasAccurateCapacity);
        }

        private boolean nodeHasAccurateCapacity(DiscoveryNode node) {
            if (node.canContainData()) {
                DiskUsage mostAvailable = (DiskUsage)this.clusterInfo.getNodeMostAvailableDiskUsages().get((Object)node.getId());
                DiskUsage leastAvailable = (DiskUsage)this.clusterInfo.getNodeLeastAvailableDiskUsages().get((Object)node.getId());
                if (mostAvailable == null || !mostAvailable.getPath().equals(leastAvailable.getPath()) || this.totalStorage((ImmutableOpenMap<String, DiskUsage>)this.clusterInfo.getNodeMostAvailableDiskUsages(), node) < 0L) {
                    return false;
                }
            }
            return this.memoryInfo.get(node) != null;
        }

        private AutoscalingCapacity calculateCurrentCapacity() {
            return this.currentNodes.stream().map(this::resourcesFor).map(c -> new AutoscalingCapacity((AutoscalingCapacity.AutoscalingResources)c, (AutoscalingCapacity.AutoscalingResources)c)).reduce((c1, c2) -> new AutoscalingCapacity(AutoscalingCapacity.AutoscalingResources.sum(c1.total(), c2.total()), AutoscalingCapacity.AutoscalingResources.max(c1.node(), c2.node()))).orElse(AutoscalingCapacity.ZERO);
        }

        private AutoscalingCapacity.AutoscalingResources resourcesFor(DiscoveryNode node) {
            long storage = node.canContainData() ? Math.max(this.totalStorage((ImmutableOpenMap<String, DiskUsage>)this.clusterInfo.getNodeLeastAvailableDiskUsages(), node), this.totalStorage((ImmutableOpenMap<String, DiskUsage>)this.clusterInfo.getNodeMostAvailableDiskUsages(), node)) : 0L;
            Long memory = this.memoryInfo.get(node);
            return new AutoscalingCapacity.AutoscalingResources(storage == -1L ? ByteSizeValue.ZERO : new ByteSizeValue(storage), memory == null ? ByteSizeValue.ZERO : new ByteSizeValue(memory.longValue()));
        }

        private long totalStorage(ImmutableOpenMap<String, DiskUsage> diskUsages, DiscoveryNode node) {
            DiskUsage diskUsage = (DiskUsage)diskUsages.get((Object)node.getId());
            return diskUsage != null ? diskUsage.getTotalBytes() : -1L;
        }

        private boolean rolesFilter(DiscoveryNode discoveryNode) {
            return discoveryNode.getRoles().equals(this.roles);
        }

        @Override
        public ClusterInfo info() {
            return this.clusterInfo;
        }

        @Override
        public SnapshotShardSizeInfo snapshotShardSizeInfo() {
            return this.snapshotShardSizeInfo;
        }
    }

    public static class Holder {
        private final Autoscaling autoscaling;
        private final SetOnce<AutoscalingCalculateCapacityService> servicesSetOnce = new SetOnce();

        public Holder(Autoscaling autoscaling) {
            this.autoscaling = autoscaling;
        }

        public AutoscalingCalculateCapacityService get(AllocationDeciders allocationDeciders) {
            AutoscalingCalculateCapacityService autoscalingCalculateCapacityService = (AutoscalingCalculateCapacityService)this.servicesSetOnce.get();
            if (autoscalingCalculateCapacityService == null) {
                autoscalingCalculateCapacityService = new AutoscalingCalculateCapacityService(this.autoscaling.createDeciderServices(allocationDeciders));
                this.servicesSetOnce.set((Object)autoscalingCalculateCapacityService);
            }
            return autoscalingCalculateCapacityService;
        }
    }
}

