/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.history;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.watcher.history.WatchRecord;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class HistoryStore {
    private static final Logger logger = LogManager.getLogger(HistoryStore.class);
    private final BulkProcessor bulkProcessor;

    public HistoryStore(BulkProcessor bulkProcessor) {
        this.bulkProcessor = bulkProcessor;
    }

    public void put(WatchRecord watchRecord) throws Exception {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(".watcher-history-14").id(watchRecord.id().value()).source(builder);
            request.opType(DocWriteRequest.OpType.CREATE);
            this.bulkProcessor.add(request);
        }
        catch (IOException ioe) {
            throw Exceptions.ioException((String)"failed to persist watch record [{}]", (Throwable)ioe, (Object[])new Object[]{watchRecord});
        }
    }

    public void forcePut(WatchRecord watchRecord) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(".watcher-history-14").id(watchRecord.id().value()).source(builder);
            request.opType(DocWriteRequest.OpType.CREATE);
            this.bulkProcessor.add(request);
        }
        catch (IOException ioe) {
            WatchRecord wr = watchRecord;
            logger.error(() -> new ParameterizedMessage("failed to persist watch record [{}]", (Object)wr), (Throwable)ioe);
        }
    }

    public static boolean validate(ClusterState state) {
        IndexMetadata indexMetadata = WatchStoreUtils.getConcreteIndex(".watcher-history-14", state.metadata());
        return indexMetadata == null || indexMetadata.getState() == IndexMetadata.State.OPEN && state.routingTable().index(indexMetadata.getIndex()).allPrimaryShardsActive();
    }

    public void flush() {
        this.bulkProcessor.flush();
    }
}

