/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.slack.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.slack.message.Action;
import org.elasticsearch.xpack.watcher.notification.slack.message.Field;
import org.elasticsearch.xpack.watcher.notification.slack.message.MessageElement;
import org.elasticsearch.xpack.watcher.notification.slack.message.SlackMessageDefaults;

public class Attachment
implements MessageElement {
    final String fallback;
    final String color;
    final String pretext;
    final String authorName;
    final String authorLink;
    final String authorIcon;
    final String title;
    final String titleLink;
    final String text;
    final Field[] fields;
    final String imageUrl;
    final String thumbUrl;
    final String[] markdownSupportedFields;
    final List<Action> actions;

    public Attachment(String fallback, String color, String pretext, String authorName, String authorLink, String authorIcon, String title, String titleLink, String text, Field[] fields, String imageUrl, String thumbUrl, String[] markdownSupportedFields, List<Action> actions) {
        this.fallback = fallback;
        this.color = color;
        this.pretext = pretext;
        this.authorName = authorName;
        this.authorLink = authorLink;
        this.authorIcon = authorIcon;
        this.title = title;
        this.titleLink = titleLink;
        this.text = text;
        this.fields = fields;
        this.imageUrl = imageUrl;
        this.thumbUrl = thumbUrl;
        this.markdownSupportedFields = markdownSupportedFields;
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment that = (Attachment)o;
        return Objects.equals(this.fallback, that.fallback) && Objects.equals(this.color, that.color) && Objects.equals(this.pretext, that.pretext) && Objects.equals(this.authorName, that.authorName) && Objects.equals(this.authorLink, that.authorLink) && Objects.equals(this.authorIcon, that.authorIcon) && Objects.equals(this.title, that.title) && Objects.equals(this.titleLink, that.titleLink) && Objects.equals(this.text, that.text) && Objects.equals(this.imageUrl, that.imageUrl) && Objects.equals(this.thumbUrl, that.thumbUrl) && Objects.equals(this.actions, that.actions) && Arrays.equals(this.markdownSupportedFields, that.markdownSupportedFields) && Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.fields, this.imageUrl, this.thumbUrl, this.markdownSupportedFields, this.actions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.fallback != null) {
            builder.field(XField.FALLBACK.getPreferredName(), this.fallback);
        }
        if (this.color != null) {
            builder.field(XField.COLOR.getPreferredName(), this.color);
        }
        if (this.pretext != null) {
            builder.field(XField.PRETEXT.getPreferredName(), this.pretext);
        }
        if (this.authorName != null) {
            builder.field(XField.AUTHOR_NAME.getPreferredName(), this.authorName);
            if (this.authorLink != null) {
                builder.field(XField.AUTHOR_LINK.getPreferredName(), this.authorLink);
            }
            if (this.authorIcon != null) {
                builder.field(XField.AUTHOR_ICON.getPreferredName(), this.authorIcon);
            }
        }
        if (this.title != null) {
            builder.field(XField.TITLE.getPreferredName(), this.title);
            if (this.titleLink != null) {
                builder.field(XField.TITLE_LINK.getPreferredName(), this.titleLink);
            }
        }
        if (this.text != null) {
            builder.field(XField.TEXT.getPreferredName(), this.text);
        }
        if (this.fields != null) {
            builder.startArray(XField.FIELDS.getPreferredName());
            for (Field field : this.fields) {
                field.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.imageUrl != null) {
            builder.field(XField.IMAGE_URL.getPreferredName(), this.imageUrl);
        }
        if (this.thumbUrl != null) {
            builder.field(XField.THUMB_URL.getPreferredName(), this.thumbUrl);
        }
        if (this.markdownSupportedFields != null) {
            builder.startArray(XField.MARKDOWN_IN.getPreferredName());
            for (String string : this.markdownSupportedFields) {
                builder.value(string);
            }
            builder.endArray();
        }
        if (this.actions != null && !this.actions.isEmpty()) {
            builder.startArray("actions");
            for (Action action : this.actions) {
                action.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    static interface XField
    extends MessageElement.XField {
        public static final ParseField FALLBACK = new ParseField("fallback", new String[0]);
        public static final ParseField COLOR = new ParseField("color", new String[0]);
        public static final ParseField PRETEXT = new ParseField("pretext", new String[0]);
        public static final ParseField AUTHOR_NAME = new ParseField("author_name", new String[0]);
        public static final ParseField AUTHOR_LINK = new ParseField("author_link", new String[0]);
        public static final ParseField AUTHOR_ICON = new ParseField("author_icon", new String[0]);
        public static final ParseField TITLE_LINK = new ParseField("title_link", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
        public static final ParseField IMAGE_URL = new ParseField("image_url", new String[0]);
        public static final ParseField THUMB_URL = new ParseField("thumb_url", new String[0]);
        public static final ParseField MARKDOWN_IN = new ParseField("mrkdwn_in", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
    }

    static class Template
    implements ToXContentObject {
        final TextTemplate fallback;
        final TextTemplate color;
        final TextTemplate pretext;
        final TextTemplate authorName;
        final TextTemplate authorLink;
        final TextTemplate authorIcon;
        final TextTemplate title;
        final TextTemplate titleLink;
        final TextTemplate text;
        final Field.Template[] fields;
        final TextTemplate imageUrl;
        final TextTemplate thumbUrl;
        final TextTemplate[] markdownSupportedFields;
        final List<Action.Template> actions;

        Template(TextTemplate fallback, TextTemplate color, TextTemplate pretext, TextTemplate authorName, TextTemplate authorLink, TextTemplate authorIcon, TextTemplate title, TextTemplate titleLink, TextTemplate text, Field.Template[] fields, TextTemplate imageUrl, TextTemplate thumbUrl, TextTemplate[] markdownSupportedFields, List<Action.Template> actions) {
            this.fallback = fallback;
            this.color = color;
            this.pretext = pretext;
            this.authorName = authorName;
            this.authorLink = authorLink;
            this.authorIcon = authorIcon;
            this.title = title;
            this.titleLink = titleLink;
            this.text = text;
            this.fields = fields;
            this.imageUrl = imageUrl;
            this.thumbUrl = thumbUrl;
            this.markdownSupportedFields = markdownSupportedFields;
            this.actions = actions;
        }

        public Attachment render(TextTemplateEngine engine, Map<String, Object> model, SlackMessageDefaults.AttachmentDefaults defaults) {
            String fallback = this.fallback != null ? engine.render(this.fallback, model) : defaults.fallback;
            String color = this.color != null ? engine.render(this.color, model) : defaults.color;
            String pretext = this.pretext != null ? engine.render(this.pretext, model) : defaults.pretext;
            String authorName = this.authorName != null ? engine.render(this.authorName, model) : defaults.authorName;
            String authorLink = this.authorLink != null ? engine.render(this.authorLink, model) : defaults.authorLink;
            String authorIcon = this.authorIcon != null ? engine.render(this.authorIcon, model) : defaults.authorIcon;
            String title = this.title != null ? engine.render(this.title, model) : defaults.title;
            String titleLink = this.titleLink != null ? engine.render(this.titleLink, model) : defaults.titleLink;
            String text = this.text != null ? engine.render(this.text, model) : defaults.text;
            String imageUrl = this.imageUrl != null ? engine.render(this.imageUrl, model) : defaults.imageUrl;
            String thumbUrl = this.thumbUrl != null ? engine.render(this.thumbUrl, model) : defaults.thumbUrl;
            Field[] fields = null;
            if (this.fields != null) {
                fields = new Field[this.fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = this.fields[i].render(engine, model, defaults.field);
                }
            }
            String[] markdownFields = null;
            if (this.markdownSupportedFields != null) {
                markdownFields = new String[this.markdownSupportedFields.length];
                for (int i = 0; i < this.markdownSupportedFields.length; ++i) {
                    markdownFields[i] = engine.render(this.markdownSupportedFields[i], model);
                }
            }
            ArrayList<Action> actions = new ArrayList<Action>();
            if (this.actions != null && !this.actions.isEmpty()) {
                for (Action.Template action : this.actions) {
                    actions.add(action.render(engine, model));
                }
            }
            return new Attachment(fallback, color, pretext, authorName, authorLink, authorIcon, title, titleLink, text, fields, imageUrl, thumbUrl, markdownFields, actions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.fallback, template.fallback) && Objects.equals(this.color, template.color) && Objects.equals(this.pretext, template.pretext) && Objects.equals(this.authorName, template.authorName) && Objects.equals(this.authorLink, template.authorLink) && Objects.equals(this.authorIcon, template.authorIcon) && Objects.equals(this.title, template.title) && Objects.equals(this.titleLink, template.titleLink) && Objects.equals(this.text, template.text) && Objects.equals(this.imageUrl, template.imageUrl) && Objects.equals(this.thumbUrl, template.thumbUrl) && Objects.equals(this.actions, template.actions) && Arrays.equals(this.fields, template.fields) && Arrays.equals(this.markdownSupportedFields, template.markdownSupportedFields);
        }

        public int hashCode() {
            return Objects.hash(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.fields, this.imageUrl, this.thumbUrl, this.markdownSupportedFields, this.actions);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.fallback != null) {
                builder.field(XField.FALLBACK.getPreferredName(), (ToXContent)this.fallback, params);
            }
            if (this.color != null) {
                builder.field(XField.COLOR.getPreferredName(), (ToXContent)this.color, params);
            }
            if (this.pretext != null) {
                builder.field(XField.PRETEXT.getPreferredName(), (ToXContent)this.pretext, params);
            }
            if (this.authorName != null) {
                builder.field(XField.AUTHOR_NAME.getPreferredName(), (ToXContent)this.authorName, params);
                if (this.authorLink != null) {
                    builder.field(XField.AUTHOR_LINK.getPreferredName(), (ToXContent)this.authorLink, params);
                }
                if (this.authorIcon != null) {
                    builder.field(XField.AUTHOR_ICON.getPreferredName(), (ToXContent)this.authorIcon, params);
                }
            }
            if (this.title != null) {
                builder.field(XField.TITLE.getPreferredName(), (ToXContent)this.title, params);
                if (this.titleLink != null) {
                    builder.field(XField.TITLE_LINK.getPreferredName(), (ToXContent)this.titleLink, params);
                }
            }
            if (this.text != null) {
                builder.field(XField.TEXT.getPreferredName(), (ToXContent)this.text, params);
            }
            if (this.fields != null) {
                builder.startArray(XField.FIELDS.getPreferredName());
                for (Field.Template template : this.fields) {
                    template.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.imageUrl != null) {
                builder.field(XField.IMAGE_URL.getPreferredName(), (ToXContent)this.imageUrl, params);
            }
            if (this.thumbUrl != null) {
                builder.field(XField.THUMB_URL.getPreferredName(), (ToXContent)this.thumbUrl, params);
            }
            if (this.markdownSupportedFields != null) {
                builder.startArray(XField.MARKDOWN_IN.getPreferredName());
                for (TextTemplate textTemplate : this.markdownSupportedFields) {
                    textTemplate.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.actions != null && !this.actions.isEmpty()) {
                builder.startArray(XField.ACTIONS.getPreferredName());
                for (Action.Template action : this.actions) {
                    action.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder.endObject();
        }

        public static Template parse(XContentParser parser) throws IOException {
            TextTemplate fallback = null;
            TextTemplate color = null;
            TextTemplate pretext = null;
            TextTemplate authorName = null;
            TextTemplate authorLink = null;
            TextTemplate authorIcon = null;
            TextTemplate title = null;
            TextTemplate titleLink = null;
            TextTemplate text = null;
            Field.Template[] fields = null;
            TextTemplate imageUrl = null;
            TextTemplate thumbUrl = null;
            TextTemplate[] markdownFields = null;
            ArrayList<Action.Template> actions = new ArrayList<Action.Template>();
            XContentParser.Token token = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                ArrayList<Object> list;
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (XField.FALLBACK.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        fallback = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.FALLBACK});
                    }
                }
                if (XField.COLOR.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        color = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.COLOR});
                    }
                }
                if (XField.PRETEXT.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        pretext = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.PRETEXT});
                    }
                }
                if (XField.AUTHOR_NAME.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        authorName = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.AUTHOR_NAME});
                    }
                }
                if (XField.AUTHOR_LINK.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        authorLink = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.AUTHOR_LINK});
                    }
                }
                if (XField.AUTHOR_ICON.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        authorIcon = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.AUTHOR_ICON});
                    }
                }
                if (XField.TITLE.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        title = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TITLE});
                    }
                }
                if (XField.TITLE_LINK.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        titleLink = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TITLE_LINK});
                    }
                }
                if (XField.TEXT.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        text = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TEXT});
                    }
                }
                if (XField.FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.START_ARRAY) {
                        list = new ArrayList<Object>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            try {
                                list.add(Field.Template.parse(parser));
                            }
                            catch (ElasticsearchParseException pe) {
                                throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.FIELDS});
                            }
                        }
                        fields = list.toArray(new Field.Template[list.size()]);
                        continue;
                    }
                    try {
                        fields = new Field.Template[]{Field.Template.parse(parser)};
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.FIELDS});
                    }
                }
                if (XField.IMAGE_URL.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        imageUrl = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.IMAGE_URL});
                    }
                }
                if (XField.THUMB_URL.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        thumbUrl = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.THUMB_URL});
                    }
                }
                if (XField.MARKDOWN_IN.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.START_ARRAY) {
                        list = new ArrayList();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            try {
                                list.add(new TextTemplate(parser.text()));
                            }
                            catch (ElasticsearchParseException pe) {
                                throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.MARKDOWN_IN});
                            }
                        }
                        markdownFields = list.toArray(new TextTemplate[list.size()]);
                        continue;
                    }
                    try {
                        markdownFields = new TextTemplate[]{new TextTemplate(parser.text())};
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.MARKDOWN_IN});
                    }
                }
                if (XField.ACTIONS.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token != XContentParser.Token.START_OBJECT) continue;
                    actions.add((Action.Template)Action.ACTION_PARSER.parse(parser, null));
                    continue;
                }
                throw new ElasticsearchParseException("could not parse message attachment field. unexpected field [{}]", new Object[]{currentFieldName});
            }
            if (authorName == null) {
                if (authorLink != null) {
                    throw new ElasticsearchParseException("could not parse message attachment field. found field [{}], but no [{}] is defined", new Object[]{XField.AUTHOR_LINK, XField.AUTHOR_NAME});
                }
                if (authorIcon != null) {
                    throw new ElasticsearchParseException("could not parse message attachment field. found field [{}], but no [{}] is defined", new Object[]{XField.AUTHOR_ICON, XField.AUTHOR_NAME});
                }
            }
            if (title == null && titleLink != null) {
                throw new ElasticsearchParseException("could not parse message attachment field. found field [{}], but no [{}] is defined", new Object[]{XField.TITLE_LINK, XField.TITLE});
            }
            return new Template(fallback, color, pretext, authorName, authorLink, authorIcon, title, titleLink, text, fields, imageUrl, thumbUrl, markdownFields, actions);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private TextTemplate fallback;
            private TextTemplate color;
            private TextTemplate pretext;
            private TextTemplate authorName;
            private TextTemplate authorLink;
            private TextTemplate authorIcon;
            private TextTemplate title;
            private TextTemplate titleLink;
            private TextTemplate text;
            private List<Field.Template> fields = new ArrayList<Field.Template>();
            private TextTemplate imageUrl;
            private TextTemplate thumbUrl;
            private List<TextTemplate> markdownFields = new ArrayList<TextTemplate>();
            private List<Action.Template> actions = new ArrayList<Action.Template>();

            private Builder() {
            }

            public Builder setFallback(TextTemplate fallback) {
                this.fallback = fallback;
                return this;
            }

            public Builder setFallback(String fallback) {
                return this.setFallback(new TextTemplate(fallback));
            }

            public Builder setColor(TextTemplate color) {
                this.color = color;
                return this;
            }

            public Builder setColor(String color) {
                return this.setColor(new TextTemplate(color));
            }

            public Builder setPretext(TextTemplate pretext) {
                this.pretext = pretext;
                return this;
            }

            public Builder setPretext(String pretext) {
                return this.setPretext(new TextTemplate(pretext));
            }

            public Builder setAuthorName(TextTemplate authorName) {
                this.authorName = authorName;
                return this;
            }

            public Builder setAuthorName(String authorName) {
                return this.setAuthorName(new TextTemplate(authorName));
            }

            public Builder setAuthorLink(TextTemplate authorLink) {
                this.authorLink = authorLink;
                return this;
            }

            public Builder setAuthorLink(String authorLink) {
                return this.setAuthorLink(new TextTemplate(authorLink));
            }

            public Builder setAuthorIcon(TextTemplate authorIcon) {
                this.authorIcon = authorIcon;
                return this;
            }

            public Builder setAuthorIcon(String authorIcon) {
                return this.setAuthorIcon(new TextTemplate(authorIcon));
            }

            public Builder setTitle(TextTemplate title) {
                this.title = title;
                return this;
            }

            public Builder setTitle(String title) {
                return this.setTitle(new TextTemplate(title));
            }

            public Builder setTitleLink(TextTemplate titleLink) {
                this.titleLink = titleLink;
                return this;
            }

            public Builder setTitleLink(String titleLink) {
                return this.setTitleLink(new TextTemplate(titleLink));
            }

            public Builder setText(TextTemplate text) {
                this.text = text;
                return this;
            }

            public Builder setText(String text) {
                return this.setText(new TextTemplate(text));
            }

            public Builder addField(TextTemplate title, TextTemplate value, boolean isShort) {
                this.fields.add(new Field.Template(title, value, isShort));
                return this;
            }

            public Builder addField(String title, String value, boolean isShort) {
                return this.addField(new TextTemplate(title), new TextTemplate(value), isShort);
            }

            public Builder setImageUrl(TextTemplate imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder setImageUrl(String imageUrl) {
                return this.setImageUrl(new TextTemplate(imageUrl));
            }

            public Builder setThumbUrl(TextTemplate thumbUrl) {
                this.thumbUrl = thumbUrl;
                return this;
            }

            public Builder setThumbUrl(String thumbUrl) {
                return this.setThumbUrl(new TextTemplate(thumbUrl));
            }

            public Builder addMarkdownField(String name) {
                this.markdownFields.add(new TextTemplate(name));
                return this;
            }

            public Builder addAction(Action.Template action) {
                this.actions.add(action);
                return this;
            }

            public Template build() {
                Field.Template[] fields = this.fields.isEmpty() ? null : this.fields.toArray(new Field.Template[this.fields.size()]);
                TextTemplate[] markdownFields = this.markdownFields.isEmpty() ? null : this.markdownFields.toArray(new TextTemplate[this.markdownFields.size()]);
                return new Template(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, fields, this.imageUrl, this.thumbUrl, markdownFields, this.actions);
            }
        }
    }
}

