/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.watcher.Watcher;

public class WatcherIndexTemplateRegistry
extends IndexTemplateRegistry {
    public static final String WATCHER_TEMPLATE_VERSION_VARIABLE = "xpack.watcher.template.version";
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY = new IndexTemplateConfig(".watch-history-14", "/watch-history.json", 14, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM = new IndexTemplateConfig(".watch-history-no-ilm-14", "/watch-history-no-ilm.json", 14, "xpack.watcher.template.version");
    public static final LifecyclePolicyConfig POLICY_WATCH_HISTORY = new LifecyclePolicyConfig("watch-history-ilm-policy", "/watch-history-ilm-policy.json");
    private final List<IndexTemplateConfig> templatesToUse;

    public WatcherIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        boolean ilmManagementEnabled = (Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(nodeSettings);
        this.templatesToUse = Collections.singletonList(ilmManagementEnabled ? TEMPLATE_CONFIG_WATCH_HISTORY : TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM);
    }

    protected List<IndexTemplateConfig> getComposableTemplateConfigs() {
        return this.templatesToUse;
    }

    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        if (!((Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(this.settings)).booleanValue()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(POLICY_WATCH_HISTORY);
    }

    protected String getOrigin() {
        return "watcher";
    }

    public static boolean validate(ClusterState state) {
        return state.getMetadata().templatesV2().containsKey(".watch-history-14") || state.getMetadata().templatesV2().containsKey(".watch-history-no-ilm-14") || state.getMetadata().templatesV2().containsKey(".watch-history-12") || state.getMetadata().templatesV2().containsKey(".watch-history-no-ilm-12") || state.getMetadata().templatesV2().containsKey(".watch-history-13") || state.getMetadata().templatesV2().containsKey(".watch-history-no-ilm-13");
    }

    protected boolean requiresMasterNode() {
        return true;
    }
}

