/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.watcher.WatcherMetadata;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsResponse;
import org.elasticsearch.xpack.watcher.WatcherLifeCycleService;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class TransportWatcherStatsAction
extends TransportNodesAction<WatcherStatsRequest, WatcherStatsResponse, WatcherStatsRequest.Node, WatcherStatsResponse.Node> {
    private final ExecutionService executionService;
    private final TriggerService triggerService;
    private final WatcherLifeCycleService lifeCycleService;

    @Inject
    public TransportWatcherStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, WatcherLifeCycleService lifeCycleService, ExecutionService executionService, TriggerService triggerService) {
        super("cluster:monitor/xpack/watcher/stats/dist", threadPool, clusterService, transportService, actionFilters, WatcherStatsRequest::new, WatcherStatsRequest.Node::new, "management", WatcherStatsResponse.Node.class);
        this.lifeCycleService = lifeCycleService;
        this.executionService = executionService;
        this.triggerService = triggerService;
    }

    protected WatcherStatsResponse newResponse(WatcherStatsRequest request, List<WatcherStatsResponse.Node> nodes, List<FailedNodeException> failures) {
        return new WatcherStatsResponse(this.clusterService.getClusterName(), this.getWatcherMetadata(), nodes, failures);
    }

    protected WatcherStatsRequest.Node newNodeRequest(WatcherStatsRequest request) {
        return new WatcherStatsRequest.Node(request);
    }

    protected WatcherStatsResponse.Node newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new WatcherStatsResponse.Node(in);
    }

    protected WatcherStatsResponse.Node nodeOperation(WatcherStatsRequest.Node request, Task task) {
        WatcherStatsResponse.Node statsResponse = new WatcherStatsResponse.Node(this.clusterService.localNode());
        statsResponse.setWatcherState(this.lifeCycleService.getState().get());
        statsResponse.setThreadPoolQueueSize(this.executionService.executionThreadPoolQueueSize());
        statsResponse.setThreadPoolMaxSize(this.executionService.executionThreadPoolMaxSize());
        if (request.includeCurrentWatches()) {
            statsResponse.setSnapshots(this.executionService.currentExecutions());
        }
        if (request.includeQueuedWatches()) {
            statsResponse.setQueuedWatches(this.executionService.queuedWatches());
        }
        if (request.includeStats()) {
            Counters stats = Counters.merge(Arrays.asList(this.triggerService.stats(), this.executionService.executionTimes()));
            statsResponse.setStats(stats);
        }
        statsResponse.setWatchesCount(this.triggerService.count());
        return statsResponse;
    }

    private WatcherMetadata getWatcherMetadata() {
        WatcherMetadata watcherMetadata = (WatcherMetadata)this.clusterService.state().getMetadata().custom("watcher");
        if (watcherMetadata == null) {
            watcherMetadata = new WatcherMetadata(false);
        }
        return watcherMetadata;
    }
}

