/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.encrypted;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public final class PrefixInputStream
extends InputStream {
    private final InputStream source;
    private final int prefixLength;
    private int count;
    private boolean closeSource;
    private boolean closed;

    public PrefixInputStream(InputStream source, int prefixLength, boolean closeSource) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("The prefixLength constructor argument must be a positive integer");
        }
        this.source = source;
        this.prefixLength = prefixLength;
        this.count = 0;
        this.closeSource = closeSource;
        this.closed = false;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.remainingPrefixByteCount() <= 0) {
            return -1;
        }
        int byteVal = this.source.read();
        if (byteVal == -1) {
            return -1;
        }
        ++this.count;
        return byteVal;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        if (this.remainingPrefixByteCount() <= 0) {
            return -1;
        }
        int readSize = Math.min(len, this.remainingPrefixByteCount());
        int bytesRead = this.source.read(b, off, readSize);
        if (bytesRead == -1) {
            return -1;
        }
        this.count += bytesRead;
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L || this.remainingPrefixByteCount() <= 0) {
            return 0L;
        }
        long bytesToSkip = Math.min(n, (long)this.remainingPrefixByteCount());
        assert (bytesToSkip > 0L);
        long bytesSkipped = this.source.skip(bytesToSkip);
        this.count = (int)((long)this.count + bytesSkipped);
        return bytesSkipped;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return Math.min(this.remainingPrefixByteCount(), this.source.available());
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.closeSource) {
            this.source.close();
        }
    }

    private int remainingPrefixByteCount() {
        return this.prefixLength - this.count;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream has been closed");
        }
    }
}

