/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.normalize;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class NormalizePipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;
    private final Function<double[], DoubleUnaryOperator> methodSupplier;

    NormalizePipelineAggregator(String name, String[] bucketsPaths, DocValueFormat formatter, Function<double[], DoubleUnaryOperator> methodSupplier, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
        this.methodSupplier = methodSupplier;
    }

    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation originalAgg = (InternalMultiBucketAggregation)aggregation;
        List buckets = originalAgg.getBuckets();
        ArrayList<InternalMultiBucketAggregation.InternalBucket> newBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>(buckets.size());
        double[] values = buckets.stream().mapToDouble(bucket -> BucketHelpers.resolveBucketValue((MultiBucketsAggregation)originalAgg, (InternalMultiBucketAggregation.InternalBucket)bucket, (String)this.bucketsPaths()[0], (BucketHelpers.GapPolicy)BucketHelpers.GapPolicy.SKIP)).toArray();
        DoubleUnaryOperator method = this.methodSupplier.apply(values);
        for (int i = 0; i < buckets.size(); ++i) {
            InternalMultiBucketAggregation.InternalBucket bucket2 = (InternalMultiBucketAggregation.InternalBucket)buckets.get(i);
            double normalizedBucketValue = Double.isNaN(values[i]) ? Double.NaN : method.applyAsDouble(values[i]);
            List aggs = StreamSupport.stream(bucket2.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
            aggs.add(new InternalSimpleValue(this.name(), normalizedBucketValue, this.formatter, this.metadata()));
            InternalMultiBucketAggregation.InternalBucket newBucket = originalAgg.createBucket(InternalAggregations.from(aggs), bucket2);
            newBuckets.add(newBucket);
        }
        return originalAgg.create(newBuckets);
    }
}

